% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-metrics.R
\name{strings_sizes}
\alias{strings_sizes}
\title{Compute strings sizes}
\usage{
strings_sizes(
  x,
  fontname = "sans",
  fontsize = 10,
  bold = FALSE,
  italic = FALSE
)
}
\arguments{
\item{x}{A character vector of strings to measure. All arguments are vectorized
and recycled to match the length of \code{x}.}

\item{fontname}{A character vector specifying the font family name (e.g., "sans", "serif", "mono").
Default is "sans". This argument is vectorized.}

\item{fontsize}{A numeric vector specifying the font size in points.
Default is 10. This argument is vectorized.}

\item{bold}{A logical vector indicating whether the text should be bold.
Default is FALSE. This argument is vectorized.}

\item{italic}{A logical vector indicating whether the text should be italic.
Default is FALSE. This argument is vectorized.}
}
\description{
Determines widths, ascent and descent in inches.
Font lookup is performed by 'systemfonts' (so any font
registered via \code{\link[systemfonts:register_font]{systemfonts::register_font()}},
\code{\link[=register_gfont]{register_gfont()}}, or \code{\link[=font_set]{font_set()}} is found), then Cairo
computes the actual metrics. The results are accurate for
devices whose rendering finds the same font -- this is
guaranteed for 'systemfonts'-based devices (ragg, svglite,
ggiraph) and true for Cairo devices (\code{cairo_pdf()}, ...) when
the font is also installed at the system level. For devices
with their own font engine (\code{pdf()}, \code{png()}, ...) the
metrics may not match the rendering.
}
\examples{
strings_sizes(letters)
strings_sizes("Hello World!", bold = TRUE, italic = FALSE,
  fontname = "sans", fontsize = 12)
}
\seealso{
Other functions for font metrics: 
\code{\link{m_str_extents}()},
\code{\link{str_metrics}()}
}
\concept{functions for font metrics}
