% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{TCGAquery_SampleTypes}
\alias{TCGAquery_SampleTypes}
\title{Retrieve multiple tissue types not from the same patients.}
\usage{
TCGAquery_SampleTypes(barcode, typesample)
}
\arguments{
\item{barcode}{is a list of samples as TCGA barcodes}

\item{typesample}{a character vector indicating tissue type to query.
Example:
\tabular{ll}{
TP \tab   PRIMARY SOLID TUMOR \cr
TR \tab   RECURRENT SOLID TUMOR \cr
TB \tab   Primary Blood Derived Cancer-Peripheral Blood \cr
TRBM \tab Recurrent Blood Derived Cancer-Bone Marrow \cr
TAP \tab  Additional-New Primary \cr
TM \tab   Metastatic \cr
TAM \tab  Additional Metastatic \cr
THOC \tab Human Tumor Original Cells \cr
TBM \tab  Primary Blood Derived Cancer-Bone Marrow \cr
NB \tab   Blood Derived Normal \cr
NT \tab   Solid Tissue Normal \cr
NBC \tab  Buccal Cell Normal \cr
NEBV \tab EBV Immortalized Normal \cr
NBM \tab  Bone Marrow Normal \cr
}}
}
\value{
a list of samples / barcode filtered by type sample selected
}
\description{
TCGAquery_SampleTypes for a given list of samples and types,
   return the union of samples that are from theses type.
}
\examples{
# selection of normal samples "NT"
barcode <- c("TCGA-B0-4698-01Z-00-DX1","TCGA-CZ-4863-02Z-00-DX1")
# Returns the second barcode
 TCGAquery_SampleTypes(barcode,"TR")
 # Returns both barcode
 TCGAquery_SampleTypes(barcode,c("TR","TP"))
 barcode <- c("TARGET-20-PANSBH-14A-02D","TARGET-20-PANSBH-01A-02D",
              "TCGA-B0-4698-01Z-00-DX1","TCGA-CZ-4863-02Z-00-DX1")
  TCGAquery_SampleTypes(barcode,c("TR","TP"))
}
