# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import Type

if TYPE_CHECKING:
    from .. import models as _models


class BaseExportModel(_model_base.Model):
    """The base export parameter.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExportQuery, ExportResource, ExportResourceGroup

    All required parameters must be populated in order to send to server.

    :ivar type: The parameter type. Required. Known values are: "ExportResource",
     "ExportResourceGroup", and "ExportQuery".
    :vartype type: str or ~azure.mgmt.terraform.models.Type
    :ivar target_provider: The target Azure Terraform Provider. Known values are: "azurerm" and
     "azapi".
    :vartype target_provider: str or ~azure.mgmt.terraform.models.TargetProvider
    :ivar full_properties: Whether to output all non-computed properties in the generated Terraform
     configuration? This probably needs manual modifications to make it valid.
    :vartype full_properties: bool
    :ivar mask_sensitive: Mask sensitive attributes in the Terraform configuration.
    :vartype mask_sensitive: bool
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    type: str = rest_discriminator(name="type")
    """The parameter type. Required. Known values are: \"ExportResource\", \"ExportResourceGroup\",
     and \"ExportQuery\"."""
    target_provider: Optional[Union[str, "_models.TargetProvider"]] = rest_field(name="targetProvider")
    """The target Azure Terraform Provider. Known values are: \"azurerm\" and \"azapi\"."""
    full_properties: Optional[bool] = rest_field(name="fullProperties")
    """Whether to output all non-computed properties in the generated Terraform configuration? This
     probably needs manual modifications to make it valid."""
    mask_sensitive: Optional[bool] = rest_field(name="maskSensitive")
    """Mask sensitive attributes in the Terraform configuration."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        target_provider: Optional[Union[str, "_models.TargetProvider"]] = None,
        full_properties: Optional[bool] = None,
        mask_sensitive: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.terraform.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.terraform.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.terraform.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportQuery(BaseExportModel, discriminator="ExportQuery"):
    """Export parameter for resources queried by ARG (Azure Resource Graph).

    All required parameters must be populated in order to send to server.

    :ivar target_provider: The target Azure Terraform Provider. Known values are: "azurerm" and
     "azapi".
    :vartype target_provider: str or ~azure.mgmt.terraform.models.TargetProvider
    :ivar full_properties: Whether to output all non-computed properties in the generated Terraform
     configuration? This probably needs manual modifications to make it valid.
    :vartype full_properties: bool
    :ivar mask_sensitive: Mask sensitive attributes in the Terraform configuration.
    :vartype mask_sensitive: bool
    :ivar query: The ARG where predicate. Note that you can combine multiple conditions in one
     ``where`` predicate, e.g. ``resourceGroup =~ "my-rg" and type =~
     "microsoft.network/virtualnetworks"``. Required.
    :vartype query: str
    :ivar name_pattern: The name pattern of the Terraform resources.
    :vartype name_pattern: str
    :ivar recursive: Whether to recursively list child resources of the query result.
    :vartype recursive: bool
    :ivar type: The parameter type. Required.
    :vartype type: str or ~azure.mgmt.terraform.models.EXPORT_QUERY
    """

    query: str = rest_field()
    """The ARG where predicate. Note that you can combine multiple conditions in one ``where``
     predicate, e.g. ``resourceGroup =~ \"my-rg\" and type =~
     \"microsoft.network/virtualnetworks\"``. Required."""
    name_pattern: Optional[str] = rest_field(name="namePattern")
    """The name pattern of the Terraform resources."""
    recursive: Optional[bool] = rest_field()
    """Whether to recursively list child resources of the query result."""
    type: Literal[Type.EXPORT_QUERY] = rest_discriminator(name="type")  # type: ignore
    """The parameter type. Required."""

    @overload
    def __init__(
        self,
        *,
        query: str,
        target_provider: Optional[Union[str, "_models.TargetProvider"]] = None,
        full_properties: Optional[bool] = None,
        mask_sensitive: Optional[bool] = None,
        name_pattern: Optional[str] = None,
        recursive: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=Type.EXPORT_QUERY, **kwargs)


class ExportResource(BaseExportModel, discriminator="ExportResource"):
    """Export parameter for individual resources.

    All required parameters must be populated in order to send to server.

    :ivar target_provider: The target Azure Terraform Provider. Known values are: "azurerm" and
     "azapi".
    :vartype target_provider: str or ~azure.mgmt.terraform.models.TargetProvider
    :ivar full_properties: Whether to output all non-computed properties in the generated Terraform
     configuration? This probably needs manual modifications to make it valid.
    :vartype full_properties: bool
    :ivar mask_sensitive: Mask sensitive attributes in the Terraform configuration.
    :vartype mask_sensitive: bool
    :ivar resource_ids: The id of the resource to be exported. Required.
    :vartype resource_ids: list[str]
    :ivar resource_name: The Terraform resource name. Only works when ``resourceIds`` contains only
     one item.
    :vartype resource_name: str
    :ivar resource_type: The Terraform resource type. Only works when ``resourceIds`` contains only
     one item.
    :vartype resource_type: str
    :ivar name_pattern: The name pattern of the Terraform resources.
    :vartype name_pattern: str
    :ivar type: The parameter type. Required.
    :vartype type: str or ~azure.mgmt.terraform.models.EXPORT_RESOURCE
    """

    resource_ids: List[str] = rest_field(name="resourceIds")
    """The id of the resource to be exported. Required."""
    resource_name: Optional[str] = rest_field(name="resourceName")
    """The Terraform resource name. Only works when ``resourceIds`` contains only one item."""
    resource_type: Optional[str] = rest_field(name="resourceType")
    """The Terraform resource type. Only works when ``resourceIds`` contains only one item."""
    name_pattern: Optional[str] = rest_field(name="namePattern")
    """The name pattern of the Terraform resources."""
    type: Literal[Type.EXPORT_RESOURCE] = rest_discriminator(name="type")  # type: ignore
    """The parameter type. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_ids: List[str],
        target_provider: Optional[Union[str, "_models.TargetProvider"]] = None,
        full_properties: Optional[bool] = None,
        mask_sensitive: Optional[bool] = None,
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        name_pattern: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=Type.EXPORT_RESOURCE, **kwargs)


class ExportResourceGroup(BaseExportModel, discriminator="ExportResourceGroup"):
    """Export parameter for a resource group.

    All required parameters must be populated in order to send to server.

    :ivar target_provider: The target Azure Terraform Provider. Known values are: "azurerm" and
     "azapi".
    :vartype target_provider: str or ~azure.mgmt.terraform.models.TargetProvider
    :ivar full_properties: Whether to output all non-computed properties in the generated Terraform
     configuration? This probably needs manual modifications to make it valid.
    :vartype full_properties: bool
    :ivar mask_sensitive: Mask sensitive attributes in the Terraform configuration.
    :vartype mask_sensitive: bool
    :ivar resource_group_name: The name of the resource group to be exported. Required.
    :vartype resource_group_name: str
    :ivar name_pattern: The name pattern of the Terraform resources.
    :vartype name_pattern: str
    :ivar type: The parameter type. Required.
    :vartype type: str or ~azure.mgmt.terraform.models.EXPORT_RESOURCE_GROUP
    """

    resource_group_name: str = rest_field(name="resourceGroupName")
    """The name of the resource group to be exported. Required."""
    name_pattern: Optional[str] = rest_field(name="namePattern")
    """The name pattern of the Terraform resources."""
    type: Literal[Type.EXPORT_RESOURCE_GROUP] = rest_discriminator(name="type")  # type: ignore
    """The parameter type. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_group_name: str,
        target_provider: Optional[Union[str, "_models.TargetProvider"]] = None,
        full_properties: Optional[bool] = None,
        mask_sensitive: Optional[bool] = None,
        name_pattern: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=Type.EXPORT_RESOURCE_GROUP, **kwargs)


class ExportResult(_model_base.Model):
    """The Terraform export result.

    :ivar configuration: The Terraform configuration content.
    :vartype configuration: str
    :ivar skipped_resources: A list of Azure resources which are not exported to Terraform due to
     there is no corresponding resources in Terraform.
    :vartype skipped_resources: list[str]
    :ivar errors: A list of errors derived during exporting each resource.
    :vartype errors: list[~azure.mgmt.terraform.models.ErrorDetail]
    """

    configuration: Optional[str] = rest_field()
    """The Terraform configuration content."""
    skipped_resources: Optional[List[str]] = rest_field(name="skippedResources")
    """A list of Azure resources which are not exported to Terraform due to there is no corresponding
     resources in Terraform."""
    errors: Optional[List["_models.ErrorDetail"]] = rest_field()
    """A list of errors derived during exporting each resource."""

    @overload
    def __init__(
        self,
        *,
        configuration: Optional[str] = None,
        skipped_resources: Optional[List[str]] = None,
        errors: Optional[List["_models.ErrorDetail"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.terraform.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.terraform.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.terraform.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class TerraformOperationStatus(_model_base.Model):
    """The status of the LRO operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar properties: RP-specific properties for the operationStatus resource, only appears when
     operation ended with Succeeded status.
    :vartype properties: ~azure.mgmt.terraform.models.ExportResult
    :ivar status: The operation status. Required. Known values are: "Succeeded", "Failed", and
     "Canceled".
    :vartype status: str or ~azure.mgmt.terraform.models.ResourceProvisioningState
    :ivar name: The name of the  operationStatus resource.
    :vartype name: str
    :ivar start_time: Operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Operation complete time.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The progress made toward completing the operation.
    :vartype percent_complete: float
    :ivar error: Errors that occurred if the operation ended with Canceled or Failed status.
    :vartype error: ~azure.mgmt.terraform.models.ErrorDetail
    """

    properties: Optional["_models.ExportResult"] = rest_field(visibility=["read"])
    """RP-specific properties for the operationStatus resource, only appears when operation ended with
     Succeeded status."""
    status: Union[str, "_models.ResourceProvisioningState"] = rest_field()
    """The operation status. Required. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the  operationStatus resource."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """Operation start time."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """Operation complete time."""
    percent_complete: Optional[float] = rest_field(name="percentComplete", visibility=["read"])
    """The progress made toward completing the operation."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read"])
    """Errors that occurred if the operation ended with Canceled or Failed status."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.ResourceProvisioningState"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
