# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerinstance.aio import ContainerInstanceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerInstanceManagementContainerGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerInstanceManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.container_groups.list(
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.container_groups.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.container_groups.get(
            resource_group_name=resource_group.name,
            container_group_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.container_groups.begin_create_or_update(
                resource_group_name=resource_group.name,
                container_group_name="str",
                container_group={
                    "containers": [
                        {
                            "name": "str",
                            "command": ["str"],
                            "configMap": {"keyValuePairs": {"str": "str"}},
                            "environmentVariables": [{"name": "str", "secureValue": "str", "value": "str"}],
                            "image": "str",
                            "instanceView": {
                                "currentState": {
                                    "detailStatus": "str",
                                    "exitCode": 0,
                                    "finishTime": "2020-02-20 00:00:00",
                                    "startTime": "2020-02-20 00:00:00",
                                    "state": "str",
                                },
                                "events": [
                                    {
                                        "count": 0,
                                        "firstTimestamp": "2020-02-20 00:00:00",
                                        "lastTimestamp": "2020-02-20 00:00:00",
                                        "message": "str",
                                        "name": "str",
                                        "type": "str",
                                    }
                                ],
                                "previousState": {
                                    "detailStatus": "str",
                                    "exitCode": 0,
                                    "finishTime": "2020-02-20 00:00:00",
                                    "startTime": "2020-02-20 00:00:00",
                                    "state": "str",
                                },
                                "restartCount": 0,
                            },
                            "livenessProbe": {
                                "exec": {"command": ["str"]},
                                "failureThreshold": 0,
                                "httpGet": {
                                    "port": 0,
                                    "httpHeaders": [{"name": "str", "value": "str"}],
                                    "path": "str",
                                    "scheme": "str",
                                },
                                "initialDelaySeconds": 0,
                                "periodSeconds": 0,
                                "successThreshold": 0,
                                "timeoutSeconds": 0,
                            },
                            "ports": [{"port": 0, "protocol": "str"}],
                            "readinessProbe": {
                                "exec": {"command": ["str"]},
                                "failureThreshold": 0,
                                "httpGet": {
                                    "port": 0,
                                    "httpHeaders": [{"name": "str", "value": "str"}],
                                    "path": "str",
                                    "scheme": "str",
                                },
                                "initialDelaySeconds": 0,
                                "periodSeconds": 0,
                                "successThreshold": 0,
                                "timeoutSeconds": 0,
                            },
                            "resources": {
                                "requests": {"cpu": 0.0, "memoryInGB": 0.0, "gpu": {"count": 0, "sku": "str"}},
                                "limits": {"cpu": 0.0, "gpu": {"count": 0, "sku": "str"}, "memoryInGB": 0.0},
                            },
                            "securityContext": {
                                "allowPrivilegeEscalation": bool,
                                "capabilities": {"add": ["str"], "drop": ["str"]},
                                "privileged": bool,
                                "runAsGroup": 0,
                                "runAsUser": 0,
                                "seccompProfile": "str",
                            },
                            "volumeMounts": [{"mountPath": "str", "name": "str", "readOnly": bool}],
                        }
                    ],
                    "confidentialComputeProperties": {"ccePolicy": "str"},
                    "containerGroupProfile": {"id": "str", "revision": 0},
                    "diagnostics": {
                        "logAnalytics": {
                            "workspaceId": "str",
                            "workspaceKey": "str",
                            "logType": "str",
                            "metadata": {"str": "str"},
                            "workspaceResourceId": "str",
                        }
                    },
                    "dnsConfig": {"nameServers": ["str"], "options": "str", "searchDomains": "str"},
                    "encryptionProperties": {
                        "keyName": "str",
                        "keyVersion": "str",
                        "vaultBaseUrl": "str",
                        "identity": "str",
                    },
                    "extensions": [
                        {
                            "name": "str",
                            "extensionType": "str",
                            "protectedSettings": {},
                            "settings": {},
                            "version": "str",
                        }
                    ],
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "imageRegistryCredentials": [
                        {"server": "str", "identity": "str", "identityUrl": "str", "password": "str", "username": "str"}
                    ],
                    "initContainers": [
                        {
                            "name": "str",
                            "command": ["str"],
                            "environmentVariables": [{"name": "str", "secureValue": "str", "value": "str"}],
                            "image": "str",
                            "instanceView": {
                                "currentState": {
                                    "detailStatus": "str",
                                    "exitCode": 0,
                                    "finishTime": "2020-02-20 00:00:00",
                                    "startTime": "2020-02-20 00:00:00",
                                    "state": "str",
                                },
                                "events": [
                                    {
                                        "count": 0,
                                        "firstTimestamp": "2020-02-20 00:00:00",
                                        "lastTimestamp": "2020-02-20 00:00:00",
                                        "message": "str",
                                        "name": "str",
                                        "type": "str",
                                    }
                                ],
                                "previousState": {
                                    "detailStatus": "str",
                                    "exitCode": 0,
                                    "finishTime": "2020-02-20 00:00:00",
                                    "startTime": "2020-02-20 00:00:00",
                                    "state": "str",
                                },
                                "restartCount": 0,
                            },
                            "securityContext": {
                                "allowPrivilegeEscalation": bool,
                                "capabilities": {"add": ["str"], "drop": ["str"]},
                                "privileged": bool,
                                "runAsGroup": 0,
                                "runAsUser": 0,
                                "seccompProfile": "str",
                            },
                            "volumeMounts": [{"mountPath": "str", "name": "str", "readOnly": bool}],
                        }
                    ],
                    "instanceView": {
                        "events": [
                            {
                                "count": 0,
                                "firstTimestamp": "2020-02-20 00:00:00",
                                "lastTimestamp": "2020-02-20 00:00:00",
                                "message": "str",
                                "name": "str",
                                "type": "str",
                            }
                        ],
                        "state": "str",
                    },
                    "ipAddress": {
                        "ports": [{"port": 0, "protocol": "str"}],
                        "type": "str",
                        "autoGeneratedDomainNameLabelScope": "Unsecure",
                        "dnsNameLabel": "str",
                        "fqdn": "str",
                        "ip": "str",
                    },
                    "isCreatedFromStandbyPool": bool,
                    "location": "str",
                    "name": "str",
                    "osType": "str",
                    "priority": "str",
                    "provisioningState": "str",
                    "restartPolicy": "str",
                    "sku": "str",
                    "standbyPoolProfile": {"failContainerGroupCreateOnReuseFailure": bool, "id": "str"},
                    "subnetIds": [{"id": "str", "name": "str"}],
                    "tags": {"str": "str"},
                    "type": "str",
                    "volumes": [
                        {
                            "name": "str",
                            "azureFile": {
                                "shareName": "str",
                                "storageAccountName": "str",
                                "readOnly": bool,
                                "storageAccountKey": "str",
                            },
                            "emptyDir": {},
                            "gitRepo": {"repository": "str", "directory": "str", "revision": "str"},
                            "secret": {"str": "str"},
                        }
                    ],
                    "zones": ["str"],
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update(self, resource_group):
        response = await self.client.container_groups.update(
            resource_group_name=resource_group.name,
            container_group_name="str",
            resource={
                "id": "str",
                "location": "str",
                "name": "str",
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.container_groups.begin_delete(
                resource_group_name=resource_group.name,
                container_group_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_restart(self, resource_group):
        response = await (
            await self.client.container_groups.begin_restart(
                resource_group_name=resource_group.name,
                container_group_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_stop(self, resource_group):
        response = await self.client.container_groups.stop(
            resource_group_name=resource_group.name,
            container_group_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_start(self, resource_group):
        response = await (
            await self.client.container_groups.begin_start(
                resource_group_name=resource_group.name,
                container_group_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_outbound_network_dependencies_endpoints(self, resource_group):
        response = await self.client.container_groups.get_outbound_network_dependencies_endpoints(
            resource_group_name=resource_group.name,
            container_group_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
