# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.azurestackhci import AzureStackHCIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-azurestackhci
# USAGE
    python put_deployment_settings.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AzureStackHCIClient(
        credential=DefaultAzureCredential(),
        subscription_id="fd3c3665-1729-4b7b-9a38-238e83b0f98b",
    )

    response = client.deployment_settings.begin_create_or_update(
        resource_group_name="test-rg",
        cluster_name="myCluster",
        resource={
            "properties": {
                "arcNodeResourceIds": [
                    "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/ArcInstance-rg/providers/Microsoft.HybridCompute/machines/Node-1",
                    "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/ArcInstance-rg/providers/Microsoft.HybridCompute/machines/Node-2",
                ],
                "deploymentConfiguration": {
                    "scaleUnits": [
                        {
                            "deploymentData": {
                                "adouPath": "OU=ms169,DC=ASZ1PLab8,DC=nttest,DC=microsoft,DC=com",
                                "cluster": {
                                    "azureServiceEndpoint": "core.windows.net",
                                    "cloudAccountName": "myasestoragacct",
                                    "name": "testHCICluster",
                                    "witnessPath": "Cloud",
                                    "witnessType": "Cloud",
                                },
                                "domainFqdn": "ASZ1PLab8.nttest.microsoft.com",
                                "hostNetwork": {
                                    "enableStorageAutoIp": False,
                                    "intents": [
                                        {
                                            "adapter": ["Port2"],
                                            "adapterPropertyOverrides": {
                                                "jumboPacket": "1514",
                                                "networkDirect": "Enabled",
                                                "networkDirectTechnology": "iWARP",
                                            },
                                            "name": "Compute_Management",
                                            "overrideAdapterProperty": False,
                                            "overrideQosPolicy": False,
                                            "overrideVirtualSwitchConfiguration": False,
                                            "qosPolicyOverrides": {
                                                "bandwidthPercentage_SMB": "50",
                                                "priorityValue8021Action_Cluster": "7",
                                                "priorityValue8021Action_SMB": "3",
                                            },
                                            "trafficType": ["Compute", "Management"],
                                            "virtualSwitchConfigurationOverrides": {
                                                "enableIov": "True",
                                                "loadBalancingAlgorithm": "HyperVPort",
                                            },
                                        }
                                    ],
                                    "storageConnectivitySwitchless": True,
                                    "storageNetworks": [
                                        {
                                            "name": "Storage1Network",
                                            "networkAdapterName": "Port3",
                                            "storageAdapterIPInfo": [
                                                {
                                                    "ipv4Address": "10.57.48.60",
                                                    "physicalNode": "string",
                                                    "subnetMask": "255.255.248.0",
                                                }
                                            ],
                                            "vlanId": "5",
                                        }
                                    ],
                                },
                                "infrastructureNetwork": [
                                    {
                                        "dnsServers": ["10.57.50.90"],
                                        "gateway": "255.255.248.0",
                                        "ipPools": [{"endingAddress": "10.57.48.66", "startingAddress": "10.57.48.60"}],
                                        "subnetMask": "255.255.248.0",
                                    }
                                ],
                                "namingPrefix": "ms169",
                                "observability": {
                                    "episodicDataUpload": True,
                                    "euLocation": False,
                                    "streamingDataClient": True,
                                },
                                "optionalServices": {"customLocation": "customLocationName"},
                                "physicalNodes": [
                                    {"ipv4Address": "10.57.51.224", "name": "ms169host"},
                                    {"ipv4Address": "10.57.53.236", "name": "ms154host"},
                                ],
                                "sdnIntegration": {
                                    "networkController": {
                                        "macAddressPoolStart": "00-0D-3A-1B-C7-21",
                                        "macAddressPoolStop": "00-0D-3A-1B-C7-29",
                                        "networkVirtualizationEnabled": True,
                                    }
                                },
                                "secrets": [
                                    {
                                        "eceSecretName": "BMCAdminUserCred",
                                        "secretLocation": "https://sclusterkvnirhci35.vault.azure.net/secrets/cluster-34232342-BmcAdminUser-f5bcc1d9-23af-4ae9-aca1-041d0f593a63/9276354aabfc492fa9b2cdbefb54ae4b",
                                        "secretName": "cluster1-BmcAdminUser-f5bcc1d9-23af-4ae9-aca1-041d0f593a63",
                                    },
                                    {
                                        "eceSecretName": "AzureStackLCMUserCredential",
                                        "secretLocation": "https://sclusterkvnirhci35.vault.azure.net/secrets/cluster-34232342-AzureStackLCMUserCredential-f5bcc1d9-23af-4ae9-aca1-041d0f593a63/9276354aabfc492fa9b2cdbefb54ae4c",
                                        "secretName": "cluster2-AzureStackLCMUserCredential-f5bcc1d9-23af-4ae9-aca1-041d0f593a63",
                                    },
                                ],
                                "secretsLocation": "/subscriptions/db4e2fdb-6d80-4e6e-b7cd-xxxxxxx/resourceGroups/test-rg/providers/Microsoft.KeyVault/vaults/abcd123",
                                "securitySettings": {
                                    "bitlockerBootVolume": True,
                                    "bitlockerDataVolumes": True,
                                    "credentialGuardEnforced": False,
                                    "driftControlEnforced": True,
                                    "drtmProtection": True,
                                    "hvciProtection": True,
                                    "sideChannelMitigationEnforced": True,
                                    "smbClusterEncryption": False,
                                    "smbSigningEnforced": True,
                                    "wdacEnforced": True,
                                },
                                "storage": {"configurationMode": "Express"},
                            },
                            "sbePartnerInfo": {
                                "credentialList": [
                                    {
                                        "eceSecretName": "DownloadConnectorCred",
                                        "secretLocation": "https://sclusterkvnirhci35.vault.azure.net/secrets/cluster-34232342-DownloadConnectorCred-f5bcc1d9-23af-4ae9-aca1-041d0f593a63/9276354aabfc492fa9b2cdbefb54ae4b",
                                        "secretName": "cluster1-DownloadConnectorCred-f5bcc1d9-23af-4ae9-aca1-041d0f593a63",
                                    }
                                ],
                                "partnerProperties": [
                                    {"name": "EnableBMCIpV6", "value": "false"},
                                    {"name": "PhoneHomePort", "value": "1653"},
                                    {"name": "BMCSecurityState", "value": "HighSecurity"},
                                ],
                                "sbeDeploymentInfo": {
                                    "family": "Gen5",
                                    "publisher": "Contoso",
                                    "sbeManifestCreationDate": "2023-07-25T02:40:33Z",
                                    "sbeManifestSource": "default",
                                    "version": "4.0.2309.13",
                                },
                            },
                        }
                    ],
                    "version": "string",
                },
                "deploymentMode": "Deploy",
                "operationType": "ClusterProvisioning",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/PutDeploymentSettings.json
if __name__ == "__main__":
    main()
