# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.loganalytics.aio import LogAnalyticsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestLogAnalyticsManagementTablesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(LogAnalyticsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_workspace(self, resource_group):
        response = self.client.tables.list_by_workspace(
            resource_group_name=resource_group.name,
            workspace_name="str",
            api_version="2022-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.tables.begin_create_or_update(
                resource_group_name=resource_group.name,
                workspace_name="str",
                table_name="str",
                parameters={
                    "archiveRetentionInDays": 0,
                    "id": "str",
                    "lastPlanModifiedDate": "str",
                    "name": "str",
                    "plan": "str",
                    "provisioningState": "str",
                    "restoredLogs": {
                        "azureAsyncOperationId": "str",
                        "endRestoreTime": "2020-02-20 00:00:00",
                        "sourceTable": "str",
                        "startRestoreTime": "2020-02-20 00:00:00",
                    },
                    "resultStatistics": {"ingestedRecords": 0, "progress": 0.0, "scannedGb": 0.0},
                    "retentionInDays": 0,
                    "retentionInDaysAsDefault": bool,
                    "schema": {
                        "categories": ["str"],
                        "columns": [
                            {
                                "dataTypeHint": "str",
                                "description": "str",
                                "displayName": "str",
                                "isDefaultDisplay": bool,
                                "isHidden": bool,
                                "name": "str",
                                "type": "str",
                            }
                        ],
                        "description": "str",
                        "displayName": "str",
                        "labels": ["str"],
                        "name": "str",
                        "solutions": ["str"],
                        "source": "str",
                        "standardColumns": [
                            {
                                "dataTypeHint": "str",
                                "description": "str",
                                "displayName": "str",
                                "isDefaultDisplay": bool,
                                "isHidden": bool,
                                "name": "str",
                                "type": "str",
                            }
                        ],
                        "tableSubType": "str",
                        "tableType": "str",
                    },
                    "searchResults": {
                        "azureAsyncOperationId": "str",
                        "description": "str",
                        "endSearchTime": "2020-02-20 00:00:00",
                        "limit": 0,
                        "query": "str",
                        "sourceTable": "str",
                        "startSearchTime": "2020-02-20 00:00:00",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "totalRetentionInDays": 0,
                    "totalRetentionInDaysAsDefault": bool,
                    "type": "str",
                },
                api_version="2022-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.tables.begin_update(
                resource_group_name=resource_group.name,
                workspace_name="str",
                table_name="str",
                parameters={
                    "archiveRetentionInDays": 0,
                    "id": "str",
                    "lastPlanModifiedDate": "str",
                    "name": "str",
                    "plan": "str",
                    "provisioningState": "str",
                    "restoredLogs": {
                        "azureAsyncOperationId": "str",
                        "endRestoreTime": "2020-02-20 00:00:00",
                        "sourceTable": "str",
                        "startRestoreTime": "2020-02-20 00:00:00",
                    },
                    "resultStatistics": {"ingestedRecords": 0, "progress": 0.0, "scannedGb": 0.0},
                    "retentionInDays": 0,
                    "retentionInDaysAsDefault": bool,
                    "schema": {
                        "categories": ["str"],
                        "columns": [
                            {
                                "dataTypeHint": "str",
                                "description": "str",
                                "displayName": "str",
                                "isDefaultDisplay": bool,
                                "isHidden": bool,
                                "name": "str",
                                "type": "str",
                            }
                        ],
                        "description": "str",
                        "displayName": "str",
                        "labels": ["str"],
                        "name": "str",
                        "solutions": ["str"],
                        "source": "str",
                        "standardColumns": [
                            {
                                "dataTypeHint": "str",
                                "description": "str",
                                "displayName": "str",
                                "isDefaultDisplay": bool,
                                "isHidden": bool,
                                "name": "str",
                                "type": "str",
                            }
                        ],
                        "tableSubType": "str",
                        "tableType": "str",
                    },
                    "searchResults": {
                        "azureAsyncOperationId": "str",
                        "description": "str",
                        "endSearchTime": "2020-02-20 00:00:00",
                        "limit": 0,
                        "query": "str",
                        "sourceTable": "str",
                        "startSearchTime": "2020-02-20 00:00:00",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "totalRetentionInDays": 0,
                    "totalRetentionInDaysAsDefault": bool,
                    "type": "str",
                },
                api_version="2022-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.tables.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            table_name="str",
            api_version="2022-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.tables.begin_delete(
                resource_group_name=resource_group.name,
                workspace_name="str",
                table_name="str",
                api_version="2022-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrate(self, resource_group):
        response = await self.client.tables.migrate(
            resource_group_name=resource_group.name,
            workspace_name="str",
            table_name="str",
            api_version="2022-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cancel_search(self, resource_group):
        response = await self.client.tables.cancel_search(
            resource_group_name=resource_group.name,
            workspace_name="str",
            table_name="str",
            api_version="2022-10-01",
        )

        # please add some check logic here by yourself
        # ...
