# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._container_apps_api_client_enums import *


class AllowedAudiencesValidation(msrest.serialization.Model):
    """The configuration settings of the Allowed Audiences validation flow.

    :ivar allowed_audiences: The configuration settings of the allowed list of audiences from which
     to validate the JWT token.
    :vartype allowed_audiences: list[str]
    """

    _attribute_map = {
        'allowed_audiences': {'key': 'allowedAudiences', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_audiences: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword allowed_audiences: The configuration settings of the allowed list of audiences from
         which to validate the JWT token.
        :paramtype allowed_audiences: list[str]
        """
        super(AllowedAudiencesValidation, self).__init__(**kwargs)
        self.allowed_audiences = allowed_audiences


class AllowedPrincipals(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory allowed principals.

    :ivar groups: The list of the allowed groups.
    :vartype groups: list[str]
    :ivar identities: The list of the allowed identities.
    :vartype identities: list[str]
    """

    _attribute_map = {
        'groups': {'key': 'groups', 'type': '[str]'},
        'identities': {'key': 'identities', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        groups: Optional[List[str]] = None,
        identities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword groups: The list of the allowed groups.
        :paramtype groups: list[str]
        :keyword identities: The list of the allowed identities.
        :paramtype identities: list[str]
        """
        super(AllowedPrincipals, self).__init__(**kwargs)
        self.groups = groups
        self.identities = identities


class Apple(msrest.serialization.Model):
    """The configuration settings of the Apple provider.

    :ivar enabled: :code:`<code>false</code>` if the Apple provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Apple registration.
    :vartype registration: ~container_apps_api_client.models.AppleRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~container_apps_api_client.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AppleRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AppleRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Apple provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Apple registration.
        :paramtype registration: ~container_apps_api_client.models.AppleRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~container_apps_api_client.models.LoginScopes
        """
        super(Apple, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class AppleRegistration(msrest.serialization.Model):
    """The configuration settings of the registration for the Apple provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super(AppleRegistration, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class AppLogsConfiguration(msrest.serialization.Model):
    """Configuration of application logs.

    :ivar destination: Logs destination.
    :vartype destination: str
    :ivar log_analytics_configuration: Log Analytics configuration.
    :vartype log_analytics_configuration:
     ~container_apps_api_client.models.LogAnalyticsConfiguration
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'str'},
        'log_analytics_configuration': {'key': 'logAnalyticsConfiguration', 'type': 'LogAnalyticsConfiguration'},
    }

    def __init__(
        self,
        *,
        destination: Optional[str] = None,
        log_analytics_configuration: Optional["LogAnalyticsConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword destination: Logs destination.
        :paramtype destination: str
        :keyword log_analytics_configuration: Log Analytics configuration.
        :paramtype log_analytics_configuration:
         ~container_apps_api_client.models.LogAnalyticsConfiguration
        """
        super(AppLogsConfiguration, self).__init__(**kwargs)
        self.destination = destination
        self.log_analytics_configuration = log_analytics_configuration


class AppRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for providers that have app ids and app secrets.

    :ivar app_id: The App ID of the app used for login.
    :vartype app_id: str
    :ivar app_secret_setting_name: The app setting name that contains the app secret.
    :vartype app_secret_setting_name: str
    """

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret_setting_name': {'key': 'appSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_id: Optional[str] = None,
        app_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword app_id: The App ID of the app used for login.
        :paramtype app_id: str
        :keyword app_secret_setting_name: The app setting name that contains the app secret.
        :paramtype app_secret_setting_name: str
        """
        super(AppRegistration, self).__init__(**kwargs)
        self.app_id = app_id
        self.app_secret_setting_name = app_secret_setting_name


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class AuthConfig(ProxyResource):
    """Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar platform: The configuration settings of the platform of ContainerApp Service
     Authentication/Authorization.
    :vartype platform: ~container_apps_api_client.models.AuthPlatform
    :ivar global_validation: The configuration settings that determines the validation flow of
     users using  Service Authentication/Authorization.
    :vartype global_validation: ~container_apps_api_client.models.GlobalValidation
    :ivar identity_providers: The configuration settings of each of the identity providers used to
     configure ContainerApp Service Authentication/Authorization.
    :vartype identity_providers: ~container_apps_api_client.models.IdentityProviders
    :ivar login: The configuration settings of the login flow of users using ContainerApp Service
     Authentication/Authorization.
    :vartype login: ~container_apps_api_client.models.Login
    :ivar http_settings: The configuration settings of the HTTP requests for authentication and
     authorization requests made against ContainerApp Service Authentication/Authorization.
    :vartype http_settings: ~container_apps_api_client.models.HttpSettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'platform': {'key': 'properties.platform', 'type': 'AuthPlatform'},
        'global_validation': {'key': 'properties.globalValidation', 'type': 'GlobalValidation'},
        'identity_providers': {'key': 'properties.identityProviders', 'type': 'IdentityProviders'},
        'login': {'key': 'properties.login', 'type': 'Login'},
        'http_settings': {'key': 'properties.httpSettings', 'type': 'HttpSettings'},
    }

    def __init__(
        self,
        *,
        platform: Optional["AuthPlatform"] = None,
        global_validation: Optional["GlobalValidation"] = None,
        identity_providers: Optional["IdentityProviders"] = None,
        login: Optional["Login"] = None,
        http_settings: Optional["HttpSettings"] = None,
        **kwargs
    ):
        """
        :keyword platform: The configuration settings of the platform of ContainerApp Service
         Authentication/Authorization.
        :paramtype platform: ~container_apps_api_client.models.AuthPlatform
        :keyword global_validation: The configuration settings that determines the validation flow of
         users using  Service Authentication/Authorization.
        :paramtype global_validation: ~container_apps_api_client.models.GlobalValidation
        :keyword identity_providers: The configuration settings of each of the identity providers used
         to configure ContainerApp Service Authentication/Authorization.
        :paramtype identity_providers: ~container_apps_api_client.models.IdentityProviders
        :keyword login: The configuration settings of the login flow of users using ContainerApp
         Service Authentication/Authorization.
        :paramtype login: ~container_apps_api_client.models.Login
        :keyword http_settings: The configuration settings of the HTTP requests for authentication and
         authorization requests made against ContainerApp Service Authentication/Authorization.
        :paramtype http_settings: ~container_apps_api_client.models.HttpSettings
        """
        super(AuthConfig, self).__init__(**kwargs)
        self.platform = platform
        self.global_validation = global_validation
        self.identity_providers = identity_providers
        self.login = login
        self.http_settings = http_settings


class AuthConfigCollection(msrest.serialization.Model):
    """AuthConfig collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.AuthConfig]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AuthConfig]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AuthConfig"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.AuthConfig]
        """
        super(AuthConfigCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AuthPlatform(msrest.serialization.Model):
    """The configuration settings of the platform of ContainerApp Service Authentication/Authorization.

    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        """
        super(AuthPlatform, self).__init__(**kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version


class AvailableOperations(msrest.serialization.Model):
    """Available operations of the service.

    :ivar value: Collection of available operation details.
    :vartype value: list[~container_apps_api_client.models.OperationDetail]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationDetail"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~container_apps_api_client.models.OperationDetail]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super(AvailableOperations, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureActiveDirectory(msrest.serialization.Model):
    """The configuration settings of the Azure Active directory provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Active Directory app registration.
    :vartype registration: ~container_apps_api_client.models.AzureActiveDirectoryRegistration
    :ivar login: The configuration settings of the Azure Active Directory login flow.
    :vartype login: ~container_apps_api_client.models.AzureActiveDirectoryLogin
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~container_apps_api_client.models.AzureActiveDirectoryValidation
    :ivar is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
     auto-provisioned using 1st party tooling.
     This is an internal flag primarily intended to support the Azure Management Portal. Users
     should not
     read or write to this property.
    :vartype is_auto_provisioned: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AzureActiveDirectoryRegistration'},
        'login': {'key': 'login', 'type': 'AzureActiveDirectoryLogin'},
        'validation': {'key': 'validation', 'type': 'AzureActiveDirectoryValidation'},
        'is_auto_provisioned': {'key': 'isAutoProvisioned', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AzureActiveDirectoryRegistration"] = None,
        login: Optional["AzureActiveDirectoryLogin"] = None,
        validation: Optional["AzureActiveDirectoryValidation"] = None,
        is_auto_provisioned: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Active Directory app
         registration.
        :paramtype registration: ~container_apps_api_client.models.AzureActiveDirectoryRegistration
        :keyword login: The configuration settings of the Azure Active Directory login flow.
        :paramtype login: ~container_apps_api_client.models.AzureActiveDirectoryLogin
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~container_apps_api_client.models.AzureActiveDirectoryValidation
        :keyword is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
         auto-provisioned using 1st party tooling.
         This is an internal flag primarily intended to support the Azure Management Portal. Users
         should not
         read or write to this property.
        :paramtype is_auto_provisioned: bool
        """
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation
        self.is_auto_provisioned = is_auto_provisioned


class AzureActiveDirectoryLogin(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory login flow.

    :ivar login_parameters: Login parameters to send to the OpenID Connect authorization endpoint
     when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype login_parameters: list[str]
    :ivar disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
     should be omitted from the request; otherwise, :code:`<code>false</code>`.
    :vartype disable_www_authenticate: bool
    """

    _attribute_map = {
        'login_parameters': {'key': 'loginParameters', 'type': '[str]'},
        'disable_www_authenticate': {'key': 'disableWWWAuthenticate', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        login_parameters: Optional[List[str]] = None,
        disable_www_authenticate: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword login_parameters: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype login_parameters: list[str]
        :keyword disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
         should be omitted from the request; otherwise, :code:`<code>false</code>`.
        :paramtype disable_www_authenticate: bool
        """
        super(AzureActiveDirectoryLogin, self).__init__(**kwargs)
        self.login_parameters = login_parameters
        self.disable_www_authenticate = disable_www_authenticate


class AzureActiveDirectoryRegistration(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory app registration.

    :ivar open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
     access tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype open_id_issuer: str
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :vartype client_secret_setting_name: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar client_secret_certificate_subject_alternative_name: An alternative to the client secret
     thumbprint, that is the subject alternative name of a certificate used for signing purposes.
     This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_subject_alternative_name: str
    :ivar client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is
     the issuer of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_issuer: str
    """

    _attribute_map = {
        'open_id_issuer': {'key': 'openIdIssuer', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
        'client_secret_certificate_thumbprint': {'key': 'clientSecretCertificateThumbprint', 'type': 'str'},
        'client_secret_certificate_subject_alternative_name': {'key': 'clientSecretCertificateSubjectAlternativeName', 'type': 'str'},
        'client_secret_certificate_issuer': {'key': 'clientSecretCertificateIssuer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        open_id_issuer: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        client_secret_certificate_subject_alternative_name: Optional[str] = None,
        client_secret_certificate_issuer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
         access tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://login.microsoftonline.com/v2.0/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype open_id_issuer: str
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret of
         the relying party application.
        :paramtype client_secret_setting_name: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword client_secret_certificate_subject_alternative_name: An alternative to the client
         secret thumbprint, that is the subject alternative name of a certificate used for signing
         purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_subject_alternative_name: str
        :keyword client_secret_certificate_issuer: An alternative to the client secret thumbprint, that
         is the issuer of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_issuer: str
        """
        super(AzureActiveDirectoryRegistration, self).__init__(**kwargs)
        self.open_id_issuer = open_id_issuer
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.client_secret_certificate_subject_alternative_name = client_secret_certificate_subject_alternative_name
        self.client_secret_certificate_issuer = client_secret_certificate_issuer


class AzureActiveDirectoryValidation(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory token validation flow.

    :ivar jwt_claim_checks: The configuration settings of the checks that should be made while
     validating the JWT Claims.
    :vartype jwt_claim_checks: ~container_apps_api_client.models.JwtClaimChecks
    :ivar allowed_audiences: The list of audiences that can make successful
     authentication/authorization requests.
    :vartype allowed_audiences: list[str]
    :ivar default_authorization_policy: The configuration settings of the default authorization
     policy.
    :vartype default_authorization_policy:
     ~container_apps_api_client.models.DefaultAuthorizationPolicy
    """

    _attribute_map = {
        'jwt_claim_checks': {'key': 'jwtClaimChecks', 'type': 'JwtClaimChecks'},
        'allowed_audiences': {'key': 'allowedAudiences', 'type': '[str]'},
        'default_authorization_policy': {'key': 'defaultAuthorizationPolicy', 'type': 'DefaultAuthorizationPolicy'},
    }

    def __init__(
        self,
        *,
        jwt_claim_checks: Optional["JwtClaimChecks"] = None,
        allowed_audiences: Optional[List[str]] = None,
        default_authorization_policy: Optional["DefaultAuthorizationPolicy"] = None,
        **kwargs
    ):
        """
        :keyword jwt_claim_checks: The configuration settings of the checks that should be made while
         validating the JWT Claims.
        :paramtype jwt_claim_checks: ~container_apps_api_client.models.JwtClaimChecks
        :keyword allowed_audiences: The list of audiences that can make successful
         authentication/authorization requests.
        :paramtype allowed_audiences: list[str]
        :keyword default_authorization_policy: The configuration settings of the default authorization
         policy.
        :paramtype default_authorization_policy:
         ~container_apps_api_client.models.DefaultAuthorizationPolicy
        """
        super(AzureActiveDirectoryValidation, self).__init__(**kwargs)
        self.jwt_claim_checks = jwt_claim_checks
        self.allowed_audiences = allowed_audiences
        self.default_authorization_policy = default_authorization_policy


class AzureCredentials(msrest.serialization.Model):
    """Container App credentials.

    :ivar client_id: Client Id.
    :vartype client_id: str
    :ivar client_secret: Client Secret.
    :vartype client_secret: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: Client Id.
        :paramtype client_id: str
        :keyword client_secret: Client Secret.
        :paramtype client_secret: str
        :keyword tenant_id: Tenant Id.
        :paramtype tenant_id: str
        :keyword subscription_id: Subscription Id.
        :paramtype subscription_id: str
        """
        super(AzureCredentials, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id


class AzureFileProperties(msrest.serialization.Model):
    """Azure File Properties.

    :ivar account_name: Storage account name for azure file.
    :vartype account_name: str
    :ivar account_key: Storage account key for azure file.
    :vartype account_key: str
    :ivar access_mode: Access mode for storage. Possible values include: "ReadOnly", "ReadWrite".
    :vartype access_mode: str or ~container_apps_api_client.models.AccessMode
    :ivar share_name: Azure file share name.
    :vartype share_name: str
    """

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'access_mode': {'key': 'accessMode', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        access_mode: Optional[Union[str, "AccessMode"]] = None,
        share_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword account_name: Storage account name for azure file.
        :paramtype account_name: str
        :keyword account_key: Storage account key for azure file.
        :paramtype account_key: str
        :keyword access_mode: Access mode for storage. Possible values include: "ReadOnly",
         "ReadWrite".
        :paramtype access_mode: str or ~container_apps_api_client.models.AccessMode
        :keyword share_name: Azure file share name.
        :paramtype share_name: str
        """
        super(AzureFileProperties, self).__init__(**kwargs)
        self.account_name = account_name
        self.account_key = account_key
        self.access_mode = access_mode
        self.share_name = share_name


class AzureStaticWebApps(msrest.serialization.Model):
    """The configuration settings of the Azure Static Web Apps provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Static Web Apps registration.
    :vartype registration: ~container_apps_api_client.models.AzureStaticWebAppsRegistration
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AzureStaticWebAppsRegistration'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AzureStaticWebAppsRegistration"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Static Web Apps registration.
        :paramtype registration: ~container_apps_api_client.models.AzureStaticWebAppsRegistration
        """
        super(AzureStaticWebApps, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class AzureStaticWebAppsRegistration(msrest.serialization.Model):
    """The configuration settings of the registration for the Azure Static Web Apps provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        """
        super(AzureStaticWebAppsRegistration, self).__init__(**kwargs)
        self.client_id = client_id


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Certificate(TrackedResource):
    """Certificate used for Custom Domain bindings of Container Apps in a Managed Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Certificate resource specific properties.
    :vartype properties: ~container_apps_api_client.models.CertificateProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["CertificateProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Certificate resource specific properties.
        :paramtype properties: ~container_apps_api_client.models.CertificateProperties
        """
        super(Certificate, self).__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class CertificateCollection(msrest.serialization.Model):
    """Collection of Certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Certificate"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.Certificate]
        """
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CertificatePatch(msrest.serialization.Model):
    """A certificate to update.

    :ivar tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super(CertificatePatch, self).__init__(**kwargs)
        self.tags = tags


class CertificateProperties(msrest.serialization.Model):
    """Certificate resource specific properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the certificate. Possible values include:
     "Succeeded", "Failed", "Canceled", "DeleteFailed", "Pending".
    :vartype provisioning_state: str or
     ~container_apps_api_client.models.CertificateProvisioningState
    :ivar password: Certificate password.
    :vartype password: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar value: PFX or PEM blob.
    :vartype value: bytearray
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'subject_name': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'public_key_hash': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'subject_name': {'key': 'subjectName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'issue_date': {'key': 'issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid': {'key': 'valid', 'type': 'bool'},
        'public_key_hash': {'key': 'publicKeyHash', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        password: Optional[str] = None,
        value: Optional[bytearray] = None,
        **kwargs
    ):
        """
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword value: PFX or PEM blob.
        :paramtype value: bytearray
        """
        super(CertificateProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.password = password
        self.subject_name = None
        self.value = value
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.public_key_hash = None


class ClientRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for providers that have client ids and client secrets.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super(ClientRegistration, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class Configuration(msrest.serialization.Model):
    """Non versioned Container App configuration properties that define the mutable settings of a Container app.

    :ivar secrets: Collection of secrets used by a Container app.
    :vartype secrets: list[~container_apps_api_client.models.Secret]
    :ivar active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for
     the Container app:
    
    
     .. raw:: html
    
        <list><item>Multiple: multiple revisions can be active. If no value if provided, this is
     the default</item><item>Single: Only one revision can be active at a time. Revision weights can
     not be used in this mode</item></list>. Possible values include: "multiple", "single".
    :vartype active_revisions_mode: str or ~container_apps_api_client.models.ActiveRevisionsMode
    :ivar ingress: Ingress configurations.
    :vartype ingress: ~container_apps_api_client.models.Ingress
    :ivar registries: Collection of private container registry credentials for containers used by
     the Container app.
    :vartype registries: list[~container_apps_api_client.models.RegistryCredentials]
    :ivar dapr: Dapr configuration for the Container App.
    :vartype dapr: ~container_apps_api_client.models.Dapr
    """

    _attribute_map = {
        'secrets': {'key': 'secrets', 'type': '[Secret]'},
        'active_revisions_mode': {'key': 'activeRevisionsMode', 'type': 'str'},
        'ingress': {'key': 'ingress', 'type': 'Ingress'},
        'registries': {'key': 'registries', 'type': '[RegistryCredentials]'},
        'dapr': {'key': 'dapr', 'type': 'Dapr'},
    }

    def __init__(
        self,
        *,
        secrets: Optional[List["Secret"]] = None,
        active_revisions_mode: Optional[Union[str, "ActiveRevisionsMode"]] = None,
        ingress: Optional["Ingress"] = None,
        registries: Optional[List["RegistryCredentials"]] = None,
        dapr: Optional["Dapr"] = None,
        **kwargs
    ):
        """
        :keyword secrets: Collection of secrets used by a Container app.
        :paramtype secrets: list[~container_apps_api_client.models.Secret]
        :keyword active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled
         for the Container app:
        
        
         .. raw:: html
        
            <list><item>Multiple: multiple revisions can be active. If no value if provided, this is
         the default</item><item>Single: Only one revision can be active at a time. Revision weights can
         not be used in this mode</item></list>. Possible values include: "multiple", "single".
        :paramtype active_revisions_mode: str or ~container_apps_api_client.models.ActiveRevisionsMode
        :keyword ingress: Ingress configurations.
        :paramtype ingress: ~container_apps_api_client.models.Ingress
        :keyword registries: Collection of private container registry credentials for containers used
         by the Container app.
        :paramtype registries: list[~container_apps_api_client.models.RegistryCredentials]
        :keyword dapr: Dapr configuration for the Container App.
        :paramtype dapr: ~container_apps_api_client.models.Dapr
        """
        super(Configuration, self).__init__(**kwargs)
        self.secrets = secrets
        self.active_revisions_mode = active_revisions_mode
        self.ingress = ingress
        self.registries = registries
        self.dapr = dapr


class Container(msrest.serialization.Model):
    """Container App container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~container_apps_api_client.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~container_apps_api_client.models.ContainerResources
    :ivar probes: List of probes for the container.
    :vartype probes: list[~container_apps_api_client.models.ContainerAppProbe]
    :ivar volume_mounts: Container volume mounts.
    :vartype volume_mounts: list[~container_apps_api_client.models.VolumeMount]
    """

    _attribute_map = {
        'image': {'key': 'image', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'command': {'key': 'command', 'type': '[str]'},
        'args': {'key': 'args', 'type': '[str]'},
        'env': {'key': 'env', 'type': '[EnvironmentVar]'},
        'resources': {'key': 'resources', 'type': 'ContainerResources'},
        'probes': {'key': 'probes', 'type': '[ContainerAppProbe]'},
        'volume_mounts': {'key': 'volumeMounts', 'type': '[VolumeMount]'},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        name: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        env: Optional[List["EnvironmentVar"]] = None,
        resources: Optional["ContainerResources"] = None,
        probes: Optional[List["ContainerAppProbe"]] = None,
        volume_mounts: Optional[List["VolumeMount"]] = None,
        **kwargs
    ):
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~container_apps_api_client.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~container_apps_api_client.models.ContainerResources
        :keyword probes: List of probes for the container.
        :paramtype probes: list[~container_apps_api_client.models.ContainerAppProbe]
        :keyword volume_mounts: Container volume mounts.
        :paramtype volume_mounts: list[~container_apps_api_client.models.VolumeMount]
        """
        super(Container, self).__init__(**kwargs)
        self.image = image
        self.name = name
        self.command = command
        self.args = args
        self.env = env
        self.resources = resources
        self.probes = probes
        self.volume_mounts = volume_mounts


class ContainerApp(TrackedResource):
    """Container App.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: managed identities for the Container App to interact with other Azure services
     without maintaining any secrets or credentials in code.
    :vartype identity: ~container_apps_api_client.models.ManagedServiceIdentity
    :ivar provisioning_state: Provisioning state of the Container App. Possible values include:
     "InProgress", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~container_apps_api_client.models.ContainerAppProvisioningState
    :ivar managed_environment_id: Resource ID of the Container App's environment.
    :vartype managed_environment_id: str
    :ivar latest_revision_name: Name of the latest revision of the Container App.
    :vartype latest_revision_name: str
    :ivar latest_revision_fqdn: Fully Qualified Domain Name of the latest revision of the Container
     App.
    :vartype latest_revision_fqdn: str
    :ivar custom_domain_verification_id: Id used to verify domain name ownership.
    :vartype custom_domain_verification_id: str
    :ivar configuration: Non versioned Container App configuration properties.
    :vartype configuration: ~container_apps_api_client.models.Configuration
    :ivar template: Container App versioned application definition.
    :vartype template: ~container_apps_api_client.models.Template
    :ivar outbound_ip_addresses: Outbound IP Addresses for container app.
    :vartype outbound_ip_addresses: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'latest_revision_name': {'readonly': True},
        'latest_revision_fqdn': {'readonly': True},
        'custom_domain_verification_id': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'managed_environment_id': {'key': 'properties.managedEnvironmentId', 'type': 'str'},
        'latest_revision_name': {'key': 'properties.latestRevisionName', 'type': 'str'},
        'latest_revision_fqdn': {'key': 'properties.latestRevisionFqdn', 'type': 'str'},
        'custom_domain_verification_id': {'key': 'properties.customDomainVerificationId', 'type': 'str'},
        'configuration': {'key': 'properties.configuration', 'type': 'Configuration'},
        'template': {'key': 'properties.template', 'type': 'Template'},
        'outbound_ip_addresses': {'key': 'properties.outboundIPAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        managed_environment_id: Optional[str] = None,
        configuration: Optional["Configuration"] = None,
        template: Optional["Template"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: managed identities for the Container App to interact with other Azure
         services without maintaining any secrets or credentials in code.
        :paramtype identity: ~container_apps_api_client.models.ManagedServiceIdentity
        :keyword managed_environment_id: Resource ID of the Container App's environment.
        :paramtype managed_environment_id: str
        :keyword configuration: Non versioned Container App configuration properties.
        :paramtype configuration: ~container_apps_api_client.models.Configuration
        :keyword template: Container App versioned application definition.
        :paramtype template: ~container_apps_api_client.models.Template
        """
        super(ContainerApp, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.managed_environment_id = managed_environment_id
        self.latest_revision_name = None
        self.latest_revision_fqdn = None
        self.custom_domain_verification_id = None
        self.configuration = configuration
        self.template = template
        self.outbound_ip_addresses = None


class ContainerAppCollection(msrest.serialization.Model):
    """Container App collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.ContainerApp]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContainerApp]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ContainerApp"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.ContainerApp]
        """
        super(ContainerAppCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ContainerAppPatch(msrest.serialization.Model):
    """Container App Patch.

    :ivar tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super(ContainerAppPatch, self).__init__(**kwargs)
        self.tags = tags


class ContainerAppProbe(msrest.serialization.Model):
    """Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.

    :ivar failure_threshold: Minimum consecutive failures for the probe to be considered failed
     after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
    :vartype failure_threshold: int
    :ivar http_get: HTTPGet specifies the http request to perform.
    :vartype http_get: ~container_apps_api_client.models.ContainerAppProbeHttpGet
    :ivar initial_delay_seconds: Number of seconds after the container has started before liveness
     probes are initiated. Minimum value is 1. Maximum value is 60.
    :vartype initial_delay_seconds: int
    :ivar period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds.
     Minimum value is 1. Maximum value is 240.
    :vartype period_seconds: int
    :ivar success_threshold: Minimum consecutive successes for the probe to be considered
     successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
     value is 1. Maximum value is 10.
    :vartype success_threshold: int
    :ivar tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet
     supported.
    :vartype tcp_socket: ~container_apps_api_client.models.ContainerAppProbeTcpSocket
    :ivar termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate
     gracefully upon probe failure. The grace period is the duration in seconds after the processes
     running in the pod are sent a termination signal and the time when the processes are forcibly
     halted with a kill signal. Set this value longer than the expected cleanup time for your
     process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise,
     this value overrides the value provided by the pod spec. Value must be non-negative integer.
     The value zero indicates stop immediately via the kill signal (no opportunity to shut down).
     This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum
     value is 3600 seconds (1 hour).
    :vartype termination_grace_period_seconds: long
    :ivar timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second.
     Minimum value is 1. Maximum value is 240.
    :vartype timeout_seconds: int
    :ivar type: The type of probe. Possible values include: "liveness", "readiness", "startup".
    :vartype type: str or ~container_apps_api_client.models.Type
    """

    _attribute_map = {
        'failure_threshold': {'key': 'failureThreshold', 'type': 'int'},
        'http_get': {'key': 'httpGet', 'type': 'ContainerAppProbeHttpGet'},
        'initial_delay_seconds': {'key': 'initialDelaySeconds', 'type': 'int'},
        'period_seconds': {'key': 'periodSeconds', 'type': 'int'},
        'success_threshold': {'key': 'successThreshold', 'type': 'int'},
        'tcp_socket': {'key': 'tcpSocket', 'type': 'ContainerAppProbeTcpSocket'},
        'termination_grace_period_seconds': {'key': 'terminationGracePeriodSeconds', 'type': 'long'},
        'timeout_seconds': {'key': 'timeoutSeconds', 'type': 'int'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failure_threshold: Optional[int] = None,
        http_get: Optional["ContainerAppProbeHttpGet"] = None,
        initial_delay_seconds: Optional[int] = None,
        period_seconds: Optional[int] = None,
        success_threshold: Optional[int] = None,
        tcp_socket: Optional["ContainerAppProbeTcpSocket"] = None,
        termination_grace_period_seconds: Optional[int] = None,
        timeout_seconds: Optional[int] = None,
        type: Optional[Union[str, "Type"]] = None,
        **kwargs
    ):
        """
        :keyword failure_threshold: Minimum consecutive failures for the probe to be considered failed
         after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        :paramtype failure_threshold: int
        :keyword http_get: HTTPGet specifies the http request to perform.
        :paramtype http_get: ~container_apps_api_client.models.ContainerAppProbeHttpGet
        :keyword initial_delay_seconds: Number of seconds after the container has started before
         liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        :paramtype initial_delay_seconds: int
        :keyword period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds.
         Minimum value is 1. Maximum value is 240.
        :paramtype period_seconds: int
        :keyword success_threshold: Minimum consecutive successes for the probe to be considered
         successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
         value is 1. Maximum value is 10.
        :paramtype success_threshold: int
        :keyword tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet
         supported.
        :paramtype tcp_socket: ~container_apps_api_client.models.ContainerAppProbeTcpSocket
        :keyword termination_grace_period_seconds: Optional duration in seconds the pod needs to
         terminate gracefully upon probe failure. The grace period is the duration in seconds after the
         processes running in the pod are sent a termination signal and the time when the processes are
         forcibly halted with a kill signal. Set this value longer than the expected cleanup time for
         your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used.
         Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative
         integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut
         down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate.
         Maximum value is 3600 seconds (1 hour).
        :paramtype termination_grace_period_seconds: long
        :keyword timeout_seconds: Number of seconds after which the probe times out. Defaults to 1
         second. Minimum value is 1. Maximum value is 240.
        :paramtype timeout_seconds: int
        :keyword type: The type of probe. Possible values include: "liveness", "readiness", "startup".
        :paramtype type: str or ~container_apps_api_client.models.Type
        """
        super(ContainerAppProbe, self).__init__(**kwargs)
        self.failure_threshold = failure_threshold
        self.http_get = http_get
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.success_threshold = success_threshold
        self.tcp_socket = tcp_socket
        self.termination_grace_period_seconds = termination_grace_period_seconds
        self.timeout_seconds = timeout_seconds
        self.type = type


class ContainerAppProbeHttpGet(msrest.serialization.Model):
    """HTTPGet specifies the http request to perform.

    All required parameters must be populated in order to send to Azure.

    :ivar host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in
     httpHeaders instead.
    :vartype host: str
    :ivar http_headers: Custom headers to set in the request. HTTP allows repeated headers.
    :vartype http_headers:
     list[~container_apps_api_client.models.ContainerAppProbeHttpGetHttpHeadersItem]
    :ivar path: Path to access on the HTTP server.
    :vartype path: str
    :ivar port: Required. Name or number of the port to access on the container. Number must be in
     the range 1 to 65535. Name must be an IANA_SVC_NAME.
    :vartype port: int
    :ivar scheme: Scheme to use for connecting to the host. Defaults to HTTP.
    :vartype scheme: str
    """

    _validation = {
        'port': {'required': True},
    }

    _attribute_map = {
        'host': {'key': 'host', 'type': 'str'},
        'http_headers': {'key': 'httpHeaders', 'type': '[ContainerAppProbeHttpGetHttpHeadersItem]'},
        'path': {'key': 'path', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'scheme': {'key': 'scheme', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        port: int,
        host: Optional[str] = None,
        http_headers: Optional[List["ContainerAppProbeHttpGetHttpHeadersItem"]] = None,
        path: Optional[str] = None,
        scheme: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host: Host name to connect to, defaults to the pod IP. You probably want to set "Host"
         in httpHeaders instead.
        :paramtype host: str
        :keyword http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :paramtype http_headers:
         list[~container_apps_api_client.models.ContainerAppProbeHttpGetHttpHeadersItem]
        :keyword path: Path to access on the HTTP server.
        :paramtype path: str
        :keyword port: Required. Name or number of the port to access on the container. Number must be
         in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :paramtype port: int
        :keyword scheme: Scheme to use for connecting to the host. Defaults to HTTP.
        :paramtype scheme: str
        """
        super(ContainerAppProbeHttpGet, self).__init__(**kwargs)
        self.host = host
        self.http_headers = http_headers
        self.path = path
        self.port = port
        self.scheme = scheme


class ContainerAppProbeHttpGetHttpHeadersItem(msrest.serialization.Model):
    """HTTPHeader describes a custom header to be used in HTTP probes.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The header field name.
    :vartype name: str
    :ivar value: Required. The header field value.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Required. The header field name.
        :paramtype name: str
        :keyword value: Required. The header field value.
        :paramtype value: str
        """
        super(ContainerAppProbeHttpGetHttpHeadersItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class ContainerAppProbeTcpSocket(msrest.serialization.Model):
    """TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.

    All required parameters must be populated in order to send to Azure.

    :ivar host: Optional: Host name to connect to, defaults to the pod IP.
    :vartype host: str
    :ivar port: Required. Number or name of the port to access on the container. Number must be in
     the range 1 to 65535. Name must be an IANA_SVC_NAME.
    :vartype port: int
    """

    _validation = {
        'port': {'required': True},
    }

    _attribute_map = {
        'host': {'key': 'host', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        port: int,
        host: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host: Optional: Host name to connect to, defaults to the pod IP.
        :paramtype host: str
        :keyword port: Required. Number or name of the port to access on the container. Number must be
         in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :paramtype port: int
        """
        super(ContainerAppProbeTcpSocket, self).__init__(**kwargs)
        self.host = host
        self.port = port


class ContainerAppSecret(msrest.serialization.Model):
    """Container App Secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ContainerAppSecret, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ContainerResources(msrest.serialization.Model):
    """Container App container resource requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "250Mb".
    :vartype memory: str
    :ivar ephemeral_storage: Ephemeral Storage, e.g. "1Gi".
    :vartype ephemeral_storage: str
    """

    _validation = {
        'ephemeral_storage': {'readonly': True},
    }

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'float'},
        'memory': {'key': 'memory', 'type': 'str'},
        'ephemeral_storage': {'key': 'ephemeralStorage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cpu: Optional[float] = None,
        memory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "250Mb".
        :paramtype memory: str
        """
        super(ContainerResources, self).__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory
        self.ephemeral_storage = None


class CookieExpiration(msrest.serialization.Model):
    """The configuration settings of the session cookie's expiration.

    :ivar convention: The convention used when determining the session cookie's expiration.
     Possible values include: "FixedTime", "IdentityProviderDerived".
    :vartype convention: str or ~container_apps_api_client.models.CookieExpirationConvention
    :ivar time_to_expiration: The time after the request is made when the session cookie should
     expire.
    :vartype time_to_expiration: str
    """

    _attribute_map = {
        'convention': {'key': 'convention', 'type': 'str'},
        'time_to_expiration': {'key': 'timeToExpiration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "CookieExpirationConvention"]] = None,
        time_to_expiration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword convention: The convention used when determining the session cookie's expiration.
         Possible values include: "FixedTime", "IdentityProviderDerived".
        :paramtype convention: str or ~container_apps_api_client.models.CookieExpirationConvention
        :keyword time_to_expiration: The time after the request is made when the session cookie should
         expire.
        :paramtype time_to_expiration: str
        """
        super(CookieExpiration, self).__init__(**kwargs)
        self.convention = convention
        self.time_to_expiration = time_to_expiration


class CustomDomain(msrest.serialization.Model):
    """Custom Domain of a Container App.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Hostname.
    :vartype name: str
    :ivar binding_type: Custom Domain binding type. Possible values include: "Disabled",
     "SniEnabled".
    :vartype binding_type: str or ~container_apps_api_client.models.BindingType
    :ivar certificate_id: Required. Resource Id of the Certificate to be bound to this hostname.
     Must exist in the Managed Environment.
    :vartype certificate_id: str
    """

    _validation = {
        'name': {'required': True},
        'certificate_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'binding_type': {'key': 'bindingType', 'type': 'str'},
        'certificate_id': {'key': 'certificateId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        certificate_id: str,
        binding_type: Optional[Union[str, "BindingType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Hostname.
        :paramtype name: str
        :keyword binding_type: Custom Domain binding type. Possible values include: "Disabled",
         "SniEnabled".
        :paramtype binding_type: str or ~container_apps_api_client.models.BindingType
        :keyword certificate_id: Required. Resource Id of the Certificate to be bound to this hostname.
         Must exist in the Managed Environment.
        :paramtype certificate_id: str
        """
        super(CustomDomain, self).__init__(**kwargs)
        self.name = name
        self.binding_type = binding_type
        self.certificate_id = certificate_id


class CustomHostnameAnalysisResult(ProxyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar host_name: Host name that was analyzed.
    :vartype host_name: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Possible values include:
     "Passed", "Failed", "Skipped".
    :vartype custom_domain_verification_test: str or
     ~container_apps_api_client.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~container_apps_api_client.models.DefaultErrorResponse
    :ivar has_conflict_on_managed_environment: :code:`<code>true</code>` if there is a conflict on
     the Container App's managed environment; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_managed_environment: bool
    :ivar conflicting_container_app_resource_id: Name of the conflicting Container App on the
     Managed Environment if it's within the same subscription.
    :vartype conflicting_container_app_resource_id: str
    :ivar c_name_records: CName records visible for this hostname.
    :vartype c_name_records: list[str]
    :ivar txt_records: TXT records visible for this hostname.
    :vartype txt_records: list[str]
    :ivar a_records: A records visible for this hostname.
    :vartype a_records: list[str]
    :ivar alternate_c_name_records: Alternate CName records visible for this hostname.
    :vartype alternate_c_name_records: list[str]
    :ivar alternate_txt_records: Alternate TXT records visible for this hostname.
    :vartype alternate_txt_records: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'host_name': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_managed_environment': {'readonly': True},
        'conflicting_container_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'str'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'DefaultErrorResponse'},
        'has_conflict_on_managed_environment': {'key': 'properties.hasConflictOnManagedEnvironment', 'type': 'bool'},
        'conflicting_container_app_resource_id': {'key': 'properties.conflictingContainerAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_c_name_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword c_name_records: CName records visible for this hostname.
        :paramtype c_name_records: list[str]
        :keyword txt_records: TXT records visible for this hostname.
        :paramtype txt_records: list[str]
        :keyword a_records: A records visible for this hostname.
        :paramtype a_records: list[str]
        :keyword alternate_c_name_records: Alternate CName records visible for this hostname.
        :paramtype alternate_c_name_records: list[str]
        :keyword alternate_txt_records: Alternate TXT records visible for this hostname.
        :paramtype alternate_txt_records: list[str]
        """
        super(CustomHostnameAnalysisResult, self).__init__(**kwargs)
        self.host_name = None
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_managed_environment = None
        self.conflicting_container_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class CustomOpenIdConnectProvider(msrest.serialization.Model):
    """The configuration settings of the custom Open ID Connect provider.

    :ivar enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not be
     enabled; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the custom Open ID
     Connect provider.
    :vartype registration: ~container_apps_api_client.models.OpenIdConnectRegistration
    :ivar login: The configuration settings of the login flow of the custom Open ID Connect
     provider.
    :vartype login: ~container_apps_api_client.models.OpenIdConnectLogin
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'OpenIdConnectRegistration'},
        'login': {'key': 'login', 'type': 'OpenIdConnectLogin'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["OpenIdConnectRegistration"] = None,
        login: Optional["OpenIdConnectLogin"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not
         be enabled; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the custom Open
         ID Connect provider.
        :paramtype registration: ~container_apps_api_client.models.OpenIdConnectRegistration
        :keyword login: The configuration settings of the login flow of the custom Open ID Connect
         provider.
        :paramtype login: ~container_apps_api_client.models.OpenIdConnectLogin
        """
        super(CustomOpenIdConnectProvider, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class CustomScaleRule(msrest.serialization.Model):
    """Container App container Custom scaling rule.

    :ivar type: Type of the custom scale rule
     eg: azure-servicebus, redis etc.
    :vartype type: str
    :ivar metadata: Metadata properties to describe custom scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~container_apps_api_client.models.ScaleRuleAuth]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'auth': {'key': 'auth', 'type': '[ScaleRuleAuth]'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["ScaleRuleAuth"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of the custom scale rule
         eg: azure-servicebus, redis etc.
        :paramtype type: str
        :keyword metadata: Metadata properties to describe custom scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~container_apps_api_client.models.ScaleRuleAuth]
        """
        super(CustomScaleRule, self).__init__(**kwargs)
        self.type = type
        self.metadata = metadata
        self.auth = auth


class Dapr(msrest.serialization.Model):
    """Container App Dapr configuration.

    :ivar enabled: Boolean indicating if the Dapr side car is enabled.
    :vartype enabled: bool
    :ivar app_id: Dapr application identifier.
    :vartype app_id: str
    :ivar app_protocol: Tells Dapr which protocol your application is using. Valid options are http
     and grpc. Default is http. Possible values include: "http", "grpc".
    :vartype app_protocol: str or ~container_apps_api_client.models.AppProtocol
    :ivar app_port: Tells Dapr which port your application is listening on.
    :vartype app_port: int
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_protocol': {'key': 'appProtocol', 'type': 'str'},
        'app_port': {'key': 'appPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        app_id: Optional[str] = None,
        app_protocol: Optional[Union[str, "AppProtocol"]] = None,
        app_port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword enabled: Boolean indicating if the Dapr side car is enabled.
        :paramtype enabled: bool
        :keyword app_id: Dapr application identifier.
        :paramtype app_id: str
        :keyword app_protocol: Tells Dapr which protocol your application is using. Valid options are
         http and grpc. Default is http. Possible values include: "http", "grpc".
        :paramtype app_protocol: str or ~container_apps_api_client.models.AppProtocol
        :keyword app_port: Tells Dapr which port your application is listening on.
        :paramtype app_port: int
        """
        super(Dapr, self).__init__(**kwargs)
        self.enabled = enabled
        self.app_id = app_id
        self.app_protocol = app_protocol
        self.app_port = app_port


class DaprComponent(ProxyResource):
    """Dapr Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar component_type: Component type.
    :vartype component_type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar ignore_errors: Boolean describing if the component errors are ignores.
    :vartype ignore_errors: bool
    :ivar init_timeout: Initialization timeout.
    :vartype init_timeout: str
    :ivar secrets: Collection of secrets used by a Dapr component.
    :vartype secrets: list[~container_apps_api_client.models.Secret]
    :ivar metadata: Component metadata.
    :vartype metadata: list[~container_apps_api_client.models.DaprMetadata]
    :ivar scopes: Names of container apps that can use this Dapr component.
    :vartype scopes: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'component_type': {'key': 'properties.componentType', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ignore_errors': {'key': 'properties.ignoreErrors', 'type': 'bool'},
        'init_timeout': {'key': 'properties.initTimeout', 'type': 'str'},
        'secrets': {'key': 'properties.secrets', 'type': '[Secret]'},
        'metadata': {'key': 'properties.metadata', 'type': '[DaprMetadata]'},
        'scopes': {'key': 'properties.scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        component_type: Optional[str] = None,
        version: Optional[str] = None,
        ignore_errors: Optional[bool] = None,
        init_timeout: Optional[str] = None,
        secrets: Optional[List["Secret"]] = None,
        metadata: Optional[List["DaprMetadata"]] = None,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword component_type: Component type.
        :paramtype component_type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword ignore_errors: Boolean describing if the component errors are ignores.
        :paramtype ignore_errors: bool
        :keyword init_timeout: Initialization timeout.
        :paramtype init_timeout: str
        :keyword secrets: Collection of secrets used by a Dapr component.
        :paramtype secrets: list[~container_apps_api_client.models.Secret]
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~container_apps_api_client.models.DaprMetadata]
        :keyword scopes: Names of container apps that can use this Dapr component.
        :paramtype scopes: list[str]
        """
        super(DaprComponent, self).__init__(**kwargs)
        self.component_type = component_type
        self.version = version
        self.ignore_errors = ignore_errors
        self.init_timeout = init_timeout
        self.secrets = secrets
        self.metadata = metadata
        self.scopes = scopes


class DaprComponentsCollection(msrest.serialization.Model):
    """Dapr Components ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.DaprComponent]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DaprComponent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DaprComponent"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.DaprComponent]
        """
        super(DaprComponentsCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DaprMetadata(msrest.serialization.Model):
    """Dapr component metadata.

    :ivar name: Metadata property name.
    :vartype name: str
    :ivar value: Metadata property value.
    :vartype value: str
    :ivar secret_ref: Name of the Dapr Component secret from which to pull the metadata property
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'secret_ref': {'key': 'secretRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Metadata property name.
        :paramtype name: str
        :keyword value: Metadata property value.
        :paramtype value: str
        :keyword secret_ref: Name of the Dapr Component secret from which to pull the metadata property
         value.
        :paramtype secret_ref: str
        """
        super(DaprMetadata, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class DefaultAuthorizationPolicy(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory default authorization policy.

    :ivar allowed_principals: The configuration settings of the Azure Active Directory allowed
     principals.
    :vartype allowed_principals: ~container_apps_api_client.models.AllowedPrincipals
    :ivar allowed_applications: The configuration settings of the Azure Active Directory allowed
     applications.
    :vartype allowed_applications: list[str]
    """

    _attribute_map = {
        'allowed_principals': {'key': 'allowedPrincipals', 'type': 'AllowedPrincipals'},
        'allowed_applications': {'key': 'allowedApplications', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_principals: Optional["AllowedPrincipals"] = None,
        allowed_applications: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword allowed_principals: The configuration settings of the Azure Active Directory allowed
         principals.
        :paramtype allowed_principals: ~container_apps_api_client.models.AllowedPrincipals
        :keyword allowed_applications: The configuration settings of the Azure Active Directory allowed
         applications.
        :paramtype allowed_applications: list[str]
        """
        super(DefaultAuthorizationPolicy, self).__init__(**kwargs)
        self.allowed_principals = allowed_principals
        self.allowed_applications = allowed_applications


class DefaultErrorResponse(msrest.serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~container_apps_api_client.models.DefaultErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DefaultErrorResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(msrest.serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details: Details or the error.
    :vartype details: list[~container_apps_api_client.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'innererror': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DefaultErrorResponseErrorDetailsItem]'},
        'innererror': {'key': 'innererror', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["DefaultErrorResponseErrorDetailsItem"]] = None,
        **kwargs
    ):
        """
        :keyword details: Details or the error.
        :paramtype details:
         list[~container_apps_api_client.models.DefaultErrorResponseErrorDetailsItem]
        """
        super(DefaultErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = details
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(msrest.serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultErrorResponseErrorDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class EnvironmentVar(msrest.serialization.Model):
    """Container App container environment variable.

    :ivar name: Environment variable name.
    :vartype name: str
    :ivar value: Non-secret environment variable value.
    :vartype value: str
    :ivar secret_ref: Name of the Container App secret from which to pull the environment variable
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'secret_ref': {'key': 'secretRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Environment variable name.
        :paramtype name: str
        :keyword value: Non-secret environment variable value.
        :paramtype value: str
        :keyword secret_ref: Name of the Container App secret from which to pull the environment
         variable value.
        :paramtype secret_ref: str
        """
        super(EnvironmentVar, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class Facebook(msrest.serialization.Model):
    """The configuration settings of the Facebook provider.

    :ivar enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
     despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Facebook
     provider.
    :vartype registration: ~container_apps_api_client.models.AppRegistration
    :ivar graph_api_version: The version of the Facebook api to be used while logging in.
    :vartype graph_api_version: str
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~container_apps_api_client.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AppRegistration'},
        'graph_api_version': {'key': 'graphApiVersion', 'type': 'str'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AppRegistration"] = None,
        graph_api_version: Optional[str] = None,
        login: Optional["LoginScopes"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Facebook
         provider.
        :paramtype registration: ~container_apps_api_client.models.AppRegistration
        :keyword graph_api_version: The version of the Facebook api to be used while logging in.
        :paramtype graph_api_version: str
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~container_apps_api_client.models.LoginScopes
        """
        super(Facebook, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.graph_api_version = graph_api_version
        self.login = login


class ForwardProxy(msrest.serialization.Model):
    """The configuration settings of a forward proxy used to make the requests.

    :ivar convention: The convention used to determine the url of the request made. Possible values
     include: "NoProxy", "Standard", "Custom".
    :vartype convention: str or ~container_apps_api_client.models.ForwardProxyConvention
    :ivar custom_host_header_name: The name of the header containing the host of the request.
    :vartype custom_host_header_name: str
    :ivar custom_proto_header_name: The name of the header containing the scheme of the request.
    :vartype custom_proto_header_name: str
    """

    _attribute_map = {
        'convention': {'key': 'convention', 'type': 'str'},
        'custom_host_header_name': {'key': 'customHostHeaderName', 'type': 'str'},
        'custom_proto_header_name': {'key': 'customProtoHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "ForwardProxyConvention"]] = None,
        custom_host_header_name: Optional[str] = None,
        custom_proto_header_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword convention: The convention used to determine the url of the request made. Possible
         values include: "NoProxy", "Standard", "Custom".
        :paramtype convention: str or ~container_apps_api_client.models.ForwardProxyConvention
        :keyword custom_host_header_name: The name of the header containing the host of the request.
        :paramtype custom_host_header_name: str
        :keyword custom_proto_header_name: The name of the header containing the scheme of the request.
        :paramtype custom_proto_header_name: str
        """
        super(ForwardProxy, self).__init__(**kwargs)
        self.convention = convention
        self.custom_host_header_name = custom_host_header_name
        self.custom_proto_header_name = custom_proto_header_name


class GitHub(msrest.serialization.Model):
    """The configuration settings of the GitHub provider.

    :ivar enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the GitHub provider.
    :vartype registration: ~container_apps_api_client.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~container_apps_api_client.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["ClientRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the GitHub
         provider.
        :paramtype registration: ~container_apps_api_client.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~container_apps_api_client.models.LoginScopes
        """
        super(GitHub, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class GithubActionConfiguration(msrest.serialization.Model):
    """Configuration properties that define the mutable settings of a Container App SourceControl.

    :ivar registry_info: Registry configurations.
    :vartype registry_info: ~container_apps_api_client.models.RegistryInfo
    :ivar azure_credentials: AzureCredentials configurations.
    :vartype azure_credentials: ~container_apps_api_client.models.AzureCredentials
    :ivar dockerfile_path: Docker file path.
    :vartype dockerfile_path: str
    :ivar publish_type: Code or Image.
    :vartype publish_type: str
    :ivar os: Operation system.
    :vartype os: str
    :ivar runtime_stack: Runtime stack.
    :vartype runtime_stack: str
    :ivar runtime_version: Runtime Version.
    :vartype runtime_version: str
    """

    _attribute_map = {
        'registry_info': {'key': 'registryInfo', 'type': 'RegistryInfo'},
        'azure_credentials': {'key': 'azureCredentials', 'type': 'AzureCredentials'},
        'dockerfile_path': {'key': 'dockerfilePath', 'type': 'str'},
        'publish_type': {'key': 'publishType', 'type': 'str'},
        'os': {'key': 'os', 'type': 'str'},
        'runtime_stack': {'key': 'runtimeStack', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        registry_info: Optional["RegistryInfo"] = None,
        azure_credentials: Optional["AzureCredentials"] = None,
        dockerfile_path: Optional[str] = None,
        publish_type: Optional[str] = None,
        os: Optional[str] = None,
        runtime_stack: Optional[str] = None,
        runtime_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword registry_info: Registry configurations.
        :paramtype registry_info: ~container_apps_api_client.models.RegistryInfo
        :keyword azure_credentials: AzureCredentials configurations.
        :paramtype azure_credentials: ~container_apps_api_client.models.AzureCredentials
        :keyword dockerfile_path: Docker file path.
        :paramtype dockerfile_path: str
        :keyword publish_type: Code or Image.
        :paramtype publish_type: str
        :keyword os: Operation system.
        :paramtype os: str
        :keyword runtime_stack: Runtime stack.
        :paramtype runtime_stack: str
        :keyword runtime_version: Runtime Version.
        :paramtype runtime_version: str
        """
        super(GithubActionConfiguration, self).__init__(**kwargs)
        self.registry_info = registry_info
        self.azure_credentials = azure_credentials
        self.dockerfile_path = dockerfile_path
        self.publish_type = publish_type
        self.os = os
        self.runtime_stack = runtime_stack
        self.runtime_version = runtime_version


class GlobalValidation(msrest.serialization.Model):
    """The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.

    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous",
     "Return401", "Return403".
    :vartype unauthenticated_client_action: str or
     ~container_apps_api_client.models.UnauthenticatedClientActionV2
    :ivar redirect_to_provider: The default authentication provider to use when multiple providers
     are configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage".
    :vartype redirect_to_provider: str
    :ivar excluded_paths: The paths for which unauthenticated flow would not be redirected to the
     login page.
    :vartype excluded_paths: list[str]
    """

    _attribute_map = {
        'unauthenticated_client_action': {'key': 'unauthenticatedClientAction', 'type': 'str'},
        'redirect_to_provider': {'key': 'redirectToProvider', 'type': 'str'},
        'excluded_paths': {'key': 'excludedPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        unauthenticated_client_action: Optional[Union[str, "UnauthenticatedClientActionV2"]] = None,
        redirect_to_provider: Optional[str] = None,
        excluded_paths: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous",
         "Return401", "Return403".
        :paramtype unauthenticated_client_action: str or
         ~container_apps_api_client.models.UnauthenticatedClientActionV2
        :keyword redirect_to_provider: The default authentication provider to use when multiple
         providers are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage".
        :paramtype redirect_to_provider: str
        :keyword excluded_paths: The paths for which unauthenticated flow would not be redirected to
         the login page.
        :paramtype excluded_paths: list[str]
        """
        super(GlobalValidation, self).__init__(**kwargs)
        self.unauthenticated_client_action = unauthenticated_client_action
        self.redirect_to_provider = redirect_to_provider
        self.excluded_paths = excluded_paths


class Google(msrest.serialization.Model):
    """The configuration settings of the Google provider.

    :ivar enabled: :code:`<code>false</code>` if the Google provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Google provider.
    :vartype registration: ~container_apps_api_client.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~container_apps_api_client.models.LoginScopes
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~container_apps_api_client.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
        'validation': {'key': 'validation', 'type': 'AllowedAudiencesValidation'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["ClientRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        validation: Optional["AllowedAudiencesValidation"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Google provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Google
         provider.
        :paramtype registration: ~container_apps_api_client.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~container_apps_api_client.models.LoginScopes
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~container_apps_api_client.models.AllowedAudiencesValidation
        """
        super(Google, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation


class HttpScaleRule(msrest.serialization.Model):
    """Container App container Custom scaling rule.

    :ivar metadata: Metadata properties to describe http scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~container_apps_api_client.models.ScaleRuleAuth]
    """

    _attribute_map = {
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'auth': {'key': 'auth', 'type': '[ScaleRuleAuth]'},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["ScaleRuleAuth"]] = None,
        **kwargs
    ):
        """
        :keyword metadata: Metadata properties to describe http scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~container_apps_api_client.models.ScaleRuleAuth]
        """
        super(HttpScaleRule, self).__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth


class HttpSettings(msrest.serialization.Model):
    """The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.

    :ivar require_https: :code:`<code>false</code>` if the authentication/authorization responses
     not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
    :vartype require_https: bool
    :ivar routes: The configuration settings of the paths HTTP requests.
    :vartype routes: ~container_apps_api_client.models.HttpSettingsRoutes
    :ivar forward_proxy: The configuration settings of a forward proxy used to make the requests.
    :vartype forward_proxy: ~container_apps_api_client.models.ForwardProxy
    """

    _attribute_map = {
        'require_https': {'key': 'requireHttps', 'type': 'bool'},
        'routes': {'key': 'routes', 'type': 'HttpSettingsRoutes'},
        'forward_proxy': {'key': 'forwardProxy', 'type': 'ForwardProxy'},
    }

    def __init__(
        self,
        *,
        require_https: Optional[bool] = None,
        routes: Optional["HttpSettingsRoutes"] = None,
        forward_proxy: Optional["ForwardProxy"] = None,
        **kwargs
    ):
        """
        :keyword require_https: :code:`<code>false</code>` if the authentication/authorization
         responses not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
        :paramtype require_https: bool
        :keyword routes: The configuration settings of the paths HTTP requests.
        :paramtype routes: ~container_apps_api_client.models.HttpSettingsRoutes
        :keyword forward_proxy: The configuration settings of a forward proxy used to make the
         requests.
        :paramtype forward_proxy: ~container_apps_api_client.models.ForwardProxy
        """
        super(HttpSettings, self).__init__(**kwargs)
        self.require_https = require_https
        self.routes = routes
        self.forward_proxy = forward_proxy


class HttpSettingsRoutes(msrest.serialization.Model):
    """The configuration settings of the paths HTTP requests.

    :ivar api_prefix: The prefix that should precede all the authentication/authorization paths.
    :vartype api_prefix: str
    """

    _attribute_map = {
        'api_prefix': {'key': 'apiPrefix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        api_prefix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_prefix: The prefix that should precede all the authentication/authorization paths.
        :paramtype api_prefix: str
        """
        super(HttpSettingsRoutes, self).__init__(**kwargs)
        self.api_prefix = api_prefix


class IdentityProviders(msrest.serialization.Model):
    """The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.

    :ivar azure_active_directory: The configuration settings of the Azure Active directory
     provider.
    :vartype azure_active_directory: ~container_apps_api_client.models.AzureActiveDirectory
    :ivar facebook: The configuration settings of the Facebook provider.
    :vartype facebook: ~container_apps_api_client.models.Facebook
    :ivar git_hub: The configuration settings of the GitHub provider.
    :vartype git_hub: ~container_apps_api_client.models.GitHub
    :ivar google: The configuration settings of the Google provider.
    :vartype google: ~container_apps_api_client.models.Google
    :ivar twitter: The configuration settings of the Twitter provider.
    :vartype twitter: ~container_apps_api_client.models.Twitter
    :ivar apple: The configuration settings of the Apple provider.
    :vartype apple: ~container_apps_api_client.models.Apple
    :ivar azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
    :vartype azure_static_web_apps: ~container_apps_api_client.models.AzureStaticWebApps
    :ivar custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID
     Connect provider to the
     configuration settings of the custom Open ID Connect provider.
    :vartype custom_open_id_connect_providers: dict[str,
     ~container_apps_api_client.models.CustomOpenIdConnectProvider]
    """

    _attribute_map = {
        'azure_active_directory': {'key': 'azureActiveDirectory', 'type': 'AzureActiveDirectory'},
        'facebook': {'key': 'facebook', 'type': 'Facebook'},
        'git_hub': {'key': 'gitHub', 'type': 'GitHub'},
        'google': {'key': 'google', 'type': 'Google'},
        'twitter': {'key': 'twitter', 'type': 'Twitter'},
        'apple': {'key': 'apple', 'type': 'Apple'},
        'azure_static_web_apps': {'key': 'azureStaticWebApps', 'type': 'AzureStaticWebApps'},
        'custom_open_id_connect_providers': {'key': 'customOpenIdConnectProviders', 'type': '{CustomOpenIdConnectProvider}'},
    }

    def __init__(
        self,
        *,
        azure_active_directory: Optional["AzureActiveDirectory"] = None,
        facebook: Optional["Facebook"] = None,
        git_hub: Optional["GitHub"] = None,
        google: Optional["Google"] = None,
        twitter: Optional["Twitter"] = None,
        apple: Optional["Apple"] = None,
        azure_static_web_apps: Optional["AzureStaticWebApps"] = None,
        custom_open_id_connect_providers: Optional[Dict[str, "CustomOpenIdConnectProvider"]] = None,
        **kwargs
    ):
        """
        :keyword azure_active_directory: The configuration settings of the Azure Active directory
         provider.
        :paramtype azure_active_directory: ~container_apps_api_client.models.AzureActiveDirectory
        :keyword facebook: The configuration settings of the Facebook provider.
        :paramtype facebook: ~container_apps_api_client.models.Facebook
        :keyword git_hub: The configuration settings of the GitHub provider.
        :paramtype git_hub: ~container_apps_api_client.models.GitHub
        :keyword google: The configuration settings of the Google provider.
        :paramtype google: ~container_apps_api_client.models.Google
        :keyword twitter: The configuration settings of the Twitter provider.
        :paramtype twitter: ~container_apps_api_client.models.Twitter
        :keyword apple: The configuration settings of the Apple provider.
        :paramtype apple: ~container_apps_api_client.models.Apple
        :keyword azure_static_web_apps: The configuration settings of the Azure Static Web Apps
         provider.
        :paramtype azure_static_web_apps: ~container_apps_api_client.models.AzureStaticWebApps
        :keyword custom_open_id_connect_providers: The map of the name of the alias of each custom Open
         ID Connect provider to the
         configuration settings of the custom Open ID Connect provider.
        :paramtype custom_open_id_connect_providers: dict[str,
         ~container_apps_api_client.models.CustomOpenIdConnectProvider]
        """
        super(IdentityProviders, self).__init__(**kwargs)
        self.azure_active_directory = azure_active_directory
        self.facebook = facebook
        self.git_hub = git_hub
        self.google = google
        self.twitter = twitter
        self.apple = apple
        self.azure_static_web_apps = azure_static_web_apps
        self.custom_open_id_connect_providers = custom_open_id_connect_providers


class Ingress(msrest.serialization.Model):
    """Container App Ingress configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar fqdn: Hostname.
    :vartype fqdn: str
    :ivar external: Bool indicating if app exposes an external http endpoint.
    :vartype external: bool
    :ivar target_port: Target Port in containers for traffic from ingress.
    :vartype target_port: int
    :ivar transport: Ingress transport protocol. Possible values include: "auto", "http", "http2".
    :vartype transport: str or ~container_apps_api_client.models.IngressTransportMethod
    :ivar traffic: Traffic weights for app's revisions.
    :vartype traffic: list[~container_apps_api_client.models.TrafficWeight]
    :ivar custom_domains: custom domain bindings for Container Apps' hostnames.
    :vartype custom_domains: list[~container_apps_api_client.models.CustomDomain]
    :ivar allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP
     connections are automatically redirected to HTTPS connections.
    :vartype allow_insecure: bool
    """

    _validation = {
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'external': {'key': 'external', 'type': 'bool'},
        'target_port': {'key': 'targetPort', 'type': 'int'},
        'transport': {'key': 'transport', 'type': 'str'},
        'traffic': {'key': 'traffic', 'type': '[TrafficWeight]'},
        'custom_domains': {'key': 'customDomains', 'type': '[CustomDomain]'},
        'allow_insecure': {'key': 'allowInsecure', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        external: Optional[bool] = False,
        target_port: Optional[int] = None,
        transport: Optional[Union[str, "IngressTransportMethod"]] = None,
        traffic: Optional[List["TrafficWeight"]] = None,
        custom_domains: Optional[List["CustomDomain"]] = None,
        allow_insecure: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword external: Bool indicating if app exposes an external http endpoint.
        :paramtype external: bool
        :keyword target_port: Target Port in containers for traffic from ingress.
        :paramtype target_port: int
        :keyword transport: Ingress transport protocol. Possible values include: "auto", "http",
         "http2".
        :paramtype transport: str or ~container_apps_api_client.models.IngressTransportMethod
        :keyword traffic: Traffic weights for app's revisions.
        :paramtype traffic: list[~container_apps_api_client.models.TrafficWeight]
        :keyword custom_domains: custom domain bindings for Container Apps' hostnames.
        :paramtype custom_domains: list[~container_apps_api_client.models.CustomDomain]
        :keyword allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false
         HTTP connections are automatically redirected to HTTPS connections.
        :paramtype allow_insecure: bool
        """
        super(Ingress, self).__init__(**kwargs)
        self.fqdn = None
        self.external = external
        self.target_port = target_port
        self.transport = transport
        self.traffic = traffic
        self.custom_domains = custom_domains
        self.allow_insecure = allow_insecure


class JwtClaimChecks(msrest.serialization.Model):
    """The configuration settings of the checks that should be made while validating the JWT Claims.

    :ivar allowed_groups: The list of the allowed groups.
    :vartype allowed_groups: list[str]
    :ivar allowed_client_applications: The list of the allowed client applications.
    :vartype allowed_client_applications: list[str]
    """

    _attribute_map = {
        'allowed_groups': {'key': 'allowedGroups', 'type': '[str]'},
        'allowed_client_applications': {'key': 'allowedClientApplications', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_groups: Optional[List[str]] = None,
        allowed_client_applications: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword allowed_groups: The list of the allowed groups.
        :paramtype allowed_groups: list[str]
        :keyword allowed_client_applications: The list of the allowed client applications.
        :paramtype allowed_client_applications: list[str]
        """
        super(JwtClaimChecks, self).__init__(**kwargs)
        self.allowed_groups = allowed_groups
        self.allowed_client_applications = allowed_client_applications


class LogAnalyticsConfiguration(msrest.serialization.Model):
    """Log analytics configuration.

    :ivar customer_id: Log analytics customer id.
    :vartype customer_id: str
    :ivar shared_key: Log analytics customer key.
    :vartype shared_key: str
    """

    _attribute_map = {
        'customer_id': {'key': 'customerId', 'type': 'str'},
        'shared_key': {'key': 'sharedKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        customer_id: Optional[str] = None,
        shared_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword customer_id: Log analytics customer id.
        :paramtype customer_id: str
        :keyword shared_key: Log analytics customer key.
        :paramtype shared_key: str
        """
        super(LogAnalyticsConfiguration, self).__init__(**kwargs)
        self.customer_id = customer_id
        self.shared_key = shared_key


class Login(msrest.serialization.Model):
    """The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.

    :ivar routes: The routes that specify the endpoints used for login and logout requests.
    :vartype routes: ~container_apps_api_client.models.LoginRoutes
    :ivar preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
     request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
    :vartype preserve_url_fragments_for_logins: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar cookie_expiration: The configuration settings of the session cookie's expiration.
    :vartype cookie_expiration: ~container_apps_api_client.models.CookieExpiration
    :ivar nonce: The configuration settings of the nonce used in the login flow.
    :vartype nonce: ~container_apps_api_client.models.Nonce
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': 'LoginRoutes'},
        'preserve_url_fragments_for_logins': {'key': 'preserveUrlFragmentsForLogins', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'allowedExternalRedirectUrls', 'type': '[str]'},
        'cookie_expiration': {'key': 'cookieExpiration', 'type': 'CookieExpiration'},
        'nonce': {'key': 'nonce', 'type': 'Nonce'},
    }

    def __init__(
        self,
        *,
        routes: Optional["LoginRoutes"] = None,
        preserve_url_fragments_for_logins: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        cookie_expiration: Optional["CookieExpiration"] = None,
        nonce: Optional["Nonce"] = None,
        **kwargs
    ):
        """
        :keyword routes: The routes that specify the endpoints used for login and logout requests.
        :paramtype routes: ~container_apps_api_client.models.LoginRoutes
        :keyword preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
         request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
        :paramtype preserve_url_fragments_for_logins: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword cookie_expiration: The configuration settings of the session cookie's expiration.
        :paramtype cookie_expiration: ~container_apps_api_client.models.CookieExpiration
        :keyword nonce: The configuration settings of the nonce used in the login flow.
        :paramtype nonce: ~container_apps_api_client.models.Nonce
        """
        super(Login, self).__init__(**kwargs)
        self.routes = routes
        self.preserve_url_fragments_for_logins = preserve_url_fragments_for_logins
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.cookie_expiration = cookie_expiration
        self.nonce = nonce


class LoginRoutes(msrest.serialization.Model):
    """The routes that specify the endpoints used for login and logout requests.

    :ivar logout_endpoint: The endpoint at which a logout request should be made.
    :vartype logout_endpoint: str
    """

    _attribute_map = {
        'logout_endpoint': {'key': 'logoutEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logout_endpoint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword logout_endpoint: The endpoint at which a logout request should be made.
        :paramtype logout_endpoint: str
        """
        super(LoginRoutes, self).__init__(**kwargs)
        self.logout_endpoint = logout_endpoint


class LoginScopes(msrest.serialization.Model):
    """The configuration settings of the login flow, including the scopes that should be requested.

    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super(LoginScopes, self).__init__(**kwargs)
        self.scopes = scopes


class ManagedEnvironment(TrackedResource):
    """An environment for hosting container apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the Environment. Possible values include:
     "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", "UpgradeFailed".
    :vartype provisioning_state: str or
     ~container_apps_api_client.models.EnvironmentProvisioningState
    :ivar dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export
     Service to Service communication telemetry.
    :vartype dapr_ai_instrumentation_key: str
    :ivar vnet_configuration: Vnet configuration for the environment.
    :vartype vnet_configuration: ~container_apps_api_client.models.VnetConfiguration
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar static_ip: Static IP of the Environment.
    :vartype static_ip: str
    :ivar app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :vartype app_logs_configuration: ~container_apps_api_client.models.AppLogsConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'deployment_errors': {'readonly': True},
        'default_domain': {'readonly': True},
        'static_ip': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'dapr_ai_instrumentation_key': {'key': 'properties.daprAIInstrumentationKey', 'type': 'str'},
        'vnet_configuration': {'key': 'properties.vnetConfiguration', 'type': 'VnetConfiguration'},
        'deployment_errors': {'key': 'properties.deploymentErrors', 'type': 'str'},
        'default_domain': {'key': 'properties.defaultDomain', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIp', 'type': 'str'},
        'app_logs_configuration': {'key': 'properties.appLogsConfiguration', 'type': 'AppLogsConfiguration'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        dapr_ai_instrumentation_key: Optional[str] = None,
        vnet_configuration: Optional["VnetConfiguration"] = None,
        app_logs_configuration: Optional["AppLogsConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export
         Service to Service communication telemetry.
        :paramtype dapr_ai_instrumentation_key: str
        :keyword vnet_configuration: Vnet configuration for the environment.
        :paramtype vnet_configuration: ~container_apps_api_client.models.VnetConfiguration
        :keyword app_logs_configuration: Cluster configuration which enables the log daemon to export
         app logs to a destination. Currently only "log-analytics" is
         supported.
        :paramtype app_logs_configuration: ~container_apps_api_client.models.AppLogsConfiguration
        """
        super(ManagedEnvironment, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.dapr_ai_instrumentation_key = dapr_ai_instrumentation_key
        self.vnet_configuration = vnet_configuration
        self.deployment_errors = None
        self.default_domain = None
        self.static_ip = None
        self.app_logs_configuration = app_logs_configuration


class ManagedEnvironmentPatch(msrest.serialization.Model):
    """An environment for hosting container apps.

    :ivar tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super(ManagedEnvironmentPatch, self).__init__(**kwargs)
        self.tags = tags


class ManagedEnvironmentsCollection(msrest.serialization.Model):
    """Collection of Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.ManagedEnvironment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedEnvironment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ManagedEnvironment"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.ManagedEnvironment]
        """
        super(ManagedEnvironmentsCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ManagedEnvironmentStorage(ProxyResource):
    """Storage resource for managedEnvironment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar properties: Storage properties.
    :vartype properties: ~container_apps_api_client.models.ManagedEnvironmentStorageProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ManagedEnvironmentStorageProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ManagedEnvironmentStorageProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Storage properties.
        :paramtype properties: ~container_apps_api_client.models.ManagedEnvironmentStorageProperties
        """
        super(ManagedEnvironmentStorage, self).__init__(**kwargs)
        self.properties = properties


class ManagedEnvironmentStorageProperties(msrest.serialization.Model):
    """Storage properties.

    :ivar azure_file: Azure file properties.
    :vartype azure_file: ~container_apps_api_client.models.AzureFileProperties
    """

    _attribute_map = {
        'azure_file': {'key': 'azureFile', 'type': 'AzureFileProperties'},
    }

    def __init__(
        self,
        *,
        azure_file: Optional["AzureFileProperties"] = None,
        **kwargs
    ):
        """
        :keyword azure_file: Azure file properties.
        :paramtype azure_file: ~container_apps_api_client.models.AzureFileProperties
        """
        super(ManagedEnvironmentStorageProperties, self).__init__(**kwargs)
        self.azure_file = azure_file


class ManagedEnvironmentStoragesCollection(msrest.serialization.Model):
    """Collection of Storage for Environments.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of storage resources.
    :vartype value: list[~container_apps_api_client.models.ManagedEnvironmentStorage]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedEnvironmentStorage]'},
    }

    def __init__(
        self,
        *,
        value: List["ManagedEnvironmentStorage"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of storage resources.
        :paramtype value: list[~container_apps_api_client.models.ManagedEnvironmentStorage]
        """
        super(ManagedEnvironmentStoragesCollection, self).__init__(**kwargs)
        self.value = value


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Required. Type of managed service identity (where both SystemAssigned and
     UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :vartype type: str or ~container_apps_api_client.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~container_apps_api_client.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Type of managed service identity (where both SystemAssigned and
         UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
         "UserAssigned", "SystemAssigned,UserAssigned".
        :paramtype type: str or ~container_apps_api_client.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~container_apps_api_client.models.UserAssignedIdentity]
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Nonce(msrest.serialization.Model):
    """The configuration settings of the nonce used in the login flow.

    :ivar validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
     completing the login flow; otherwise, :code:`<code>true</code>`.
    :vartype validate_nonce: bool
    :ivar nonce_expiration_interval: The time after the request is made when the nonce should
     expire.
    :vartype nonce_expiration_interval: str
    """

    _attribute_map = {
        'validate_nonce': {'key': 'validateNonce', 'type': 'bool'},
        'nonce_expiration_interval': {'key': 'nonceExpirationInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validate_nonce: Optional[bool] = None,
        nonce_expiration_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
         completing the login flow; otherwise, :code:`<code>true</code>`.
        :paramtype validate_nonce: bool
        :keyword nonce_expiration_interval: The time after the request is made when the nonce should
         expire.
        :paramtype nonce_expiration_interval: str
        """
        super(Nonce, self).__init__(**kwargs)
        self.validate_nonce = validate_nonce
        self.nonce_expiration_interval = nonce_expiration_interval


class OpenIdConnectClientCredential(msrest.serialization.Model):
    """The authentication client credentials of the custom Open ID Connect provider.

    :ivar method: The method that should be used to authenticate the user. The only acceptable
     values to pass in are None and "ClientSecretPost". The default value is None.
    :vartype method: str
    :ivar client_secret_setting_name: The app setting that contains the client secret for the
     custom Open ID Connect provider.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        method: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword method: The method that should be used to authenticate the user. The only acceptable
         values to pass in are None and "ClientSecretPost". The default value is None.
        :paramtype method: str
        :keyword client_secret_setting_name: The app setting that contains the client secret for the
         custom Open ID Connect provider.
        :paramtype client_secret_setting_name: str
        """
        super(OpenIdConnectClientCredential, self).__init__(**kwargs)
        self.method = method
        self.client_secret_setting_name = client_secret_setting_name


class OpenIdConnectConfig(msrest.serialization.Model):
    """The configuration settings of the endpoints used for the custom Open ID Connect provider.

    :ivar authorization_endpoint: The endpoint to be used to make an authorization request.
    :vartype authorization_endpoint: str
    :ivar token_endpoint: The endpoint to be used to request a token.
    :vartype token_endpoint: str
    :ivar issuer: The endpoint that issues the token.
    :vartype issuer: str
    :ivar certification_uri: The endpoint that provides the keys necessary to validate the token.
    :vartype certification_uri: str
    :ivar well_known_open_id_configuration: The endpoint that contains all the configuration
     endpoints for the provider.
    :vartype well_known_open_id_configuration: str
    """

    _attribute_map = {
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'certification_uri': {'key': 'certificationUri', 'type': 'str'},
        'well_known_open_id_configuration': {'key': 'wellKnownOpenIdConfiguration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_endpoint: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        issuer: Optional[str] = None,
        certification_uri: Optional[str] = None,
        well_known_open_id_configuration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authorization_endpoint: The endpoint to be used to make an authorization request.
        :paramtype authorization_endpoint: str
        :keyword token_endpoint: The endpoint to be used to request a token.
        :paramtype token_endpoint: str
        :keyword issuer: The endpoint that issues the token.
        :paramtype issuer: str
        :keyword certification_uri: The endpoint that provides the keys necessary to validate the
         token.
        :paramtype certification_uri: str
        :keyword well_known_open_id_configuration: The endpoint that contains all the configuration
         endpoints for the provider.
        :paramtype well_known_open_id_configuration: str
        """
        super(OpenIdConnectConfig, self).__init__(**kwargs)
        self.authorization_endpoint = authorization_endpoint
        self.token_endpoint = token_endpoint
        self.issuer = issuer
        self.certification_uri = certification_uri
        self.well_known_open_id_configuration = well_known_open_id_configuration


class OpenIdConnectLogin(msrest.serialization.Model):
    """The configuration settings of the login flow of the custom Open ID Connect provider.

    :ivar name_claim_type: The name of the claim that contains the users name.
    :vartype name_claim_type: str
    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        'name_claim_type': {'key': 'nameClaimType', 'type': 'str'},
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name_claim_type: Optional[str] = None,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name_claim_type: The name of the claim that contains the users name.
        :paramtype name_claim_type: str
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super(OpenIdConnectLogin, self).__init__(**kwargs)
        self.name_claim_type = name_claim_type
        self.scopes = scopes


class OpenIdConnectRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for the custom Open ID Connect provider.

    :ivar client_id: The client id of the custom Open ID Connect provider.
    :vartype client_id: str
    :ivar client_credential: The authentication credentials of the custom Open ID Connect provider.
    :vartype client_credential: ~container_apps_api_client.models.OpenIdConnectClientCredential
    :ivar open_id_connect_configuration: The configuration settings of the endpoints used for the
     custom Open ID Connect provider.
    :vartype open_id_connect_configuration: ~container_apps_api_client.models.OpenIdConnectConfig
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_credential': {'key': 'clientCredential', 'type': 'OpenIdConnectClientCredential'},
        'open_id_connect_configuration': {'key': 'openIdConnectConfiguration', 'type': 'OpenIdConnectConfig'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_credential: Optional["OpenIdConnectClientCredential"] = None,
        open_id_connect_configuration: Optional["OpenIdConnectConfig"] = None,
        **kwargs
    ):
        """
        :keyword client_id: The client id of the custom Open ID Connect provider.
        :paramtype client_id: str
        :keyword client_credential: The authentication credentials of the custom Open ID Connect
         provider.
        :paramtype client_credential: ~container_apps_api_client.models.OpenIdConnectClientCredential
        :keyword open_id_connect_configuration: The configuration settings of the endpoints used for
         the custom Open ID Connect provider.
        :paramtype open_id_connect_configuration: ~container_apps_api_client.models.OpenIdConnectConfig
        """
        super(OpenIdConnectRegistration, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_credential = client_credential
        self.open_id_connect_configuration = open_id_connect_configuration


class OperationDetail(msrest.serialization.Model):
    """Operation detail payload.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~container_apps_api_client.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~container_apps_api_client.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        """
        super(OperationDetail, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin


class OperationDisplay(msrest.serialization.Model):
    """Operation display payload.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Resource provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource of the operation.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class QueueScaleRule(msrest.serialization.Model):
    """Container App container Azure Queue based scaling rule.

    :ivar queue_name: Queue name.
    :vartype queue_name: str
    :ivar queue_length: Queue length.
    :vartype queue_length: int
    :ivar auth: Authentication secrets for the queue scale rule.
    :vartype auth: list[~container_apps_api_client.models.ScaleRuleAuth]
    """

    _attribute_map = {
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'queue_length': {'key': 'queueLength', 'type': 'int'},
        'auth': {'key': 'auth', 'type': '[ScaleRuleAuth]'},
    }

    def __init__(
        self,
        *,
        queue_name: Optional[str] = None,
        queue_length: Optional[int] = None,
        auth: Optional[List["ScaleRuleAuth"]] = None,
        **kwargs
    ):
        """
        :keyword queue_name: Queue name.
        :paramtype queue_name: str
        :keyword queue_length: Queue length.
        :paramtype queue_length: int
        :keyword auth: Authentication secrets for the queue scale rule.
        :paramtype auth: list[~container_apps_api_client.models.ScaleRuleAuth]
        """
        super(QueueScaleRule, self).__init__(**kwargs)
        self.queue_name = queue_name
        self.queue_length = queue_length
        self.auth = auth


class RegistryCredentials(msrest.serialization.Model):
    """Container App Private Registry.

    :ivar server: Container Registry Server.
    :vartype server: str
    :ivar username: Container Registry Username.
    :vartype username: str
    :ivar password_secret_ref: The name of the Secret that contains the registry login password.
    :vartype password_secret_ref: str
    """

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password_secret_ref': {'key': 'passwordSecretRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        username: Optional[str] = None,
        password_secret_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword server: Container Registry Server.
        :paramtype server: str
        :keyword username: Container Registry Username.
        :paramtype username: str
        :keyword password_secret_ref: The name of the Secret that contains the registry login password.
        :paramtype password_secret_ref: str
        """
        super(RegistryCredentials, self).__init__(**kwargs)
        self.server = server
        self.username = username
        self.password_secret_ref = password_secret_ref


class RegistryInfo(msrest.serialization.Model):
    """Container App registry information.

    :ivar registry_url: registry server Url.
    :vartype registry_url: str
    :ivar registry_user_name: registry username.
    :vartype registry_user_name: str
    :ivar registry_password: registry secret.
    :vartype registry_password: str
    """

    _attribute_map = {
        'registry_url': {'key': 'registryUrl', 'type': 'str'},
        'registry_user_name': {'key': 'registryUserName', 'type': 'str'},
        'registry_password': {'key': 'registryPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        registry_url: Optional[str] = None,
        registry_user_name: Optional[str] = None,
        registry_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword registry_url: registry server Url.
        :paramtype registry_url: str
        :keyword registry_user_name: registry username.
        :paramtype registry_user_name: str
        :keyword registry_password: registry secret.
        :paramtype registry_password: str
        """
        super(RegistryInfo, self).__init__(**kwargs)
        self.registry_url = registry_url
        self.registry_user_name = registry_user_name
        self.registry_password = registry_password


class Replica(ProxyResource):
    """Container App Revision Replica.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar created_time: Timestamp describing when the pod was created by controller.
    :vartype created_time: ~datetime.datetime
    :ivar containers: The containers collection under a replica.
    :vartype containers: list[~container_apps_api_client.models.ReplicaContainer]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'containers': {'key': 'properties.containers', 'type': '[ReplicaContainer]'},
    }

    def __init__(
        self,
        *,
        containers: Optional[List["ReplicaContainer"]] = None,
        **kwargs
    ):
        """
        :keyword containers: The containers collection under a replica.
        :paramtype containers: list[~container_apps_api_client.models.ReplicaContainer]
        """
        super(Replica, self).__init__(**kwargs)
        self.created_time = None
        self.containers = containers


class ReplicaCollection(msrest.serialization.Model):
    """Container App Revision Replicas collection ARM resource.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.Replica]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Replica]'},
    }

    def __init__(
        self,
        *,
        value: List["Replica"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.Replica]
        """
        super(ReplicaCollection, self).__init__(**kwargs)
        self.value = value


class ReplicaContainer(msrest.serialization.Model):
    """Container object under Container App Revision Replica.

    :ivar name: The Name of the Container.
    :vartype name: str
    :ivar container_id: The Id of the Container.
    :vartype container_id: str
    :ivar ready: The container ready status.
    :vartype ready: bool
    :ivar started: The container start status.
    :vartype started: bool
    :ivar restart_count: The container restart count.
    :vartype restart_count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'ready': {'key': 'ready', 'type': 'bool'},
        'started': {'key': 'started', 'type': 'bool'},
        'restart_count': {'key': 'restartCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        container_id: Optional[str] = None,
        ready: Optional[bool] = None,
        started: Optional[bool] = None,
        restart_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The Name of the Container.
        :paramtype name: str
        :keyword container_id: The Id of the Container.
        :paramtype container_id: str
        :keyword ready: The container ready status.
        :paramtype ready: bool
        :keyword started: The container start status.
        :paramtype started: bool
        :keyword restart_count: The container restart count.
        :paramtype restart_count: int
        """
        super(ReplicaContainer, self).__init__(**kwargs)
        self.name = name
        self.container_id = container_id
        self.ready = ready
        self.started = started
        self.restart_count = restart_count


class Revision(ProxyResource):
    """Container App Revision.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar created_time: Timestamp describing when the revision was created
     by controller.
    :vartype created_time: ~datetime.datetime
    :ivar fqdn: Fully qualified domain name of the revision.
    :vartype fqdn: str
    :ivar template: Container App Revision Template with all possible settings and the
     defaults if user did not provide them. The defaults are populated
     as they were at the creation time.
    :vartype template: ~container_apps_api_client.models.Template
    :ivar active: Boolean describing if the Revision is Active.
    :vartype active: bool
    :ivar replicas: Number of pods currently running for this revision.
    :vartype replicas: int
    :ivar traffic_weight: Traffic weight assigned to this revision.
    :vartype traffic_weight: int
    :ivar provisioning_error: Optional Field - Platform Error Message.
    :vartype provisioning_error: str
    :ivar health_state: Current health State of the revision. Possible values include: "Healthy",
     "Unhealthy", "None".
    :vartype health_state: str or ~container_apps_api_client.models.RevisionHealthState
    :ivar provisioning_state: Current provisioning State of the revision. Possible values include:
     "Provisioning", "Provisioned", "Failed", "Deprovisioning", "Deprovisioned".
    :vartype provisioning_state: str or ~container_apps_api_client.models.RevisionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'created_time': {'readonly': True},
        'fqdn': {'readonly': True},
        'template': {'readonly': True},
        'active': {'readonly': True},
        'replicas': {'readonly': True},
        'traffic_weight': {'readonly': True},
        'provisioning_error': {'readonly': True},
        'health_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'template': {'key': 'properties.template', 'type': 'Template'},
        'active': {'key': 'properties.active', 'type': 'bool'},
        'replicas': {'key': 'properties.replicas', 'type': 'int'},
        'traffic_weight': {'key': 'properties.trafficWeight', 'type': 'int'},
        'provisioning_error': {'key': 'properties.provisioningError', 'type': 'str'},
        'health_state': {'key': 'properties.healthState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Revision, self).__init__(**kwargs)
        self.created_time = None
        self.fqdn = None
        self.template = None
        self.active = None
        self.replicas = None
        self.traffic_weight = None
        self.provisioning_error = None
        self.health_state = None
        self.provisioning_state = None


class RevisionCollection(msrest.serialization.Model):
    """Container App Revisions collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.Revision]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Revision]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Revision"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.Revision]
        """
        super(RevisionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Scale(msrest.serialization.Model):
    """Container App scaling configurations.

    :ivar min_replicas: Optional. Minimum number of container replicas.
    :vartype min_replicas: int
    :ivar max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
    :vartype max_replicas: int
    :ivar rules: Scaling rules.
    :vartype rules: list[~container_apps_api_client.models.ScaleRule]
    """

    _attribute_map = {
        'min_replicas': {'key': 'minReplicas', 'type': 'int'},
        'max_replicas': {'key': 'maxReplicas', 'type': 'int'},
        'rules': {'key': 'rules', 'type': '[ScaleRule]'},
    }

    def __init__(
        self,
        *,
        min_replicas: Optional[int] = None,
        max_replicas: Optional[int] = None,
        rules: Optional[List["ScaleRule"]] = None,
        **kwargs
    ):
        """
        :keyword min_replicas: Optional. Minimum number of container replicas.
        :paramtype min_replicas: int
        :keyword max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not
         set.
        :paramtype max_replicas: int
        :keyword rules: Scaling rules.
        :paramtype rules: list[~container_apps_api_client.models.ScaleRule]
        """
        super(Scale, self).__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas
        self.rules = rules


class ScaleRule(msrest.serialization.Model):
    """Container App container scaling rule.

    :ivar name: Scale Rule Name.
    :vartype name: str
    :ivar azure_queue: Azure Queue based scaling.
    :vartype azure_queue: ~container_apps_api_client.models.QueueScaleRule
    :ivar custom: Custom scale rule.
    :vartype custom: ~container_apps_api_client.models.CustomScaleRule
    :ivar http: HTTP requests based scaling.
    :vartype http: ~container_apps_api_client.models.HttpScaleRule
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'azure_queue': {'key': 'azureQueue', 'type': 'QueueScaleRule'},
        'custom': {'key': 'custom', 'type': 'CustomScaleRule'},
        'http': {'key': 'http', 'type': 'HttpScaleRule'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        azure_queue: Optional["QueueScaleRule"] = None,
        custom: Optional["CustomScaleRule"] = None,
        http: Optional["HttpScaleRule"] = None,
        **kwargs
    ):
        """
        :keyword name: Scale Rule Name.
        :paramtype name: str
        :keyword azure_queue: Azure Queue based scaling.
        :paramtype azure_queue: ~container_apps_api_client.models.QueueScaleRule
        :keyword custom: Custom scale rule.
        :paramtype custom: ~container_apps_api_client.models.CustomScaleRule
        :keyword http: HTTP requests based scaling.
        :paramtype http: ~container_apps_api_client.models.HttpScaleRule
        """
        super(ScaleRule, self).__init__(**kwargs)
        self.name = name
        self.azure_queue = azure_queue
        self.custom = custom
        self.http = http


class ScaleRuleAuth(msrest.serialization.Model):
    """Auth Secrets for Container App Scale Rule.

    :ivar secret_ref: Name of the Container App secret from which to pull the auth params.
    :vartype secret_ref: str
    :ivar trigger_parameter: Trigger Parameter that uses the secret.
    :vartype trigger_parameter: str
    """

    _attribute_map = {
        'secret_ref': {'key': 'secretRef', 'type': 'str'},
        'trigger_parameter': {'key': 'triggerParameter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret_ref: Optional[str] = None,
        trigger_parameter: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword secret_ref: Name of the Container App secret from which to pull the auth params.
        :paramtype secret_ref: str
        :keyword trigger_parameter: Trigger Parameter that uses the secret.
        :paramtype trigger_parameter: str
        """
        super(ScaleRuleAuth, self).__init__(**kwargs)
        self.secret_ref = secret_ref
        self.trigger_parameter = trigger_parameter


class Secret(msrest.serialization.Model):
    """Secret definition.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Secret Name.
        :paramtype name: str
        :keyword value: Secret Value.
        :paramtype value: str
        """
        super(Secret, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SecretsCollection(msrest.serialization.Model):
    """Container App Secrets Collection ARM resource.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.ContainerAppSecret]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContainerAppSecret]'},
    }

    def __init__(
        self,
        *,
        value: List["ContainerAppSecret"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.ContainerAppSecret]
        """
        super(SecretsCollection, self).__init__(**kwargs)
        self.value = value


class SourceControl(ProxyResource):
    """Container App SourceControl.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~container_apps_api_client.models.SystemData
    :ivar operation_state: Current provisioning State of the operation. Possible values include:
     "InProgress", "Succeeded", "Failed", "Canceled".
    :vartype operation_state: str or ~container_apps_api_client.models.SourceControlOperationState
    :ivar repo_url: The repo url which will be integrated to ContainerApp.
    :vartype repo_url: str
    :ivar branch: The branch which will trigger the auto deployment.
    :vartype branch: str
    :ivar github_action_configuration: Container App Revision Template with all possible settings
     and the
     defaults if user did not provide them. The defaults are populated
     as they were at the creation time.
    :vartype github_action_configuration:
     ~container_apps_api_client.models.GithubActionConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'operation_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'operation_state': {'key': 'properties.operationState', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'github_action_configuration': {'key': 'properties.githubActionConfiguration', 'type': 'GithubActionConfiguration'},
    }

    def __init__(
        self,
        *,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        github_action_configuration: Optional["GithubActionConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword repo_url: The repo url which will be integrated to ContainerApp.
        :paramtype repo_url: str
        :keyword branch: The branch which will trigger the auto deployment.
        :paramtype branch: str
        :keyword github_action_configuration: Container App Revision Template with all possible
         settings and the
         defaults if user did not provide them. The defaults are populated
         as they were at the creation time.
        :paramtype github_action_configuration:
         ~container_apps_api_client.models.GithubActionConfiguration
        """
        super(SourceControl, self).__init__(**kwargs)
        self.operation_state = None
        self.repo_url = repo_url
        self.branch = branch
        self.github_action_configuration = github_action_configuration


class SourceControlCollection(msrest.serialization.Model):
    """SourceControl collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~container_apps_api_client.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControl]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SourceControl"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~container_apps_api_client.models.SourceControl]
        """
        super(SourceControlCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~container_apps_api_client.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~container_apps_api_client.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~container_apps_api_client.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~container_apps_api_client.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Template(msrest.serialization.Model):
    """Container App versioned application definition.
Defines the desired state of an immutable revision.
Any changes to this section Will result in a new revision being created.

    :ivar revision_suffix: User friendly suffix that is appended to the revision name.
    :vartype revision_suffix: str
    :ivar containers: List of container definitions for the Container App.
    :vartype containers: list[~container_apps_api_client.models.Container]
    :ivar scale: Scaling properties for the Container App.
    :vartype scale: ~container_apps_api_client.models.Scale
    :ivar volumes: List of volume definitions for the Container App.
    :vartype volumes: list[~container_apps_api_client.models.Volume]
    """

    _attribute_map = {
        'revision_suffix': {'key': 'revisionSuffix', 'type': 'str'},
        'containers': {'key': 'containers', 'type': '[Container]'},
        'scale': {'key': 'scale', 'type': 'Scale'},
        'volumes': {'key': 'volumes', 'type': '[Volume]'},
    }

    def __init__(
        self,
        *,
        revision_suffix: Optional[str] = None,
        containers: Optional[List["Container"]] = None,
        scale: Optional["Scale"] = None,
        volumes: Optional[List["Volume"]] = None,
        **kwargs
    ):
        """
        :keyword revision_suffix: User friendly suffix that is appended to the revision name.
        :paramtype revision_suffix: str
        :keyword containers: List of container definitions for the Container App.
        :paramtype containers: list[~container_apps_api_client.models.Container]
        :keyword scale: Scaling properties for the Container App.
        :paramtype scale: ~container_apps_api_client.models.Scale
        :keyword volumes: List of volume definitions for the Container App.
        :paramtype volumes: list[~container_apps_api_client.models.Volume]
        """
        super(Template, self).__init__(**kwargs)
        self.revision_suffix = revision_suffix
        self.containers = containers
        self.scale = scale
        self.volumes = volumes


class TrafficWeight(msrest.serialization.Model):
    """Traffic weight assigned to a revision.

    :ivar revision_name: Name of a revision.
    :vartype revision_name: str
    :ivar weight: Traffic weight assigned to a revision.
    :vartype weight: int
    :ivar latest_revision: Indicates that the traffic weight belongs to a latest stable revision.
    :vartype latest_revision: bool
    """

    _attribute_map = {
        'revision_name': {'key': 'revisionName', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
        'latest_revision': {'key': 'latestRevision', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        revision_name: Optional[str] = None,
        weight: Optional[int] = None,
        latest_revision: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword revision_name: Name of a revision.
        :paramtype revision_name: str
        :keyword weight: Traffic weight assigned to a revision.
        :paramtype weight: int
        :keyword latest_revision: Indicates that the traffic weight belongs to a latest stable
         revision.
        :paramtype latest_revision: bool
        """
        super(TrafficWeight, self).__init__(**kwargs)
        self.revision_name = revision_name
        self.weight = weight
        self.latest_revision = latest_revision


class Twitter(msrest.serialization.Model):
    """The configuration settings of the Twitter provider.

    :ivar enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Twitter
     provider.
    :vartype registration: ~container_apps_api_client.models.TwitterRegistration
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'TwitterRegistration'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["TwitterRegistration"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Twitter
         provider.
        :paramtype registration: ~container_apps_api_client.models.TwitterRegistration
        """
        super(Twitter, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class TwitterRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for the Twitter provider.

    :ivar consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype consumer_key: str
    :ivar consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer
     secret of the Twitter
     application used for sign-in.
    :vartype consumer_secret_setting_name: str
    """

    _attribute_map = {
        'consumer_key': {'key': 'consumerKey', 'type': 'str'},
        'consumer_secret_setting_name': {'key': 'consumerSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        consumer_key: Optional[str] = None,
        consumer_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype consumer_key: str
        :keyword consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a
         consumer secret of the Twitter
         application used for sign-in.
        :paramtype consumer_secret_setting_name: str
        """
        super(TwitterRegistration, self).__init__(**kwargs)
        self.consumer_key = consumer_key
        self.consumer_secret_setting_name = consumer_secret_setting_name


class UserAssignedIdentity(msrest.serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VnetConfiguration(msrest.serialization.Model):
    """Configuration properties for apps environment to join a Virtual Network.

    :ivar internal: Boolean indicating the environment only has an internal load balancer. These
     environments do not have a public static IP resource, must provide ControlPlaneSubnetResourceId
     and AppSubnetResourceId if enabling this property.
    :vartype internal: bool
    :ivar infrastructure_subnet_id: Resource ID of a subnet for infrastructure components. This
     subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with
     any other provided IP ranges.
    :vartype infrastructure_subnet_id: str
    :ivar runtime_subnet_id: Resource ID of a subnet that Container App containers are injected
     into. This subnet must be in the same VNET as the subnet defined in infrastructureSubnetId.
     Must not overlap with any other provided IP ranges.
    :vartype runtime_subnet_id: str
    :ivar docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge, network. Must
     not overlap with any other provided IP ranges.
    :vartype docker_bridge_cidr: str
    :ivar platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment
     infrastructure IP addresses. Must not overlap with any other provided IP ranges.
    :vartype platform_reserved_cidr: str
    :ivar platform_reserved_dns_ip: An IP address from the IP range defined by platformReservedCidr
     that will be reserved for the internal DNS server.
    :vartype platform_reserved_dns_ip: str
    """

    _attribute_map = {
        'internal': {'key': 'internal', 'type': 'bool'},
        'infrastructure_subnet_id': {'key': 'infrastructureSubnetId', 'type': 'str'},
        'runtime_subnet_id': {'key': 'runtimeSubnetId', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
        'platform_reserved_cidr': {'key': 'platformReservedCidr', 'type': 'str'},
        'platform_reserved_dns_ip': {'key': 'platformReservedDnsIP', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        internal: Optional[bool] = None,
        infrastructure_subnet_id: Optional[str] = None,
        runtime_subnet_id: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        platform_reserved_cidr: Optional[str] = None,
        platform_reserved_dns_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword internal: Boolean indicating the environment only has an internal load balancer. These
         environments do not have a public static IP resource, must provide ControlPlaneSubnetResourceId
         and AppSubnetResourceId if enabling this property.
        :paramtype internal: bool
        :keyword infrastructure_subnet_id: Resource ID of a subnet for infrastructure components. This
         subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with
         any other provided IP ranges.
        :paramtype infrastructure_subnet_id: str
        :keyword runtime_subnet_id: Resource ID of a subnet that Container App containers are injected
         into. This subnet must be in the same VNET as the subnet defined in infrastructureSubnetId.
         Must not overlap with any other provided IP ranges.
        :paramtype runtime_subnet_id: str
        :keyword docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge, network.
         Must not overlap with any other provided IP ranges.
        :paramtype docker_bridge_cidr: str
        :keyword platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment
         infrastructure IP addresses. Must not overlap with any other provided IP ranges.
        :paramtype platform_reserved_cidr: str
        :keyword platform_reserved_dns_ip: An IP address from the IP range defined by
         platformReservedCidr that will be reserved for the internal DNS server.
        :paramtype platform_reserved_dns_ip: str
        """
        super(VnetConfiguration, self).__init__(**kwargs)
        self.internal = internal
        self.infrastructure_subnet_id = infrastructure_subnet_id
        self.runtime_subnet_id = runtime_subnet_id
        self.docker_bridge_cidr = docker_bridge_cidr
        self.platform_reserved_cidr = platform_reserved_cidr
        self.platform_reserved_dns_ip = platform_reserved_dns_ip


class Volume(msrest.serialization.Model):
    """Volume definitions for the Container App.

    :ivar name: Volume name.
    :vartype name: str
    :ivar storage_type: Storage type for the volume. If not provided, use EmptyDir. Possible values
     include: "AzureFile", "EmptyDir".
    :vartype storage_type: str or ~container_apps_api_client.models.StorageType
    :ivar storage_name: Name of storage resource. No need to provide for EmptyDir.
    :vartype storage_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
        'storage_name': {'key': 'storageName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_type: Optional[Union[str, "StorageType"]] = None,
        storage_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Volume name.
        :paramtype name: str
        :keyword storage_type: Storage type for the volume. If not provided, use EmptyDir. Possible
         values include: "AzureFile", "EmptyDir".
        :paramtype storage_type: str or ~container_apps_api_client.models.StorageType
        :keyword storage_name: Name of storage resource. No need to provide for EmptyDir.
        :paramtype storage_name: str
        """
        super(Volume, self).__init__(**kwargs)
        self.name = name
        self.storage_type = storage_type
        self.storage_name = storage_name


class VolumeMount(msrest.serialization.Model):
    """Volume mount for the Container App.

    :ivar volume_name: This must match the Name of a Volume.
    :vartype volume_name: str
    :ivar mount_path: Path within the container at which the volume should be mounted.Must not
     contain ':'.
    :vartype mount_path: str
    """

    _attribute_map = {
        'volume_name': {'key': 'volumeName', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        volume_name: Optional[str] = None,
        mount_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword volume_name: This must match the Name of a Volume.
        :paramtype volume_name: str
        :keyword mount_path: Path within the container at which the volume should be mounted.Must not
         contain ':'.
        :paramtype mount_path: str
        """
        super(VolumeMount, self).__init__(**kwargs)
        self.volume_name = volume_name
        self.mount_path = mount_path
