####> This option file is used in:
####>   podman create, run
####> If file is edited, make sure the changes
####> are applicable to all of those.
#### **--uidmap**=*[flags]container_uid:from_uid[:amount]*

Run the container in a new user namespace using the supplied UID mapping. This
option conflicts with the **--userns** and **--subuidname** options. This
option provides a way to map host UIDs to container UIDs. It can be passed
several times to map different ranges.

The possible values of the optional *flags* are discussed further down on this page.
The *amount* value is optional and assumed to be **1** if not given.

The *from_uid* value is based upon the user running the command, either rootful or rootless users.

* rootful user:  [*flags*]*container_uid*:*host_uid*[:*amount*]
* rootless user: [*flags*]*container_uid*:*intermediate_uid*[:*amount*]

  `Rootful mappings`


When **podman <<subcommand>>** is called by a privileged user, the option **--uidmap**
works as a direct mapping between host UIDs and container UIDs.

host UID -> container UID

The _amount_ specifies the number of consecutive UIDs that is mapped.
If for example _amount_ is **4** the mapping looks like:

|   host UID     |    container UID    |
| ----------     | ----------------    |
| *from_uid*     | *container_uid*     |
| *from_uid* + 1 | *container_uid* + 1 |
| *from_uid* + 2 | *container_uid* + 2 |
| *from_uid* + 3 | *container_uid* + 3 |

  `Rootless mappings`

When **podman <<subcommand>>** is called by an unprivileged user (i.e. running rootless),
the value *from_uid* is interpreted as an "intermediate UID". In the rootless
case, host UIDs are not mapped directly to container UIDs. Instead the mapping
happens over two mapping steps:

host UID -> intermediate UID -> container UID

The **--uidmap** option only influences the second mapping step.

The first mapping step is derived by Podman from the contents of the file
_/etc/subuid_ and the UID of the user calling Podman.

First mapping step:

| host UID            | intermediate UID |
| --------            | ---------------- |
| UID for Podman user |                0 |
| 1st subordinate UID |                1 |
| 2nd subordinate UID |                2 |
| 3rd subordinate UID |                3 |
| nth subordinate UID |                n |

To be able to use intermediate UIDs greater than zero, the user needs to have
subordinate UIDs configured in _/etc/subuid_. See **subuid**(5).

The second mapping step is configured with **--uidmap**.

If for example _amount_ is **5** the second mapping step looks like:

|   intermediate UID   |    container UID    |
| ------------------   | ----------------    |
| *from_uid*           | *container_uid*     |
| *from_uid* + 1       | *container_uid* + 1 |
| *from_uid* + 2       | *container_uid* + 2 |
| *from_uid* + 3       | *container_uid* + 3 |
| *from_uid* + 4       | *container_uid* + 4 |

When running as rootless, Podman uses all the ranges configured in the _/etc/subuid_ file.

The current user ID is mapped to UID=0 in the rootless user namespace.
Every additional range is added sequentially afterward:

|   host                | rootless user namespace | length              |
| ------                | ----------------------- | ------              |
| $UID                  | 0                       | 1                   |
| 1                     | $FIRST_RANGE_ID         | $FIRST_RANGE_LENGTH |
| 1+$FIRST_RANGE_LENGTH | $SECOND_RANGE_ID        | $SECOND_RANGE_LENGTH|

  `Referencing a host ID from the parent namespace`

As a rootless user, the given host ID in **--uidmap** or **--gidmap**
is mapped from the *intermediate namespace* generated by Podman. Sometimes
it is desirable to refer directly at the *host namespace*. It is possible
to manually do so, by running `podman unshare cat /proc/self/gid_map`,
finding the desired host id at the second column of the output, and getting
the corresponding intermediate id from the first column.

Podman can perform all that by preceding the host id in the mapping
with the `@` symbol. For instance, by specifying `--gidmap 100000:@2000:1`,
podman will look up the intermediate id corresponding to host id `2000` and
it will map the found intermediate id to the container id `100000`. The
given host id must have been subordinated (otherwise it would not be mapped
into the intermediate space in the first place).

If the length is greater than one, for instance with `--gidmap 100000:@2000:2`,
Podman will map host ids `2000` and `2001` to `100000` and `100001`, respectively,
regardless of how the intermediate mapping is defined.

  `Extending previous mappings`

Some mapping modifications may be cumbersome. For instance, a user
starts with a mapping such as `--gidmap="0:0:65000"`, that needs to be
changed such as the parent id `1` is mapped to container id `100000`
instead, leaving container id `1` unassigned. The corresponding `--gidmap`
becomes `--gidmap="0:0:1" --gidmap="2:2:65534" --gidmap="100000:1:1"`.

This notation can be simplified using the `+` flag, that takes care of
breaking previous mappings removing any conflicting assignment with
the given mapping. The flag is given before the container id
as follows: `--gidmap="0:0:65000" --gidmap="+100000:1:1"`


 Flag      | Example       | Description
-----------|---------------|-------------
 `+`       | `+100000:1:1` | Extend the previous mapping

This notation leads to gaps in the assignment, so it may be convenient to
fill those gaps afterwards: `--gidmap="0:0:65000" --gidmap="+100000:1:1" --gidmap="1:65001:1"`

One specific use case for this flag is in the context of rootless
users. A rootless user may specify mappings with the `+` flag as
in `--gidmap="+100000:1:1"`. Podman will then "fill the gaps" starting
from zero with all the remaining intermediate ids. This is convenient when
a user wants to map a specific intermediate id to a container id, leaving
the rest of subordinate ids to be mapped by Podman at will.

  `Passing only one of --uidmap or --gidmap`

Usually, subordinated user and group ids are assigned simultaneously, and
for any user the subordinated user ids match the subordinated group ids.
For convenience, if only one of **--uidmap** or **--gidmap** is given,
podman assumes the mapping refers to both UIDs and GIDs and applies the
given mapping to both. If only one value of the two needs to be changed,
the mappings should include the `u` or the `g` flags to specify that
they only apply to UIDs or GIDs and should not be copied over.

 flag    | Example         | Description
---------|-----------------|-----------------
  `u`    | `u20000:2000:1` |The mapping only applies to UIDs
  `g`    | `g10000:1000:1` |The mapping only applies to GIDs

For instance given the command

    podman <<subcommand>> --gidmap "0:0:1000" --gidmap "g2000:2000:1"

Since no **--uidmap** is given, the **--gidmap** is copied to **--uidmap**,
giving a command equivalent to

    podman <<subcommand>> --gidmap "0:0:1000" --gidmap "2000:2000:1" --uidmap "0:0:1000"

The `--gidmap "g2000:2000:1"` used the `g` flag and therefore it was
not copied to **--uidmap**.

  `Rootless mapping of additional host GIDs`

A rootless user may desire to map a specific host group that has already been
subordinated within _/etc/subgid_ without specifying the rest of the mapping.

This can be done with **--gidmap "+g*container_gid*:@*host_gid*"**

Where:

- The host GID is given through the `@` symbol
- The mapping of this GID is not copied over to **--usermap** thanks to the `g` flag.
- The rest of the container IDs will be mapped starting from 0 to n,
  with all the remaining subordinated GIDs, thanks to the `+` flag.

For instance, if a user belongs to the group `2000` and that group is
subordinated to that user (with `usermod --add-subgids 2000-2000 $USER`),
the user can map the group into the container with: **--gidmap=+g100000:@2000**.

If this mapping is combined with the option, **--group-add=keep-groups**, the
process in the container will belong to group `100000`, and files belonging
to group `2000` in the host will appear as being owned by group `100000`
inside the container.

    podman run --group-add=keep-groups --gidmap="+g100000:@2000" ...

  `No subordinate UIDs`

Even if a user does not have any subordinate UIDs in  _/etc/subuid_,
**--uidmap** can be used to map the normal UID of the user to a
container UID by running `podman <<subcommand>> --uidmap $container_uid:0:1 --user $container_uid ...`.

  `Pods`

The **--uidmap** option cannot be called in conjunction with the **--pod** option as a uidmap cannot be set on the container level when in a pod.
