# Тіло - Поля

Так само як ви можете визначати додаткову валідацію та метадані у параметрах *функції обробки шляху* за допомогою `Query`, `Path` та `Body`, ви можете визначати валідацію та метадані всередині моделей Pydantic за допомогою `Field` від Pydantic.

## Імпорт `Field`

Спочатку вам потрібно імпортувати це:

{* ../../docs_src/body_fields/tutorial001_an_py310.py hl[4] *}

/// warning

Зверніть увагу, що `Field` імпортується прямо з `pydantic`, а не з `fastapi`, як всі інші (`Query`, `Path`, `Body` тощо).

///

## Оголошення атрибутів моделі

Ви можете використовувати `Field` з атрибутами моделі:

{* ../../docs_src/body_fields/tutorial001_an_py310.py hl[11:14] *}

`Field` працює так само, як `Query`, `Path` і `Body`, у нього такі самі параметри тощо.

/// note | Технічні деталі

Насправді, `Query`, `Path` та інші, що ви побачите далі, створюють об'єкти підкласів загального класу `Param`, котрий сам є підкласом класу `FieldInfo` з Pydantic.

І `Field` від Pydantic також повертає екземпляр `FieldInfo`.

`Body` також безпосередньо повертає об'єкти підкласу `FieldInfo`. І є інші підкласи, які ви побачите пізніше, що є підкласами класу Body.

Пам'ятайте, що коли ви імпортуєте 'Query', 'Path' та інше з 'fastapi', вони фактично є функціями, які повертають спеціальні класи.

///

/// tip

Зверніть увагу, що кожен атрибут моделі із типом, значенням за замовчуванням та `Field` має ту саму структуру, що й параметр *функції обробки шляху*, з `Field` замість `Path`, `Query` і `Body`.

///

## Додавання додаткової інформації

Ви можете визначити додаткову інформацію у `Field`, `Query`, `Body` тощо. І вона буде включена у згенеровану JSON схему.

Ви дізнаєтеся більше про додавання додаткової інформації пізніше у документації, коли вивчатимете визначення прикладів.

/// warning

Додаткові ключі, передані в `Field`, також будуть присутні у згенерованій схемі OpenAPI для вашого додатка.
Оскільки ці ключі не обов'язково можуть бути частиною специфікації OpenAPI, деякі інструменти OpenAPI, наприклад, [OpenAPI валідатор](https://validator.swagger.io/), можуть не працювати з вашою згенерованою схемою.

///

## Підсумок

Ви можете використовувати `Field` з Pydantic для визначення додаткових перевірок та метаданих для атрибутів моделі.

Ви також можете використовувати додаткові іменовані аргументи для передачі додаткових метаданих JSON схеми.
