# SPDX-License-Identifier: Apache-2.0
# Copyright 2014-2016 The Meson development team

from __future__ import annotations

from .vs2010backend import Vs2010Backend
from ..mesonlib import MesonException
import typing as T

if T.TYPE_CHECKING:
    from ..build import Build
    from ..interpreter import Interpreter

class Vs2013Backend(Vs2010Backend):

    name = 'vs2013'

    def __init__(self, build: T.Optional[Build], interpreter: T.Optional[Interpreter]):
        super().__init__(build, interpreter)
        self.vs_version = '2013'
        self.sln_file_version = '12.00'
        self.sln_version_comment = '2013'

    def detect_toolset(self) -> None:
        if self.environment is not None:
            # TODO: we assume host == build
            comps = self.environment.coredata.compilers.host
            if comps and all(c.id == 'intel-cl' for c in comps.values()):
                c = list(comps.values())[0]
                if c.version.startswith('19'):
                    self.platform_toolset = 'Intel C++ Compiler 19.0'
                else:
                    # We don't have support for versions older than 2019 right now.
                    raise MesonException('There is currently no support for ICL before 19, patches welcome.')
            if self.platform_toolset is None:
                self.platform_toolset = 'v120'
