/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterRegistry;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettingsEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

class DefaultEntityPainterSettings
extends EntityPainterSettings {
    private final PropertyChangeSupport _support = new PropertyChangeSupport(this);

    DefaultEntityPainterSettings() {
    }

    @Override
    public EntityPainter getEntityPainter(GraphID graphID) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = EntityPainterSettings.class.getName();
        String name = (String)gud.get((Object)key);
        EntityPainterRegistry registry = EntityPainterRegistry.getDefault();
        return name == null ? registry.getDefaultPainter() : registry.getEntityPainter(name);
    }

    @Override
    public void setEntityPainter(GraphID graphID, String painterName) {
        String oldPainterName = this.getEntityPainter(graphID).getName();
        if (!oldPainterName.equals(painterName)) {
            GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
            String key = EntityPainterSettings.class.getName();
            gud.put((Object)key, (Object)painterName);
            EntityPainterSettingsEvent event = new EntityPainterSettingsEvent(graphID, oldPainterName, painterName);
            this.fireChange(event);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._support.removePropertyChangeListener(listener);
    }

    private void fireChange(EntityPainterSettingsEvent event) {
        this._support.firePropertyChange("painterChanged", null, event);
    }
}

