/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.nodes.ChangeTypeUtil;
import com.paterva.maltego.util.ui.WindowUtil;
import java.util.Set;
import org.openide.util.Exceptions;

public class ChangeTypeAction
extends TopGraphEntitySelectionAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed() {
        try {
            WindowUtil.showWaitCursor();
            GraphID graphID = this.getTopGraphID();
            Set<EntityID> entityIDs = this.getSelectedModelEntities();
            MaltegoEntitySpec spec = ChangeTypeUtil.showChangeTypePanel(graphID, this.getSpec(graphID, entityIDs.iterator().next()));
            if (spec != null) {
                ChangeTypeUtil.changeTypes(graphID, entityIDs, spec);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    private MaltegoEntitySpec getSpec(GraphID graphID, EntityID firstEntity) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        String type = dataReader.getEntityType(firstEntity);
        return (MaltegoEntitySpec)EntityRegistry.forGraphID((GraphID)graphID).get(type);
    }

    public String getName() {
        return "Change Type";
    }
}

