/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.ParticipantEvent;
import com.paterva.maltego.collab.RoomStatusCode;
import com.paterva.maltego.collab.graph.state.ConnectionController;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.graph.state.StateSendInitialGraph;
import com.paterva.maltego.collab.graph.state.StateWaitHistory;
import com.paterva.maltego.collab.graph.state.StateWaitSessionID;
import com.paterva.maltego.collab.session.SessionID;

public class StateWaitSelfPresence
extends StateConnecting.Timeout {
    private SessionID _sessionId = null;

    public StateWaitSelfPresence(SessionID sessionId) {
        this._sessionId = sessionId;
    }

    @Override
    protected void onRun() {
        this.progress(LogMessageLevel.Info, "Waiting for room", 15);
        this.debug("waiting for self presence");
    }

    @Override
    protected long getTimeout() {
        return this.sessionInfo().getMessageTimeout();
    }

    @Override
    protected void onTimeout() {
        String msg = "Timeout waiting for presence";
        this.handleError("", (Exception)((Object)new CollaborationException(msg, false)));
    }

    @Override
    void sessionIDChanged(SessionID id) {
        this._sessionId = id;
    }

    @Override
    public void participantEventReceived(ParticipantEvent event) throws CollaborationException {
        super.participantEventReceived(event);
        ConnectionController stateMachine = (ConnectionController)this.getStateMachine();
        if (!stateMachine.isVersionValid()) {
            String msg = "Your version of Maltego is too old to connect to the shared graph.";
            this.handleError("", (Exception)((Object)new CollaborationException(msg, false)));
        } else if (!stateMachine.isKeyValid()) {
            String msg = "Your security key does not match the one used for the existing session or you are not using the same amount of bits for encryption.";
            this.handleError("", (Exception)((Object)new CollaborationException(msg, false)));
        } else {
            StateConnecting nextNextState;
            boolean roomCreated;
            boolean bl = roomCreated = event.getRoomStatusCode() == RoomStatusCode.RoomCreated;
            if (event.getRoomStatusCode() != RoomStatusCode.None) {
                this.progress(LogMessageLevel.Info, roomCreated ? "Room needs configuring" : "Room already configured");
                if (roomCreated) {
                    stateMachine.configureSession(this.getCallback());
                }
                stateMachine.sendSessionID(this.getCallback());
                this.progress(LogMessageLevel.Info, "Room is empty, no sync required");
                nextNextState = new StateSendInitialGraph();
            } else {
                nextNextState = new StateWaitHistory();
            }
            this.setNextState(new StateWaitSessionID(nextNextState, roomCreated, this._sessionId));
        }
    }
}

