/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.feeders;

import com.paterva.maltego.automation.feeders.AutomationRequestHandler;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.imex.MaltegoGraphIO;
import com.paterva.maltego.ui.graph.merge.PositioningGraphMerger;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.WindowUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class PasteRequestHandler
extends AutomationRequestHandler {
    @Override
    public void handleRequest(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    WindowUtil.showWaitCursor();
                    GraphID viewGraphID = PasteRequestHandler.this.getViewGraphID();
                    if (viewGraphID != null) {
                        GraphID pasteGraphID = PasteRequestHandler.this.getPasteGraphID(viewGraphID, message);
                        PasteRequestHandler.this.pasteGraph(viewGraphID, pasteGraphID);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    WindowUtil.hideWaitCursor();
                }
            }
        });
    }

    private GraphID getViewGraphID() {
        GraphCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class)) != null) {
            return cookie.getGraphID();
        }
        return null;
    }

    private void pasteGraph(GraphID targetGraphID, GraphID graphToPasteID) {
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphToPasteID);
        String entityDescription = GraphTransactionHelper.getDescriptionForEntitiesItr((GraphID)targetGraphID, (Iterable)entities, (boolean)true);
        String description = "%s " + entityDescription;
        PositioningGraphMerger merger = new PositioningGraphMerger(targetGraphID, graphToPasteID, new SimilarStrings(description, "Add (from port)", "Delete/unmerge"));
        merger.mergeGraphs();
        merger.selectSourceNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphID getPasteGraphID(GraphID contextGraphID, String message) throws IOException {
        GraphID graphID = null;
        try (InputStream is = null;){
            is = new ByteArrayInputStream(message.getBytes("UTF-8"));
            EntityFactory factory = contextGraphID != null ? EntityFactory.forGraphID((GraphID)contextGraphID) : EntityFactory.getDefault();
            graphID = GraphID.create();
            MaltegoGraphIO.read((GraphID)graphID, (InputStream)is, (EntityFactory)factory, (EntityRegistry)EntityRegistry.getDefault(), (LinkRegistry)LinkRegistry.getDefault(), (IconRegistry)IconRegistry.getDefault());
        }
        return graphID;
    }
}

