/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class VariableStore {
    private static Map<String, PropertyDescriptor> _descriptors;

    private VariableStore() {
    }

    public static synchronized Object getValue(AutomationContext ctx, MaltegoEntity entity, String name, boolean persistent) {
        return VariableStore.getValue(ctx, entity, name, null, persistent);
    }

    public static synchronized Object getValue(AutomationContext ctx, MaltegoEntity entity, String name, Object defaultValue, boolean persistent) {
        if (persistent) {
            PropertyDescriptor descriptor = VariableStore.getDescriptors().get(name);
            if (descriptor == null) {
                return null;
            }
            return VariableStore.getPersistentProperty(entity, descriptor, defaultValue);
        }
        return VariableStore.getTransientProperty(ctx, entity, name, defaultValue);
    }

    public static synchronized void setValue(AutomationContext ctx, Collection<MaltegoEntity> entities, String name, Object value, boolean persistent, boolean overwrite) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        if (persistent) {
            PropertyDescriptor descriptor = VariableStore.getDescriptor(name, value);
            VariableStore.setPersistentProperty(ctx, entities, descriptor, value, overwrite);
        } else {
            for (MaltegoEntity entity : entities) {
                VariableStore.setTransientProperty(ctx, entity, name, value, overwrite);
            }
        }
    }

    private static void setPersistentProperty(AutomationContext ctx, Collection<MaltegoEntity> entities, PropertyDescriptor descriptor, Object value, boolean overwrite) {
        GraphID graphID = ctx.getTargetGraphID();
        String user = GraphUser.getUser((GraphID)graphID);
        HashSet<EntityUpdate> addPropertyEntities = new HashSet<EntityUpdate>();
        HashSet<EntityUpdate> updatePropertyEntities = new HashSet<EntityUpdate>();
        for (MaltegoEntity entity : entities) {
            EntityUpdate entityUpdate = new EntityUpdate(entity);
            entityUpdate.addProperty(descriptor);
            entityUpdate.setValue(descriptor, value);
            if (!entity.getProperties().contains(descriptor)) {
                addPropertyEntities.add(entityUpdate);
                EntityUpdate update = ModifiedHelper.createUpdate((String)user, (MaltegoEntity)entity);
                if (update == null) continue;
                updatePropertyEntities.add(update);
                continue;
            }
            Object existingValue = entity.getValue(descriptor);
            if (!overwrite && existingValue != null) continue;
            ModifiedHelper.addToUpdate((String)user, (MaltegoEntity)entity, (EntityUpdate)entityUpdate);
            updatePropertyEntities.add(entityUpdate);
        }
        if (!addPropertyEntities.isEmpty() || !updatePropertyEntities.isEmpty()) {
            String entityDescription = GraphTransactionHelper.getDescriptionForEntities((GraphID)graphID, entities, (boolean)true);
            String description = String.format("Change property \"%s\" of %s", descriptor.getDisplayName(), entityDescription);
            GraphTransactionBatch batch = new GraphTransactionBatch(new SimilarStrings(description), false, new GraphTransaction[0]);
            if (!addPropertyEntities.isEmpty()) {
                batch.add(GraphTransactions.addProperties(addPropertyEntities, (Collection)Collections.EMPTY_SET));
            }
            if (!updatePropertyEntities.isEmpty()) {
                batch.add(GraphTransactions.updateEntitiesAndLinks(updatePropertyEntities, (Collection)Collections.EMPTY_SET));
            }
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
    }

    private static Object getPersistentProperty(MaltegoEntity entity, PropertyDescriptor descriptor, Object defaultValue) {
        Object value = entity.getValue(descriptor);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static void setTransientProperty(AutomationContext ctx, MaltegoEntity entity, String name, Object value, boolean overwrite) {
        ctx.setProperty((EntityID)entity.getID(), name, value, overwrite);
    }

    private static Object getTransientProperty(AutomationContext ctx, MaltegoEntity entity, String name, Object defaultValue) {
        Object value = ctx.getProperty((EntityID)entity.getID(), name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static synchronized Map<String, PropertyDescriptor> getDescriptors() {
        if (_descriptors == null) {
            _descriptors = new HashMap<String, PropertyDescriptor>();
        }
        return _descriptors;
    }

    private static PropertyDescriptor getDescriptor(String name, Object value) {
        PropertyDescriptor descriptor = VariableStore.getDescriptors().get(name);
        if (descriptor == null) {
            descriptor = VariableStore.createDescriptor(name, value);
            VariableStore.getDescriptors().put(name, descriptor);
        }
        return descriptor;
    }

    private static PropertyDescriptor createDescriptor(String name, Object value) {
        PropertyDescriptor d = new PropertyDescriptor(value.getClass(), name);
        d.setHidden(true);
        return d;
    }
}

