/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.StringUtilities;

class LogAction
extends AbstractAction {
    public LogAction() {
        super("log");
    }

    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        String msg;
        String info = this.getInfo();
        String status = this.getStatus();
        StringBuilder sb = new StringBuilder();
        if (info != null && info.length() > 0) {
            sb.append(info);
            sb.append("\n");
        }
        if (status != null && status.length() > 0) {
            ctx.progress(status);
        }
        if (this.showPayload()) {
            String title = "---------- entities ----------";
            sb.append(title);
            sb.append("\n");
            for (MaltegoEntity entity : payload.getEntities()) {
                sb.append(this.toString(ctx, entity));
                sb.append("\n");
            }
            sb.append(LogAction.repeat('-', title.length()));
        }
        if (!StringUtilities.isNullOrEmpty((String)(msg = sb.toString()))) {
            ctx.getLogger().note(msg, new Object[0]);
        }
        cb.completed(payload);
    }

    private String getInfo() {
        return (String)this.getValue();
    }

    private String getStatus() {
        return (String)this.getProperty("status");
    }

    public static String repeat(char c, int count) {
        String s = "";
        for (int i = 0; i < count; ++i) {
            s = s + c;
        }
        return s;
    }

    private boolean showPayload() {
        return (Boolean)this.getProperty("showEntities", false);
    }

    private String toString(AutomationContext ctx, MaltegoEntity entity) {
        Object value = InheritanceHelper.getValue((SpecRegistry)ctx.getEntityRegistry(), (TypedPropertyBag)entity);
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

