/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.NumericFilter;
import com.paterva.maltego.automation.actions.NumericFilterSupport;
import com.paterva.maltego.automation.actions.VariableStore;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.typing.types.DateTime;

class AgeFilter
extends NumericFilter {
    private static final String DOB_VARIABLE = "maltego.automation.dob";

    public AgeFilter() {
        super("age");
    }

    @Override
    protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
        long now = System.currentTimeMillis();
        return new EntityFilterImpl(ctx, now, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert);
    }

    private class EntityFilterImpl
    extends NumericFilterSupport.NumericEntityFilter {
        private long _now;

        public EntityFilterImpl(AutomationContext ctx, long now, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            super(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert);
            this._now = now;
        }

        @Override
        public boolean pass(MaltegoEntity entity) {
            long delta;
            int age;
            DateTime dob = (DateTime)VariableStore.getValue(this.getContext(), entity, AgeFilter.DOB_VARIABLE, true);
            boolean keep = false;
            if (dob != null && NumericFilterSupport.check(age = (int)((double)(delta = this._now - dob.getTime()) / 1000.0), this.getEqualTo(), this.getMoreThan(), this.getLessThan(), this.getMoreThanOrEqual(), this.getLessThanOrEqual())) {
                keep = true;
            }
            return keep;
        }
    }
}

