/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.PropertyConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;

public class EntityConstraint
implements Constraint {
    private String _typeName;
    private int _minimum = 0;
    private int _maximum = 0;
    private Collection<PropertyConstraint> _properties;

    public EntityConstraint() {
    }

    public EntityConstraint(String typeName) {
        this(typeName, 1, 1);
    }

    public EntityConstraint(String typeName, int min, int max) {
        this(typeName, min, max, null);
    }

    public EntityConstraint(String typeName, int min, int max, Collection<PropertyConstraint> properties) {
        this._typeName = typeName;
        this._minimum = min;
        this._maximum = max;
        this._properties = properties;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    public int getMinimum() {
        return this._minimum;
    }

    public void setMinimum(int minimum) {
        this._minimum = minimum;
    }

    public int getMaximum() {
        return this._maximum;
    }

    public void setMaximum(int maximum) {
        this._maximum = maximum;
    }

    public Collection<PropertyConstraint> getProperties() {
        if (this._properties == null) {
            this._properties = new LinkedList<PropertyConstraint>();
        }
        return this._properties;
    }

    public void setProperties(Collection<PropertyConstraint> properties) {
        this._properties = properties;
    }

    @Override
    public boolean isSatisfiedByAny(Iterable<? extends TypedPropertyBag> entities, InheritedTypesProvider typeProvider) {
        int needMatches = this._minimum < 1 ? 1 : this._minimum;
        int gotMatches = 0;
        for (TypedPropertyBag typedPropertyBag : entities) {
            if (gotMatches >= needMatches) {
                return true;
            }
            if (!this.isSatisfiedByType(typedPropertyBag.getTypeName(), typeProvider) || !this.isSatisfiedByProperties(typedPropertyBag)) continue;
            ++gotMatches;
        }
        return gotMatches >= needMatches;
    }

    @Override
    public boolean isSatisfiedByAny(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        int needMatches = this._minimum < 1 ? 1 : this._minimum;
        int gotMatches = 0;
        try {
            Set<String> types = typeProvider.getAllInheritedTypes();
            if ((types == null || this.isSatisfiedByInheritedTypes(types)) && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                for (EntityID entityID : entities) {
                    if (this.isSatisfiedByAny(entityID, dataReader, typeProvider)) {
                        ++gotMatches;
                    }
                    if (gotMatches < needMatches) continue;
                    return true;
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return gotMatches >= needMatches;
    }

    private boolean isSatisfiedByAny(EntityID entityID, GraphDataStoreReader dataReader, InheritedTypesProvider typeProvider) throws GraphStoreException {
        String type = dataReader.getEntityType(entityID);
        boolean match = false;
        if (this.isSatisfiedByType(type, typeProvider)) {
            if (this._properties == null) {
                match = true;
            } else {
                MaltegoEntity entity = dataReader.getEntity(entityID);
                match = this.isSatisfiedByProperties((TypedPropertyBag)entity);
            }
        }
        return match;
    }

    private boolean isSatisfiedByAny(MaltegoEntity entity, InheritedTypesProvider typeProvider) throws GraphStoreException {
        String type = entity.getTypeName();
        boolean match = false;
        if (this.isSatisfiedByType(type, typeProvider)) {
            match = this._properties == null ? true : this.isSatisfiedByProperties((TypedPropertyBag)entity);
        }
        return match;
    }

    @Override
    public Set<EntityID> getSatisfiedBy(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        HashSet<EntityID> satisfied = new HashSet<EntityID>();
        try {
            if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                for (EntityID entityID : entities) {
                    if (!this.isSatisfiedByAny(entityID, dataReader, typeProvider)) continue;
                    satisfied.add(entityID);
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return satisfied;
    }

    @Override
    public Map<EntityID, MaltegoEntity> getSatisfiedBy(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider) {
        HashMap<EntityID, MaltegoEntity> satisfied = new HashMap<EntityID, MaltegoEntity>();
        try {
            for (Map.Entry<EntityID, MaltegoEntity> entry : entities.entrySet()) {
                EntityID entityID = entry.getKey();
                MaltegoEntity entity = entry.getValue();
                if (!this.isSatisfiedByAny(entity, typeProvider)) continue;
                satisfied.put(entityID, entity);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return satisfied;
    }

    private boolean isSatisfiedByType(String typeName, InheritedTypesProvider typeProvider) {
        if (this._typeName == null) {
            return true;
        }
        if (typeProvider != null) {
            List<String> types = typeProvider.getAllInheritedTypes(typeName);
            return types.contains(this._typeName);
        }
        return this._typeName.equals(typeName);
    }

    @Override
    public boolean isSatisfiedByInheritedTypes(Collection<String> types) {
        if (this._typeName == null) {
            return true;
        }
        return types.contains(this._typeName);
    }

    private boolean isSatisfiedByProperties(TypedPropertyBag entity) {
        if (this._properties == null) {
            return true;
        }
        for (PropertyConstraint c : this._properties) {
            boolean satisfied = c.isSatisfiedBy(entity);
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplay() {
        StringBuilder buffer = new StringBuilder();
        if (this._typeName != null) {
            buffer.append(this._typeName);
        }
        if (this._typeName == null && (this._properties == null || this._properties.isEmpty())) {
            buffer.append("Any");
        }
        if (this._minimum == this._maximum) {
            if (this._minimum != 1) {
                buffer.append("(").append(this._minimum).append(")");
            }
        } else {
            buffer.append("(").append(this._minimum).append(":").append(this._maximum).append(")");
        }
        if (this._properties != null && !this._properties.isEmpty()) {
            buffer.append("[");
            int i = 0;
            for (PropertyConstraint p : this._properties) {
                buffer.append(p.getDisplay());
                if (i < this._properties.size() - 1) {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getDisplay();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityConstraint other = (EntityConstraint)obj;
        if (this._typeName == null ? other._typeName != null : !this._typeName.equals(other._typeName)) {
            return false;
        }
        if (this._minimum != other._minimum) {
            return false;
        }
        if (this._maximum != other._maximum) {
            return false;
        }
        return this.getProperties().equals(other.getProperties());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this._typeName != null ? this._typeName.hashCode() : 0);
        hash = 97 * hash + this._minimum;
        hash = 97 * hash + this._maximum;
        hash = 97 * hash + this.getProperties().hashCode();
        return hash;
    }

    @Override
    public List<String> getInputTypeNames() {
        ArrayList<String> types = new ArrayList<String>();
        if (this._typeName != null) {
            types.add(this._typeName);
        }
        return types;
    }
}

