/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.controls.FileBrowserPanel;
import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import com.paterva.maltego.util.FileExtensionFileFilter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractFileBrowserAdapter<TType>
extends AbstractControlAdapter<FileBrowserPanel, TType> {
    private boolean _selectDirectories;
    private boolean _selectFiles;
    private String _filterTitle;
    private String[] _extensions;

    @Override
    public FileBrowserPanel create() {
        FileBrowserPanel control = this.createControl();
        control.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFileBrowserAdapter.this.fireActionPerformed(e);
            }
        });
        control.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractFileBrowserAdapter.this.fireChange();
            }
        });
        this.init(control);
        return control;
    }

    protected abstract FileBrowserPanel createControl();

    protected void init(FileBrowserPanel control) {
        control.setSelectDirectories(this._selectDirectories);
        control.setSelectFiles(this._selectFiles);
        control.setFileFilter((FileFilter)new FileExtensionFileFilter(this._extensions, this._filterTitle));
    }

    @Override
    protected boolean empty(FileBrowserPanel component) {
        return this.get(component) == null;
    }

    public boolean isSelectDirectories() {
        return this._selectDirectories;
    }

    public void setSelectDirectories(boolean selectDirectories) {
        this._selectDirectories = selectDirectories;
    }

    public boolean isSelectFiles() {
        return this._selectFiles;
    }

    public void setSelectFiles(boolean selectFiles) {
        this._selectFiles = selectFiles;
    }

    public String getFilterTitle() {
        return this._filterTitle;
    }

    public void setFilterTitle(String filterTitle) {
        this._filterTitle = filterTitle;
    }

    public String[] getExtensions() {
        return this._extensions;
    }

    public void setExtensions(String[] extensions) {
        this._extensions = extensions;
    }

    @Override
    public void setBackground(FileBrowserPanel component, Color color) {
    }
}

