/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SimpleColorPicker
extends JComponent {
    public static final String PROP_SELECTED_COLOR = "selectedColor";
    private static final int BUTTON_SIZE = 15;
    private static final int V_SPACING = 5;
    private static final int H_SPACING = 5;
    private static final int SELECTION_BLOCK_WIDTH = 30;
    private static final int SELECTION_BLOCK_HEIGHT = 35;
    private Color _borderColor = Color.gray;
    private Color _borderHighlightColor = Color.lightGray;
    private ColorButton[] _buttons;
    private Color _selectedColor = Color.black;
    private Rectangle _selectionRect;
    private ColorButton _highlightedColor;

    public SimpleColorPicker() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.addMouseListener(new ColorPickerMouseListener());
        this.addMouseMotionListener(new ColorPickerMouseMotionListener());
        this.updateButtons();
    }

    private void setHighlightedColor(ColorButton button) {
        if (this._highlightedColor != button) {
            if (this._highlightedColor != null) {
                this.repaint(this._highlightedColor.getRectangle());
            }
            if (button != null) {
                this.repaint(button.getRectangle());
            }
            this._highlightedColor = button;
        }
    }

    private void handlePress(MouseEvent e) {
        Point p = e.getPoint();
        ColorButton hit = this.hitButton(p);
        if (hit != null) {
            Color old = this._selectedColor;
            this._selectedColor = hit.getColor();
            this.repaint(this._selectionRect);
            this.firePropertyChange(PROP_SELECTED_COLOR, old, this._selectedColor);
        }
    }

    private void handleMove(MouseEvent e) {
        Point p = e.getPoint();
        ColorButton hit = this.hitButton(p);
        this.setHighlightedColor(hit);
    }

    private ColorButton hitButton(Point p) {
        if (this._buttons != null) {
            for (ColorButton button : this._buttons) {
                if (!button.isHit(p)) continue;
                return button;
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintButtons(g);
        this.paintSelection(g);
    }

    private void updateButtons() {
        this._buttons = new ColorButton[this.getCount()];
        int columns = this.getColumnCount();
        Insets insets = this.getInsets();
        int y = insets.top;
        int x = insets.left;
        int maxY = 0;
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttons[i] = new ColorButton(x, y, i + 1);
            if ((i + 1) % columns == 0) {
                x = insets.left;
                y = y + 15 + 5;
                if (i == this._buttons.length - 1) continue;
                maxY = y + 15 + 5;
                continue;
            }
            x = x + 15 + 5;
        }
        x = insets.left + columns * 20 + 5;
        this._selectionRect = new Rectangle(x, insets.top, 30, 35);
        int width = (int)this._selectionRect.getMaxX() + insets.right;
        int height = Math.max((int)this._selectionRect.getMaxY(), maxY);
        this.setPreferredSize(new Dimension(width, height));
    }

    private int getColumnCount() {
        return 4;
    }

    private int getCount() {
        int count = UIManager.getLookAndFeelDefaults().getInt("color-picker-count");
        return count;
    }

    private void paintButtons(Graphics g) {
        if (this._buttons != null) {
            for (ColorButton button : this._buttons) {
                button.paint(g, this._highlightedColor == button);
            }
        }
    }

    private void paintSelection(Graphics g) {
        if (this._selectedColor != null && this._selectionRect != null) {
            g.setColor(this._selectedColor);
            g.fillRect(this._selectionRect.x, this._selectionRect.y, this._selectionRect.width, this._selectionRect.height);
        }
        g.setColor(this._borderColor);
        g.drawRect(this._selectionRect.x, this._selectionRect.y, this._selectionRect.width, this._selectionRect.height);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this._selectedColor = selectedColor;
    }

    private class ColorPickerMouseMotionListener
    implements MouseMotionListener {
        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SimpleColorPicker.this.handleMove(e);
        }
    }

    private class ColorPickerMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SimpleColorPicker.this.handlePress(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SimpleColorPicker.this.setHighlightedColor(null);
        }
    }

    private class ColorButton {
        private final int _x;
        private final int _y;
        private final int _index;
        private final Rectangle _rect;

        public ColorButton(int x, int y, int index) {
            this._index = index;
            this._x = x;
            this._y = y;
            this._rect = new Rectangle(x, y, 15, 15);
        }

        public boolean isHit(Point p) {
            return this._rect.contains(p);
        }

        public void paint(Graphics g, boolean highlighted) {
            g.setColor(this.getColor());
            g.fillRect(this._x, this._y, 15, 15);
            g.setColor(highlighted ? SimpleColorPicker.this._borderHighlightColor : SimpleColorPicker.this._borderColor);
            g.drawRect(this._x, this._y, 15, 15);
        }

        public Color getColor() {
            return UIManager.getLookAndFeelDefaults().getColor("color-picker-color" + this._index);
        }

        public int getIndex() {
            return this._index;
        }

        public Rectangle getRectangle() {
            return this._rect;
        }
    }
}

