/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;

public abstract class JSToDoubleNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSToDoubleNode toDoubleNode;

    public abstract Object execute(Object var1);

    public abstract double executeDouble(Object var1);

    public static JSToDoubleNode create() {
        return JSToDoubleNodeGen.create();
    }

    @Specialization
    protected static double doInteger(int value) {
        return value;
    }

    @Specialization
    protected static double doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static double doDouble(double value) {
        return value;
    }

    @Specialization
    protected final double doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertBigIntToNumber(this);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static double doNull(Object value) {
        return 0.0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static double doUndefined(Object value) {
        return Double.NaN;
    }

    @Specialization
    protected static double doStringDouble(String value, @Cached(value="create()") JSStringToNumberNode stringToNumberNode) {
        return stringToNumberNode.executeString(value);
    }

    @Specialization(guards={"isJSObject(value)"})
    protected double doJSObject(DynamicObject value, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode) {
        return this.getToDoubleNode().executeDouble(toPrimitiveNode.execute(value));
    }

    @Specialization
    protected final double doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected double doForeignObject(Object object, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode) {
        return this.getToDoubleNode().executeDouble(toPrimitiveNode.execute(object));
    }

    private JSToDoubleNode getToDoubleNode() {
        if (this.toDoubleNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toDoubleNode = (JSToDoubleNode)this.insert(JSToDoubleNode.create());
        }
        return this.toDoubleNode;
    }

    @Specialization(guards={"isJavaNumber(value)"})
    protected static double doJavaNumber(Object value) {
        return JSRuntime.doubleValue((Number)value);
    }
}

