/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.ui.DefaultViewletRegistry;
import com.paterva.maltego.view.customization.ui.ViewletRegistry;
import com.paterva.maltego.view.customization.ui.imex.SelectableView;
import com.paterva.maltego.view.customization.ui.imex.SelectableViewlet;
import com.paterva.maltego.view.customization.ui.imex.Util;
import com.paterva.maltego.view.customization.ui.imex.ViewletAttributesEntryFactory;
import com.paterva.maltego.view.customization.ui.imex.ViewletAttributesWrapper;
import com.paterva.maltego.view.customization.ui.imex.ViewletConfig;
import com.paterva.maltego.view.customization.ui.imex.ViewletEntryFactory;
import com.paterva.maltego.view.customization.ui.imex.ViewletExistInfo;
import com.paterva.maltego.view.customization.ui.imex.ViewletWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileObject;

public class ViewletImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List wrappers = reader.readAll((EntryFactory)new ViewletEntryFactory(), "Graph1");
        if (wrappers.isEmpty()) {
            return null;
        }
        List attributesWrappers = reader.readAll((EntryFactory)new ViewletAttributesEntryFactory(), "Graph1");
        HashMap<String, Set<Viewlet>> viewletsPerView = new HashMap<String, Set<Viewlet>>();
        for (ViewletWrapper wrapper : wrappers) {
            String viewID = wrapper.getViewID();
            Viewlet viewlet = this.getViewlet(wrapper, attributesWrappers);
            HashSet<Viewlet> viewlets = (HashSet<Viewlet>)viewletsPerView.get(viewID);
            if (viewlets == null) {
                viewlets = new HashSet<Viewlet>();
            }
            viewlets.add(viewlet);
            viewletsPerView.put(viewID, viewlets);
        }
        return this.createConfig(viewletsPerView);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        DefaultViewletRegistry registry = new DefaultViewletRegistry(configRoot);
        Map<String, Set<Viewlet>> viewletsPerView = ((ViewletRegistry)registry).getAll();
        return this.createConfig(viewletsPerView);
    }

    private Config createConfig(Map<String, Set<Viewlet>> viewletsPerView) {
        if (viewletsPerView.isEmpty()) {
            return null;
        }
        ArrayList<SelectableView> selectableViews = Util.createSelectables(viewletsPerView);
        ViewletExistInfo viewletExistInfo = new ViewletExistInfo();
        for (SelectableView selectableView : selectableViews) {
            String viewID = selectableView.getViewID();
            boolean oneSelected = false;
            for (SelectableViewlet selectableViewlet : selectableView) {
                Viewlet viewlet = selectableViewlet.getViewlet();
                boolean viewletSelected = !viewletExistInfo.exist(viewID, viewlet);
                selectableViewlet.setSelected(viewletSelected);
                oneSelected |= viewletSelected;
            }
            selectableView.setSelected(oneSelected);
        }
        return new ViewletConfig(selectableViews);
    }

    private Viewlet getViewlet(ViewletWrapper wrapper, List<ViewletAttributesWrapper> attributesWrappers) {
        Viewlet viewlet = wrapper.getViewlet();
        for (ViewletAttributesWrapper attributes : attributesWrappers) {
            if (!wrapper.getFileName().equals(attributes.getFileName())) continue;
            viewlet.setIcon(attributes.getIcon());
            viewlet.setInMenu(attributes.isInMenu());
            viewlet.setInToolbar(attributes.isInToolbar());
        }
        return viewlet;
    }

    public int applyConfig(Config config) {
        ViewletConfig viewletConfig = (ViewletConfig)config;
        ViewletRegistry registry = ViewletRegistry.getDefault();
        int count = 0;
        for (SelectableView selectableView : viewletConfig.getSelectedViews()) {
            String viewID = selectableView.getViewID();
            HashSet<Viewlet> viewlets = new HashSet<Viewlet>(registry.getAll(viewID));
            for (SelectableViewlet selectableViewlet : selectableView) {
                if (!selectableViewlet.isSelected()) continue;
                Viewlet viewlet = selectableViewlet.getViewlet();
                viewlets.remove(viewlet);
                viewlets.add(viewlet);
                ++count;
            }
            registry.setAll(viewID, viewlets);
        }
        return count;
    }
}

