/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class FloatValueProfile
extends Profile {
    FloatValueProfile() {
    }

    public abstract float profile(float var1);

    public static FloatValueProfile createRawIdentityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    public static FloatValueProfile getUncached() {
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends FloatValueProfile {
        static final FloatValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public float profile(float value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(FloatValueProfile.class);
        }
    }

    static final class Enabled
    extends FloatValueProfile {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED = 1;
        private static final byte GENERIC = 2;
        @CompilerDirectives.CompilationFinal
        private float cachedValue;
        @CompilerDirectives.CompilationFinal
        private int cachedRawValue;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;

        Enabled() {
        }

        @Override
        public float profile(float value) {
            byte localState = this.state;
            if (localState != 2) {
                if (localState == 1 && this.cachedRawValue == Float.floatToRawIntBits(value)) {
                    return this.cachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedValue = value;
                    this.cachedRawValue = Float.floatToRawIntBits(value);
                    this.state = 1;
                } else {
                    this.state = (byte)2;
                }
            }
            return value;
        }

        boolean isGeneric() {
            return this.state == 2;
        }

        boolean isUninitialized() {
            return this.state == 0;
        }

        @Override
        public void disable() {
            this.state = (byte)2;
        }

        @Override
        public void reset() {
            this.state = 0;
        }

        float getCachedValue() {
            return this.cachedValue;
        }

        public String toString() {
            return this.toString(FloatValueProfile.class, this.state == 0, this.state == 2, String.format("value == (float)%s (raw %h)", Float.valueOf(this.cachedValue), this.cachedRawValue));
        }

        static FloatValueProfile create() {
            return new Enabled();
        }
    }
}

