/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.openide.util.Lookup;

public abstract class TabularGraphFileImporterFactory
implements Comparable<TabularGraphFileImporterFactory> {
    public static TabularGraphFileImporterFactory[] getAll() {
        return (TabularGraphFileImporterFactory[])Lookup.getDefault().lookupAll(TabularGraphFileImporterFactory.class).stream().sorted().toArray(TabularGraphFileImporterFactory[]::new);
    }

    public static Optional<TabularGraphFileImporterFactory> get(File file) {
        return Arrays.stream(TabularGraphFileImporterFactory.getAll()).filter(factory -> factory.isCompatibleWith(file)).findFirst();
    }

    public static Optional<TabularGraphFileImporter> createImporter(File file) {
        return TabularGraphFileImporterFactory.get(file).map(factory -> factory.create(file));
    }

    public static List<TabularGraphFileImporter> createImporters(List<File> files) {
        return files.stream().map(file -> TabularGraphFileImporterFactory.createImporter(file)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public abstract String getFileType();

    public abstract String getExtension();

    public abstract ImageIcon getImageIcon();

    public abstract TabularGraphFileImporter create(File var1);

    public String getFileTypeDescription() {
        return this.getFileType() + " (*." + this.getExtension() + ")";
    }

    public boolean isCompatibleWith(File file) {
        String filename = file.getName().toLowerCase();
        return filename.endsWith("." + this.getExtension());
    }

    @Override
    public int compareTo(TabularGraphFileImporterFactory other) {
        return this.getFileTypeDescription().compareToIgnoreCase(other.getFileTypeDescription());
    }
}

