/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

class EntityRegistryTableModel
extends RowTableModel<MaltegoEntitySpec> {
    public static final String[] Columns = new String[]{"", "Display name", "Description", "Type", "Value property", "Default value"};
    private final EntityRegistry _registry;
    private final RegistryListener _listener;

    public EntityRegistryTableModel(EntityRegistry registry) {
        super(Columns, EntityRegistryTableModel.getSortedSpecs(registry));
        this._registry = registry;
        this._listener = new RegistryListener(){

            public void typeAdded(RegistryEvent event) {
                EntityRegistryTableModel.this.refresh();
            }

            public void typeRemoved(RegistryEvent event) {
                EntityRegistryTableModel.this.refresh();
            }

            public void typeUpdated(RegistryEvent event) {
                EntityRegistryTableModel.this.refresh();
            }
        };
        this._registry.addRegistryListener((RegistryListener)WeakListeners.create(RegistryListener.class, (EventListener)this._listener, (Object)this._registry));
    }

    private static List<MaltegoEntitySpec> getSortedSpecs(EntityRegistry registry) {
        ArrayList<MaltegoEntitySpec> list = new ArrayList<MaltegoEntitySpec>(registry.getAllVisible());
        Collections.sort(list, new TypeSpecDisplayNameComparator());
        return list;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Image.class;
        }
        return String.class;
    }

    public void refresh() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EntityRegistryTableModel.this.setRows(EntityRegistryTableModel.getSortedSpecs(EntityRegistryTableModel.this._registry));
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public Object getValueFor(MaltegoEntitySpec row, int column) {
        switch (column) {
            case 0: {
                Image icon = row.getIcon(IconSize.TINY.getSize());
                if (icon == null) {
                    icon = ImageUtilities.loadImage((String)"com/paterva/maltego/entity/manager/resources/Entity.png");
                }
                return icon;
            }
            case 1: {
                return row.getDisplayName();
            }
            case 2: {
                return row.getDescription();
            }
            case 3: {
                return row.getTypeName();
            }
            case 4: {
                DisplayDescriptor dd = row.getValueProperty();
                return dd == null ? "<none>" : dd.getDisplayName();
            }
            case 5: {
                DisplayDescriptor ddd = row.getValueProperty();
                return ddd == null ? "<none>" : ddd.getDefaultValue();
            }
        }
        return null;
    }
}

