/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.registry;

import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInputsRepository;
import com.paterva.maltego.tx.inputs.global.serialize.GlobalTransformInputSerializer;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class DefaultGlobalTransformInputsRepository
extends GlobalTransformInputsRepository {
    private static final Logger LOG = Logger.getLogger(DefaultGlobalTransformInputsRepository.class.getName());
    public static final String USER_CLEARED_BUT_THERE_IS_DEFAULT_VALUE = "userClearedButThereIsDefaultValue";
    private static final String FOLDER = "Maltego/Inputs/";
    private static final String INPUT_EXT = "input";
    private final InputsDataSource _dataSource = new InputsDataSource();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final PropertyChangeSupport _dataSourceChangeSupport = new PropertyChangeSupport(this);
    private final FileObject _configRoot;
    private Map<GlobalTransformInput, FileObject> _inputs;

    public DefaultGlobalTransformInputsRepository() {
        this(FileUtil.getConfigRoot());
    }

    public DefaultGlobalTransformInputsRepository(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    @Override
    public GlobalTransformInput get(String name) {
        this.loadInputs();
        for (Map.Entry<GlobalTransformInput, FileObject> entry : this._inputs.entrySet()) {
            GlobalTransformInput input = entry.getKey();
            if (!input.getDescriptor().getName().equals(name)) continue;
            return input;
        }
        return null;
    }

    @Override
    public void put(GlobalTransformInput input) {
        this.getData().setValue((PropertyDescriptor)input.getDescriptor(), input.getValue());
    }

    @Override
    public void remove(GlobalTransformInput input) {
        this.getData().setValue((PropertyDescriptor)input.getDescriptor(), null);
    }

    @Override
    public Collection<GlobalTransformInput> getAll() {
        this.loadInputs();
        return this._inputs.keySet();
    }

    @Override
    public synchronized DataSource getData() {
        this.loadInputs();
        return this._dataSource;
    }

    private synchronized void loadInputs() {
        if (this._inputs == null) {
            try {
                this._inputs = this.load();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this._inputs = new HashMap<GlobalTransformInput, FileObject>();
            }
        }
    }

    private FileObject getFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)FOLDER);
    }

    private synchronized Map<GlobalTransformInput, FileObject> load() throws IOException {
        HashMap<GlobalTransformInput, FileObject> inputs = new HashMap<GlobalTransformInput, FileObject>();
        FileObject folder = this.getFolder();
        if (folder != null) {
            for (FileObject file : folder.getChildren()) {
                GlobalTransformInput input;
                if (!file.isData() || (input = this.load(file)) == null) continue;
                inputs.put(input, file);
            }
        }
        return inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalTransformInput load(FileObject file) throws IOException {
        GlobalTransformInput input = null;
        try (InputStream inputStream = null;){
            inputStream = file.getInputStream();
            GlobalTransformInputSerializer serializer = new GlobalTransformInputSerializer();
            input = serializer.read(inputStream);
            LOG.log(Level.FINE, "Global input loaded: {0}", input);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save(GlobalTransformInput input) throws IOException {
        TransformPropertyDescriptor descriptor = input.getDescriptor();
        FileObject folder = this.getFolder();
        String name = descriptor.getName();
        FileObject file = this._inputs.get(input);
        if (file == null) {
            file = FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)name), (String)INPUT_EXT);
            this._inputs.put(input, file);
        }
        try (OutputStream outputStream = null;){
            LOG.log(Level.FINE, "Saving global input: {0}", descriptor);
            outputStream = new BufferedOutputStream(file.getOutputStream());
            GlobalTransformInputSerializer serializer = new GlobalTransformInputSerializer();
            serializer.write(input, outputStream);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
        this._dataSourceChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
        this._dataSourceChangeSupport.removePropertyChangeListener(listener);
    }

    private class InputsDataSource
    implements DataSource {
        private boolean _isUpdating = false;

        private InputsDataSource() {
        }

        public Object getValue(PropertyDescriptor descriptor) {
            GlobalTransformInput input = this.getInput(descriptor);
            return input == null ? null : input.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(PropertyDescriptor descriptor, Object value) {
            block15: {
                if (!this._isUpdating) {
                    try {
                        Object defaultValue;
                        String propName;
                        this._isUpdating = true;
                        if (!(descriptor instanceof TransformPropertyDescriptor)) {
                            throw new IllegalArgumentException("Not a TransformPropertyDescriptor: " + descriptor);
                        }
                        TransformPropertyDescriptor transformPropDescriptor = (TransformPropertyDescriptor)descriptor;
                        GlobalTransformInput input = this.getInput((PropertyDescriptor)transformPropDescriptor);
                        Object oldValue = null;
                        boolean save = true;
                        boolean updateControl = false;
                        if (value instanceof String && StringUtilities.isNullOrEmpty((String)((String)value)) && ((propName = transformPropDescriptor.getName()).toLowerCase().startsWith("global#") || transformPropDescriptor.isGlobal()) && (defaultValue = transformPropDescriptor.getDefaultValue()) instanceof String && !StringUtilities.isNullOrEmpty((String)((String)defaultValue))) {
                            value = defaultValue;
                            updateControl = true;
                        }
                        if (input == null) {
                            input = new GlobalTransformInput(transformPropDescriptor, value);
                        } else if (!Objects.equals(input.getValue(), value)) {
                            oldValue = input.getValue();
                            input.setValue(value);
                        } else if (updateControl) {
                            oldValue = input.getValue();
                            input.setValue(value);
                        } else {
                            save = false;
                        }
                        if (!save) break block15;
                        try {
                            DefaultGlobalTransformInputsRepository.this.save(input);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        DefaultGlobalTransformInputsRepository.this._changeSupport.firePropertyChange(input.getDescriptor().getName(), oldValue, value);
                        if (updateControl) {
                            DefaultGlobalTransformInputsRepository.this._dataSourceChangeSupport.firePropertyChange(DefaultGlobalTransformInputsRepository.USER_CLEARED_BUT_THERE_IS_DEFAULT_VALUE, "always", "fire");
                        }
                    }
                    finally {
                        this._isUpdating = false;
                    }
                }
            }
        }

        public void clear() {
            for (GlobalTransformInput key : DefaultGlobalTransformInputsRepository.this._inputs.keySet()) {
                this.setValue((PropertyDescriptor)key.getDescriptor(), null);
            }
            if (this._isUpdating) {
                return;
            }
            try {
                this._isUpdating = true;
                DefaultGlobalTransformInputsRepository.this._inputs.clear();
            }
            finally {
                this._isUpdating = false;
            }
        }

        private GlobalTransformInput getInput(PropertyDescriptor descriptor) {
            for (Map.Entry entry : DefaultGlobalTransformInputsRepository.this._inputs.entrySet()) {
                GlobalTransformInput input = (GlobalTransformInput)entry.getKey();
                if (!input.getDescriptor().equals(descriptor)) continue;
                return input;
            }
            return null;
        }
    }
}

