/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global;

import com.paterva.maltego.tx.inputs.global.GlobalTransformInputDescriptor;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputSource;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputSources;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class GlobalTransformInputGroup {
    private final GlobalTransformInputSources _sources;
    private final Set<GlobalTransformInputDescriptor> _inputs;

    public GlobalTransformInputGroup(GlobalTransformInputSources sources, Set<GlobalTransformInputDescriptor> inputs) {
        this._sources = sources;
        this._inputs = Collections.unmodifiableSet(inputs);
    }

    public GlobalTransformInputSources getSources() {
        return this._sources;
    }

    public Set<GlobalTransformInputDescriptor> getInputs() {
        return this._inputs;
    }

    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        GlobalTransformInputSources sources = this.getSources();
        boolean first = true;
        for (GlobalTransformInputSource source : sources.getSources()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(source.getDisplayName());
            first = false;
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this._sources);
        hash = 79 * hash + Objects.hashCode(this._inputs);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTransformInputGroup other = (GlobalTransformInputGroup)obj;
        if (!Objects.equals(this._sources, other._sources)) {
            return false;
        }
        return Objects.equals(this._inputs, other._inputs);
    }

    public boolean semiDeepEquals(GlobalTransformInputGroup other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this._sources, other._sources)) {
            return false;
        }
        if (this._inputs == null && other._inputs == null) {
            return true;
        }
        if (this._inputs == null || other._inputs == null) {
            return false;
        }
        if (this._inputs.size() != other._inputs.size()) {
            return false;
        }
        for (GlobalTransformInputDescriptor input : this._inputs) {
            boolean found = false;
            for (GlobalTransformInputDescriptor otherInput : other._inputs) {
                if (!input.semiDeepEquals(otherInput)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

