/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public abstract class IncrementalLayoutSettings {
    public static final String PROP_INCREMENTAL = "incrementalChanged";
    private static IncrementalLayoutSettings _default = null;

    public static IncrementalLayoutSettings getDefault() {
        if (_default == null && (_default = (IncrementalLayoutSettings)Lookup.getDefault().lookup(IncrementalLayoutSettings.class)) == null) {
            return new Default();
        }
        return _default;
    }

    public abstract void setIncremental(String var1, boolean var2);

    public abstract boolean isIncremental(String var1);

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    private static class Default
    extends IncrementalLayoutSettings {
        private static final String PREF_INCREMENTAL_PREFIX = "maltego.layout.incremental.";
        private Preferences _prefs = NbPreferences.forModule(IncrementalLayoutSettings.class);
        private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

        private Default() {
        }

        @Override
        public synchronized void setIncremental(String graphType, boolean incremental) {
            if (incremental != this.isIncremental(graphType)) {
                this._prefs.putBoolean(PREF_INCREMENTAL_PREFIX + graphType, incremental);
                this._changeSupport.firePropertyChange(IncrementalLayoutSettings.PROP_INCREMENTAL, null, null);
            }
        }

        @Override
        public synchronized boolean isIncremental(String graphType) {
            return this._prefs.getBoolean(PREF_INCREMENTAL_PREFIX + graphType, "shared".equals(graphType));
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this._changeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }
}

