/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openide.util.Utilities;

public class ActionOptionsPanel
extends JPanel {
    private Map<JRadioButton, Action> _options;

    public ActionOptionsPanel(List<? extends Action> actions) {
        this.setLayout(new BoxLayout(this, 1));
        this.addActions(actions);
    }

    public ActionOptionsPanel(String actionsPath) {
        this(Utilities.actionsForPath((String)actionsPath));
    }

    public Action getSelected() {
        for (Map.Entry<JRadioButton, Action> entry : this._options.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            return entry.getValue();
        }
        return null;
    }

    private void addActions(List<? extends Action> actions) {
        ButtonGroup buttonGroup = new ButtonGroup();
        this._options = new HashMap<JRadioButton, Action>();
        for (Action action : actions) {
            JRadioButton radioButton = new JRadioButton((String)action.getValue("Name"));
            this.add(radioButton);
            buttonGroup.add(radioButton);
            if (this._options.isEmpty()) {
                radioButton.setSelected(true);
            }
            this._options.put(radioButton, action);
        }
    }
}

