/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.customicons.imex.IconRegistryIcon;
import com.paterva.maltego.customicons.imex.Util;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class IconRegistryIconEntry
extends Entry<IconRegistryIcon> {
    public static final String DefaultFolder = "Icons";
    public static final String Type = "png";

    public IconRegistryIconEntry(IconRegistryIcon data) {
        super((Object)data, "Icons/" + data.getCategory(), data.getFileName());
    }

    public IconRegistryIconEntry(String path) {
        super(path);
    }

    protected IconRegistryIcon read(InputStream is) throws IOException {
        IconRegistryIcon iconRegistryIcon = null;
        Matcher matcher = Pattern.compile("^([^\\d]+)(\\d*)$").matcher(this.getTypeName());
        if (matcher.matches() && matcher.groupCount() == 2) {
            String folders = this.getFolder();
            String category = Util.getCategory(DefaultFolder, folders);
            String iconName = matcher.group(1);
            IconSize size = IconSize.getSize((String)matcher.group(2));
            BufferedImage icon = ImageIO.read(is);
            iconRegistryIcon = new IconRegistryIcon(category, iconName, size, icon);
        } else {
            Logger.getLogger(IconRegistryIconEntry.class.getName()).log(Level.WARNING, "Invalid icon: {0}", this.getFileName());
        }
        return iconRegistryIcon;
    }

    protected void write(IconRegistryIcon data, OutputStream os) throws IOException {
        ImageIO.write((RenderedImage)ImageUtils.createBufferedImage((Image)data.getIcon()), Type, os);
    }
}

