/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemPanel;
import com.paterva.maltego.util.ui.treelist.TreeListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;

public class TreeListSlideAnimator {
    private static final int TIMER_DELAY_MS = 8;
    private static final int EXPAND_TIME_MS = 150;
    private final TreeListPanel _treeList;
    private final TimerListener _listener = new TimerListener();
    private final SlidingAnimationPanel _slidingPanel = new SlidingAnimationPanel();
    private Timer _timer;
    private long _startTime;
    private boolean _slideLeft;
    private BufferedImage _imgLeft;
    private BufferedImage _imgRight;

    public TreeListSlideAnimator(TreeListPanel treeList) {
        this._treeList = treeList;
    }

    public void slide(List<TreeListItemPanel> oldItemPanels, List<TreeListItem> newItems, boolean slideLeft) {
        this.complete();
        this._slideLeft = slideLeft;
        int siblingWidth = this.getMaxSiblingWidth();
        BufferedImage oldImg = this.treeListScreenshot(siblingWidth);
        this._treeList.addAllItems();
        this._treeList.validate();
        this._treeList.doLayout();
        BufferedImage newImg = this.treeListScreenshot(siblingWidth);
        this._imgLeft = slideLeft ? oldImg : newImg;
        this._imgRight = slideLeft ? newImg : oldImg;
        this._treeList.removeAllItems();
        this._treeList.setLayout(new BorderLayout());
        this._startTime = System.currentTimeMillis();
        this._treeList.setScrollableTracksViewportHeight(true);
        this._timer = new Timer(8, this._listener);
        this._timer.setRepeats(true);
        this._timer.start();
        this.update();
    }

    private BufferedImage treeListScreenshot(int siblingWidth) {
        Dimension actualSize = this._treeList.getSize();
        Dimension maxSize = this._treeList.getMaximumSize();
        Dimension size = this._treeList.getPreferredSize();
        size.width = Math.max(Math.min(size.width, maxSize.width), siblingWidth - 2);
        this._treeList.setSize(size);
        size.height = Math.min(size.height, maxSize.height);
        this._treeList.invalidate();
        this._treeList.validate();
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics gfx = img.getGraphics();
        this._treeList.paint(gfx);
        gfx.dispose();
        this._treeList.setSize(actualSize);
        return img;
    }

    private int getMaxSiblingWidth() {
        int maxWidth = 0;
        Container treeListContainer = this._treeList;
        Container parent = this._treeList.getParent();
        while (parent instanceof JViewport || parent instanceof JScrollPane) {
            treeListContainer = parent;
            parent = parent.getParent();
        }
        boolean hasBackButton = true;
        treeListContainer = parent;
        parent = parent.getParent();
        for (Component component : parent.getComponents()) {
            if (component.equals(treeListContainer)) continue;
            maxWidth = Math.max(maxWidth, component.getPreferredSize().width);
        }
        return maxWidth -= 20;
    }

    public void complete() {
        if (this._timer != null) {
            this._startTime = 0L;
            this.update();
        }
    }

    private void update() {
        long time = System.currentTimeMillis();
        if (time - this._startTime >= 150L) {
            this._treeList.removeAll();
            this._treeList.setScrollableTracksViewportHeight(false);
            this._treeList.setLayout(new GridBagLayout());
            this._treeList.setSize(0, 0);
            this._treeList.addAllItems();
            this._timer.stop();
            this._timer = null;
            this._imgLeft = null;
            this._imgRight = null;
        } else {
            this._treeList.removeAll();
            this._treeList.add(this._slidingPanel);
        }
        this._treeList.revalidate();
        this._treeList.repaint();
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeListSlideAnimator.this.update();
        }
    }

    private class SlidingAnimationPanel
    extends JPanel {
        private SlidingAnimationPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            long elapsedTime = Math.min(this.elapsedTime(), 150L);
            BufferedImage startImg = TreeListSlideAnimator.this._slideLeft ? TreeListSlideAnimator.this._imgLeft : TreeListSlideAnimator.this._imgRight;
            BufferedImage endImg = !TreeListSlideAnimator.this._slideLeft ? TreeListSlideAnimator.this._imgLeft : TreeListSlideAnimator.this._imgRight;
            int startHeight = startImg.getHeight();
            int endHeight = endImg.getHeight();
            int height = (int)((long)(endHeight - startHeight) * elapsedTime / 150L + (long)startHeight);
            int startWidth = startImg.getWidth();
            int endWidth = endImg.getWidth();
            int width = (int)((long)(endWidth - startWidth) * elapsedTime / 150L + (long)startWidth);
            Dimension size = new Dimension(width, height);
            return size;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int shift = (int)(-(this.elapsedTime() * (long)TreeListSlideAnimator.this._imgLeft.getWidth() / 150L));
            if (!TreeListSlideAnimator.this._slideLeft) {
                shift = -(TreeListSlideAnimator.this._imgLeft.getWidth() + shift);
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(TreeListSlideAnimator.this._imgLeft, shift, 0, null);
            g.drawImage(TreeListSlideAnimator.this._imgRight, shift + TreeListSlideAnimator.this._imgLeft.getWidth(), 0, null);
        }

        private long elapsedTime() {
            return System.currentTimeMillis() - TreeListSlideAnimator.this._startTime;
        }
    }
}

