/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Lookup;

public final class ExplicitProcessParameters {
    final int position;
    private final List<String> launcherArguments;
    private final List<String> arguments;
    private final boolean replaceArgs;
    private final boolean replaceLauncherArgs;
    private static final ExplicitProcessParameters EMPTY = new ExplicitProcessParameters(0, null, null, false, false);

    private ExplicitProcessParameters(int position, List<String> launcherArguments, List<String> arguments, boolean appendArgs, boolean appendLauncherArgs) {
        this.position = position;
        this.launcherArguments = launcherArguments == null ? null : Collections.unmodifiableList(launcherArguments);
        this.arguments = arguments == null ? null : Collections.unmodifiableList(arguments);
        this.replaceArgs = appendArgs;
        this.replaceLauncherArgs = appendLauncherArgs;
    }

    public static ExplicitProcessParameters empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        boolean change = false;
        if (this.isArgReplacement() || this.isLauncherArgReplacement()) {
            return false;
        }
        return !(this.arguments != null && !this.arguments.isEmpty() || this.launcherArguments != null && !this.launcherArguments.isEmpty());
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getLauncherArguments() {
        return this.launcherArguments;
    }

    public boolean isArgReplacement() {
        return this.replaceArgs;
    }

    public boolean isLauncherArgReplacement() {
        return this.replaceLauncherArgs;
    }

    @NonNull
    public List<String> getAllArguments(List<String> middle) {
        ArrayList<String> a = new ArrayList<String>();
        if (this.launcherArguments != null) {
            a.addAll(this.launcherArguments);
        }
        if (middle != null && !middle.isEmpty()) {
            a.addAll(middle);
        }
        if (this.arguments != null) {
            a.addAll(this.arguments);
        }
        return a;
    }

    @NonNull
    public List<String> getAllArguments(String ... middle) {
        return this.getAllArguments(middle == null ? Collections.emptyList() : Arrays.asList(middle));
    }

    @NonNull
    public static ExplicitProcessParameters buildExplicitParameters(Lookup context) {
        return ExplicitProcessParameters.buildExplicitParameters(context.lookupAll(ExplicitProcessParameters.class));
    }

    public static ExplicitProcessParameters buildExplicitParameters(Collection<? extends ExplicitProcessParameters> items) {
        ArrayList<? extends ExplicitProcessParameters> all = new ArrayList<ExplicitProcessParameters>(items);
        Collections.sort(all, (a, b) -> a.position - b.position);
        Builder b2 = ExplicitProcessParameters.builder();
        for (ExplicitProcessParameters explicitProcessParameters : all) {
            b2.combine(explicitProcessParameters);
        }
        return b2.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int position = 0;
        private List<String> launcherArguments = null;
        private List<String> arguments = null;
        private Boolean replaceArgs;
        private Boolean replaceLauncherArgs;

        private void initArgs() {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
        }

        public Builder arg(@NullAllowed String a) {
            if (a == null) {
                return this;
            }
            this.initArgs();
            this.arguments.add(a);
            return this;
        }

        public Builder args(@NullAllowed List<String> args) {
            if (args == null) {
                return this;
            }
            this.initArgs();
            args.forEach(this::arg);
            return this;
        }

        public Builder args(String ... args) {
            if (args == null) {
                return this;
            }
            return this.args(Arrays.asList(args));
        }

        private void initLauncherArgs() {
            if (this.launcherArguments == null) {
                this.launcherArguments = new ArrayList<String>();
            }
        }

        public Builder launcherArg(@NullAllowed String a) {
            if (a == null) {
                return this;
            }
            this.initLauncherArgs();
            this.launcherArguments.add(a);
            return this;
        }

        public Builder launcherArgs(@NullAllowed List<String> args) {
            if (args == null) {
                return this;
            }
            this.initLauncherArgs();
            args.forEach(this::launcherArg);
            return this;
        }

        public Builder launcherArgs(String ... args) {
            if (args == null) {
                return this;
            }
            return this.launcherArgs(Arrays.asList(args));
        }

        public Builder replaceArgs(boolean replace) {
            this.replaceArgs = replace;
            return this;
        }

        public Builder replaceLauncherArgs(boolean replace) {
            this.replaceLauncherArgs = replace;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public Builder combine(@NullAllowed ExplicitProcessParameters p) {
            if (p == null) {
                return this;
            }
            if (p.isLauncherArgReplacement()) {
                this.launcherArguments = null;
                this.replaceLauncherArgs = p.getLauncherArguments() != null ? Boolean.valueOf(true) : null;
            }
            if (p.isArgReplacement()) {
                this.arguments = null;
                this.replaceArgs = p.getArguments() != null ? Boolean.valueOf(true) : null;
            }
            if (p.getLauncherArguments() != null) {
                this.launcherArgs(p.getLauncherArguments());
            }
            if (p.getArguments() != null) {
                this.args(p.getArguments());
            }
            return this;
        }

        public ExplicitProcessParameters build() {
            boolean aa = this.replaceArgs != null ? this.replaceArgs : this.arguments != null;
            boolean apa = this.replaceLauncherArgs != null ? this.replaceLauncherArgs : false;
            return new ExplicitProcessParameters(this.position, this.launcherArguments, this.arguments, aa, apa);
        }
    }
}

