/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.licensing.ui.action.TransformsAvailableAction;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.manager.api.TransformManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class NewTransformAction
extends TransformsAvailableAction {
    public static NewTransformAction instance() {
        return (NewTransformAction)SystemAction.findObject(NewTransformAction.class, (boolean)true);
    }

    public void actionPerformed(ActionEvent ae) {
        this.newTransform();
    }

    public TransformDefinition newTransform() {
        MaltegoEntitySpec spec = this.getActivatedSpec();
        if (spec != null) {
            return TransformManager.getDefault().createTransform(spec.getTypeName());
        }
        return TransformManager.getDefault().createTransform();
    }

    private MaltegoEntitySpec getActivatedSpec() {
        Collection specs = Utilities.actionsGlobalContext().lookupAll(MaltegoEntitySpec.class);
        Iterator it = specs.iterator();
        if (it.hasNext()) {
            return (MaltegoEntitySpec)it.next();
        }
        return null;
    }

    public String getName() {
        return "New Local Transform...";
    }

    protected String iconResource() {
        return "com/paterva/maltego/transform/manager/resources/AddTransform.png";
    }
}

