/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class FlatButton
extends AbstractButton {
    public FlatButton(Icon icon) {
        this(icon, null);
    }

    public FlatButton(Icon normal, Icon hover) {
        this(normal, hover, new DefaultButtonModel());
    }

    public FlatButton(Icon normal, Icon hover, ButtonModel model) {
        this.setModel(model);
        this.getModel().setArmed(true);
        this.setIcon(normal);
        if (hover != null) {
            this.setRolloverEnabled(true);
            this.setRolloverIcon(hover);
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.setPreferredSize(this.calcPreferredSize());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FlatButton.this.getModel().setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FlatButton.this.getModel().setRollover(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FlatButton.this.getModel().setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FlatButton.this.getModel().setPressed(false);
            }
        });
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.getModel().setArmed(b);
    }

    private Dimension calcPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.getIcon().getIconWidth() + insets.left + insets.right, this.getIcon().getIconHeight() + insets.bottom + insets.top);
    }

    @Override
    public void paint(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getParent().getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Icon icon = this.getIconToPaint();
        Insets insets = this.getInsets();
        int x = (this.getWidth() - insets.left - insets.right - icon.getIconWidth()) / 2 + insets.left;
        int y = (this.getHeight() - insets.top - insets.bottom - icon.getIconHeight()) / 2 + insets.top;
        if (this.getModel().isPressed()) {
            g.translate(1, 1);
        }
        icon.paintIcon(this, g, x, y);
        this.paintBorder(g);
    }

    private Icon getIconToPaint() {
        Icon icon = null;
        if (this.getModel().isSelected()) {
            icon = this.getSelectedIcon();
        } else if (this.getModel().isRollover()) {
            icon = this.getRolloverIcon();
        }
        if (icon == null) {
            icon = this.getIcon();
        }
        return icon;
    }
}

