/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import java.util.Iterator;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;

public final class Cursors {
    private Cursors() {
    }

    public static Iterable<Y> sourceNodes(Z edges) {
        return new SourceIterator(edges);
    }

    public static Iterable<Y> targetNodes(Z edges) {
        return new TargetIterator(edges);
    }

    public static Iterable<Y> parents(Y node) {
        return Cursors.sourceNodes(node.M());
    }

    public static Iterable<Y> children(Y node) {
        return Cursors.targetNodes(node.G());
    }

    public static Iterable<EntityID> parentEntities(Y node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper(node.H());
        return new EntityIterator(wrapper, new SourceIterator(node.M()));
    }

    public static Iterable<EntityID> childEntities(Y node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper(node.H());
        return new EntityIterator(wrapper, new TargetIterator(node.G()));
    }

    private static class EntityIterator
    implements Iterator<EntityID>,
    Iterable<EntityID> {
        private Iterator<Y> _nodes;
        private GraphWrapper _wrapper;

        public EntityIterator(GraphWrapper wrapper, Iterator<Y> nodes) {
            this._nodes = nodes;
            this._wrapper = wrapper;
        }

        @Override
        public boolean hasNext() {
            return this._nodes.hasNext();
        }

        @Override
        public EntityID next() {
            Y node = this._nodes.next();
            return this._wrapper.entityID(node);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<EntityID> iterator() {
            return this;
        }
    }

    private static abstract class EdgeCursorIterator
    implements Iterator<Y>,
    Iterable<Y> {
        private Z _ec;

        public EdgeCursorIterator(Z ec) {
            this._ec = ec;
        }

        @Override
        public boolean hasNext() {
            return this._ec.ok();
        }

        @Override
        public Y next() {
            Y node = this.node(this._ec.D());
            this._ec.next();
            return node;
        }

        protected abstract Y node(H var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Y> iterator() {
            return this;
        }
    }

    private static class SourceIterator
    extends EdgeCursorIterator {
        public SourceIterator(Z ec) {
            super(ec);
        }

        @Override
        protected Y node(H edge) {
            return edge.X();
        }
    }

    private static class TargetIterator
    extends EdgeCursorIterator {
        public TargetIterator(Z ec) {
            super(ec);
        }

        @Override
        protected Y node(H edge) {
            return edge.V();
        }
    }
}

