/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantEvent;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.RoomStatusCode;
import com.paterva.maltego.collab.session.CollaborationMessageListener;
import com.paterva.maltego.collab.session.CollaborationParticipantListener;
import com.paterva.maltego.collab.session.CollaborationPayloadListener;
import com.paterva.maltego.collab.session.CollaborationSession;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.CollaborationSessionListener;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.collab.session.SessionID;
import com.paterva.maltego.collab.session.xmpp.MessageFillProvider;
import com.paterva.maltego.collab.session.xmpp.MessageFillProviderFactory;
import com.paterva.maltego.collab.session.xmpp.PayloadEncoder;
import com.paterva.maltego.collab.session.xmpp.ReplayDetectedException;
import com.paterva.maltego.collab.session.xmpp.SessionInitializationStrategy;
import com.paterva.maltego.collab.session.xmpp.Utils;
import com.paterva.maltego.collab.session.xmpp.WrongVersionException;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationConnection;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationExtensionProvider;
import com.paterva.maltego.collab.session.xmpp.XmppEncodedCollaborationExtension;
import com.paterva.maltego.collab.session.xmpp.XmppMucSendQueue;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.MUCUser;

class XmppCollaborationSession
implements CollaborationSession {
    private static final Logger LOGGER = Logger.getLogger(XmppCollaborationSession.class.getName());
    public static final String COLLAB_ELEMENT = "maltego";
    public static final String COLLAB_NS = "maltego:collab";
    private static final String PARTICIPANT_INFO = "info";
    private static final int VERSION = 1;
    private Collection<CollaborationMessageListener> _messageListeners = new LinkedList<CollaborationMessageListener>();
    private Collection<CollaborationParticipantListener> _participantListeners = new LinkedList<CollaborationParticipantListener>();
    private Collection<CollaborationSessionListener> _sessionListeners = new LinkedList<CollaborationSessionListener>();
    private Map<String, Collection<CollaborationPayloadListener>> _payloadListeners = new HashMap<String, Collection<CollaborationPayloadListener>>();
    private MultiUserChat _muc;
    private XmppCollaborationConnection _cn;
    private final CollaborationSessionInfo _info;
    private final Map<String, Participant> _participants;
    private PayloadEncoder _encoder;
    private boolean _initialized = false;
    private String _statusMessage;
    private Participant _me;
    private volatile boolean _validKey = true;
    private volatile boolean _validVersion = true;
    private MessageFillProvider _fillProvider;
    private XmppMucSendQueue _sendQueue;
    private XmppConnectionListener _connectionListener;

    public XmppCollaborationSession(XmppCollaborationConnection connection, CollaborationSessionInfo info) {
        this._info = info;
        this._cn = connection;
        this._participants = new HashMap<String, Participant>();
        this._encoder = info.isDebugSession() ? new PayloadEncoder.None() : new PayloadEncoder.Stream(this._info.getSecurityKey().toCharArray(), this._info.isUse256Encryption(), 1, 0);
        this._fillProvider = MessageFillProviderFactory.getDefault().createProvider();
    }

    @Override
    public Participant getMe() {
        return this._me;
    }

    void initialize(SessionInitializationStrategy strategy) throws CollaborationException {
        try {
            if (this._initialized) {
                throw new CollaborationException("Session already initialized", false);
            }
            this._validKey = true;
            this._validVersion = true;
            this._muc = strategy.createChatRoom(this._cn, this._info);
            if (this._muc != null) {
                this._sendQueue = new XmppMucSendQueue(this._muc, this._fillProvider, this._encoder);
                this._sendQueue.start();
                this._cn.addMessageListener(Utils.getConferenceRoom(this._info), new MessageListener());
                this._connectionListener = new XmppConnectionListener();
                this._cn.addConnectionListener(this._connectionListener);
                this._muc.addPresenceInterceptor((PacketInterceptor)new PresenceInterceptor());
                this._muc.addParticipantListener((PacketListener)new PresenceListener());
                this._muc.addParticipantStatusListener((ParticipantStatusListener)new ParticipantStatusHandler());
                strategy.openChatRoom(this._muc, this._info);
                this._initialized = true;
            }
        }
        catch (Exception e) {
            if (e instanceof CollaborationException) {
                throw (CollaborationException)((Object)e);
            }
            throw new CollaborationException(e, true);
        }
    }

    void configure(SessionInitializationStrategy strategy) throws CollaborationException {
        this._validKey = true;
        this._validVersion = false;
        strategy.configureChatRoom(this._muc, this._info);
    }

    void sendSessionID(SessionInitializationStrategy strategy, String id) throws CollaborationException {
        strategy.sendSessionID(this._muc, this._info, id);
    }

    @Override
    public CollaborationSessionInfo getSessionInfo() {
        return this._info;
    }

    private PayloadEncoder encoder() {
        return this._encoder;
    }

    private void assertInitialized() throws CollaborationException {
        if (!this._initialized) {
            throw new CollaborationException("Session has not been initialized", true);
        }
    }

    @Override
    public void sendNotification() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sendPayloadXml(String xml) throws CollaborationException {
        this.sendPayloadXml(null, xml);
    }

    @Override
    public void sendPayloadXml(String to, String xml) throws CollaborationException {
        this.assertInitialized();
        if (xml != null) {
            this._sendQueue.send(to, xml);
        }
    }

    public void close() throws CollaborationException {
        try {
            if (this._sendQueue != null) {
                this._sendQueue.stop();
            }
            if (this._cn != null && this._cn.isConnected() && this._muc != null) {
                this._muc.leave();
            }
        }
        finally {
            if (this._muc != null) {
                this._cn.removeConnectionListener(this._connectionListener);
                this._cn.removeMessageListener(Utils.getConferenceRoom(this._info));
            }
            this._connectionListener = null;
        }
    }

    @Override
    public synchronized void addParticipantListener(CollaborationParticipantListener listener) {
        this._participantListeners.add(listener);
    }

    @Override
    public synchronized void addSessionListener(CollaborationSessionListener listener) {
        this._sessionListeners.add(listener);
    }

    @Override
    public synchronized void addCollaborationMessageListener(CollaborationMessageListener listener) {
        this._messageListeners.add(listener);
    }

    @Override
    public synchronized void addPayloadListener(String type, CollaborationPayloadListener listener) {
        Collection<CollaborationPayloadListener> listeners = this._payloadListeners.get(type);
        if (listeners == null) {
            listeners = new LinkedList<CollaborationPayloadListener>();
            this._payloadListeners.put(type, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public synchronized void removeParticipantListener(CollaborationParticipantListener listener) {
        this._participantListeners.remove(listener);
    }

    @Override
    public synchronized void removeSessionListener(CollaborationSessionListener listener) {
        this._sessionListeners.remove(listener);
    }

    @Override
    public synchronized void removeCollaborationMessageListener(CollaborationMessageListener listener) {
        this._messageListeners.remove(listener);
    }

    @Override
    public synchronized void removePayloadListener(String type, CollaborationPayloadListener listener) {
        Collection<CollaborationPayloadListener> listeners = this._payloadListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this._payloadListeners.remove(type);
            }
        }
    }

    private Date getTimestamp(Message msg) {
        DelayInformation delay = (DelayInformation)msg.getExtension("x", "jabber:x:delay");
        if (delay == null) {
            delay = (DelayInformation)msg.getExtension("delay", "urn:xmpp:delay");
        }
        if (delay != null) {
            return delay.getStamp();
        }
        return null;
    }

    private String createUniqueMessageID(String from, String packetID) {
        return packetID;
    }

    private void handleIncomingMessage(Message msg) {
        String subject;
        String body;
        String from = msg.getFrom();
        Participant p = this.getParticipant(from);
        if (p == null) {
            return;
        }
        PacketExtension ext = msg.getExtension(COLLAB_ELEMENT, COLLAB_NS);
        Date date = this.getTimestamp(msg);
        if (ext instanceof XmppEncodedCollaborationExtension) {
            try {
                XmppEncodedCollaborationExtension ce = (XmppEncodedCollaborationExtension)ext;
                Map<String, String> bodies = Utils.parsePayloads(this.encoder().decode(ce.getPayload()));
                this.showPayloads(bodies);
                PayloadCollection payloads = PayloadCollection.create(this.createUniqueMessageID(from, msg.getPacketID()), p, bodies, date);
                if (!payloads.isEmpty()) {
                    this.firePayloadReceived(payloads);
                }
            }
            catch (CollaborationException ex) {
                this.fireMessage(LogMessageLevel.Warning, ex.getMessage());
                NormalException.showStackTrace((Throwable)((Object)ex));
            }
            catch (ReplayDetectedException ex) {
                this.fireMessage(LogMessageLevel.Warning, "A replay attack was detected and prevented from " + p.getName());
                NormalException.showStackTrace((Throwable)((Object)ex));
            }
            catch (GeneralSecurityException ex) {
                this._validKey = false;
                NormalException.logStackTrace((Throwable)ex);
            }
            catch (WrongVersionException ex) {
                this._validVersion = false;
                NormalException.showStackTrace((Throwable)((Object)ex));
            }
        }
        if ((body = msg.getBody()) == null && (subject = msg.getSubject()) != null) {
            String name = p.getName();
            this.fireSessionIDChanged(new SessionID(subject, from, name, date));
        }
    }

    private void firePayloadReceived(PayloadCollection payloads) {
        for (Map.Entry<String, Collection<CollaborationPayloadListener>> entry : this._payloadListeners.entrySet()) {
            payloads.ofType(entry.getKey());
        }
        this.firePayloadReceived("*", payloads);
        for (Payload payload : payloads) {
            this.firePayloadReceived(payload.getType(), payloads);
        }
    }

    private void firePayloadReceived(String queryType, PayloadCollection payloads) {
        Collection<CollaborationPayloadListener> listeners = this._payloadListeners.get(queryType);
        if (listeners != null) {
            for (CollaborationPayloadListener listener : listeners) {
                listener.payloadReceived(payloads);
            }
        }
    }

    private void fireMessage(LogMessageLevel level, String message) {
        for (CollaborationMessageListener listener : this._messageListeners) {
            listener.message(level, message);
        }
    }

    private void fireParticipantEvent(ParticipantEvent evt) {
        for (CollaborationParticipantListener listener : this._participantListeners) {
            listener.participantEventReceived(evt);
        }
    }

    private void fireConnectionDropped(Exception e) {
        for (CollaborationSessionListener listener : this._sessionListeners) {
            listener.connectionDropped(e);
        }
    }

    private void fireSessionIDChanged(SessionID sessionID) {
        for (CollaborationSessionListener listener : this._sessionListeners) {
            listener.sessionIDChanged(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Participant getParticipant(String from) {
        Map<String, Participant> map = this._participants;
        synchronized (map) {
            return this._participants.get(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void presenceUpdated(Participant participant, ParticipantPresence presence, RoomStatusCode status) {
        boolean changed = false;
        boolean joined = false;
        boolean left = false;
        Map<String, Participant> map = this._participants;
        synchronized (map) {
            if (participant.isMe()) {
                this._me = participant;
            }
            if (this._participants.containsKey(participant.getID())) {
                changed = true;
                if (presence == ParticipantPresence.Offline) {
                    left = true;
                    this._participants.remove(participant.getID());
                }
            } else {
                this._participants.put(participant.getID(), participant);
                joined = true;
            }
        }
        if (changed) {
            this.fireParticipantEvent(ParticipantEvent.getChanged(participant, presence, status));
        }
        if (left) {
            this.fireParticipantEvent(ParticipantEvent.getLeft(participant));
        }
        if (joined) {
            this.fireParticipantEvent(ParticipantEvent.getJoined(participant, presence, status));
        }
    }

    private ParticipantPresence getParticipantPresence(Presence presence) {
        switch (presence.getType()) {
            case available: {
                ParticipantPresence pp;
                if (presence.getMode() != null) {
                    switch (presence.getMode()) {
                        case available: {
                            pp = ParticipantPresence.Available;
                            break;
                        }
                        case away: 
                        case xa: {
                            pp = ParticipantPresence.Away;
                            break;
                        }
                        case dnd: {
                            pp = ParticipantPresence.Busy;
                            break;
                        }
                        default: {
                            pp = ParticipantPresence.Offline;
                            break;
                        }
                    }
                } else {
                    pp = ParticipantPresence.Available;
                }
                return pp;
            }
            case unavailable: {
                return ParticipantPresence.Offline;
            }
            case error: {
                return ParticipantPresence.Error;
            }
        }
        return ParticipantPresence.Offline;
    }

    private Presence getPresence(ParticipantPresence participantPresence) {
        Presence.Mode mode;
        Presence.Type type;
        switch (participantPresence) {
            case Available: {
                type = Presence.Type.available;
                mode = Presence.Mode.available;
                break;
            }
            case Away: {
                type = Presence.Type.available;
                mode = Presence.Mode.away;
                break;
            }
            case Busy: {
                type = Presence.Type.available;
                mode = Presence.Mode.dnd;
                break;
            }
            case Error: {
                type = Presence.Type.error;
                mode = Presence.Mode.available;
                break;
            }
            case Offline: {
                type = Presence.Type.unavailable;
                mode = Presence.Mode.available;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such presence " + (Object)((Object)participantPresence));
            }
        }
        Presence presence = new Presence(type);
        presence.setMode(mode);
        presence.setFrom(Utils.getMyJid(this._info));
        presence.setTo(Utils.getConferenceRoom(this._info));
        return presence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Participant> getOtherParticipants() {
        Map<String, Participant> map = this._participants;
        synchronized (map) {
            ArrayList<Participant> participants = new ArrayList<Participant>();
            for (Participant p : this._participants.values()) {
                if (p.isMe()) continue;
                participants.add(p);
            }
            return participants;
        }
    }

    @Override
    public void updateStatus(ParticipantPresence presence, String message) {
        this._statusMessage = message;
        Presence p = this.getPresence(presence);
        p.setTo(this._muc.getRoom());
        this.addPresenceExtension((Packet)p);
        this._cn.sendPacket((Packet)p);
    }

    private void showPayloads(Map<String, String> bodies) {
        for (Map.Entry<String, String> entry : bodies.entrySet()) {
        }
    }

    @Override
    public boolean isKeyValid() {
        return this._validKey;
    }

    @Override
    public boolean isVersionValid() {
        return this._validVersion;
    }

    private void addPresenceExtension(Packet packet) {
        try {
            if (packet.getExtension(COLLAB_ELEMENT, COLLAB_NS) == null) {
                HashMap<String, String> attributes = new HashMap<String, String>(3);
                Version v = Version.getCurrent();
                String productName = System.getProperty("maltego.product-name", "Maltego");
                attributes.put("v", v.toString(false, false, false));
                attributes.put("prod", productName);
                if (!StringUtilities.isNullOrEmpty((String)this._statusMessage)) {
                    attributes.put("tag", this._statusMessage);
                }
                packet.addExtension((PacketExtension)this.createExtension(PayloadHelper.createPayload(PARTICIPANT_INFO, attributes, this._info.getAlias())));
            }
        }
        catch (Exception ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
    }

    private XmppEncodedCollaborationExtension createExtension(String payload) throws CollaborationException {
        return new XmppEncodedCollaborationExtension(Utils.createEncodedContent(this.encoder(), payload));
    }

    static {
        ProviderManager.getInstance().addExtensionProvider(COLLAB_ELEMENT, COLLAB_NS, (Object)new XmppCollaborationExtensionProvider());
    }

    private class MessageListener
    implements PacketListener {
        private MessageListener() {
        }

        public void processPacket(Packet packet) {
            try {
                if (packet instanceof Message) {
                    Message message = (Message)packet;
                    XmppCollaborationSession.this.handleIncomingMessage(message);
                }
            }
            catch (Exception e) {
                NormalException.showStackTrace((Throwable)e);
            }
        }
    }

    private class PresenceInterceptor
    implements PacketInterceptor {
        private PresenceInterceptor() {
        }

        public void interceptPacket(Packet packet) {
            XmppCollaborationSession.this.addPresenceExtension(packet);
        }
    }

    private class ParticipantStatusHandler
    implements ParticipantStatusListener {
        private ParticipantStatusHandler() {
        }

        public void joined(String participant) {
        }

        public void left(String participant) {
        }

        public void kicked(String participant, String actor, String reason) {
        }

        public void voiceGranted(String participant) {
        }

        public void voiceRevoked(String participant) {
        }

        public void banned(String participant, String actor, String reason) {
        }

        public void membershipGranted(String participant) {
        }

        public void membershipRevoked(String participant) {
        }

        public void moderatorGranted(String participant) {
        }

        public void moderatorRevoked(String participant) {
        }

        public void ownershipGranted(String participant) {
        }

        public void ownershipRevoked(String participant) {
        }

        public void adminGranted(String participant) {
        }

        public void adminRevoked(String participant) {
        }

        public void nicknameChanged(String participant, String nick) {
        }
    }

    private class PresenceListener
    implements PacketListener {
        private static final String STATUS_ROOM_CREATED = "201";
        private static final String STATUS_ROOM_EXISTS = "110";

        private PresenceListener() {
        }

        public void processPacket(Packet packet) {
            try {
                if (packet instanceof Presence) {
                    Presence presence = (Presence)packet;
                    PacketExtension collab = presence.getExtension(XmppCollaborationSession.COLLAB_ELEMENT, XmppCollaborationSession.COLLAB_NS);
                    PacketExtension mucUser = packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                    if (collab instanceof XmppEncodedCollaborationExtension) {
                        HashMap<String, String> attributes;
                        String alias;
                        XmppEncodedCollaborationExtension ce = (XmppEncodedCollaborationExtension)collab;
                        Map<String, String> payloads = Utils.parsePayloads(XmppCollaborationSession.this.encoder().decode(ce.getPayload()));
                        String payload = payloads.get(XmppCollaborationSession.PARTICIPANT_INFO);
                        if (payload != null && (alias = PayloadHelper.getBody(XmppCollaborationSession.PARTICIPANT_INFO, payload, attributes = new HashMap<String, String>(), true)) != null) {
                            Participant participant = new Participant(packet.getFrom(), alias, Utils.getMyJid(XmppCollaborationSession.this._info).equals(packet.getFrom()));
                            participant.putProperties(attributes);
                            ParticipantPresence participantPresence = XmppCollaborationSession.this.getParticipantPresence(presence);
                            XmppCollaborationSession.this.presenceUpdated(participant, participantPresence, this.parseStatus(mucUser));
                        }
                    }
                }
            }
            catch (GeneralSecurityException ex) {
                XmppCollaborationSession.this._validKey = false;
                NormalException.logStackTrace((Throwable)ex);
            }
            catch (WrongVersionException ex) {
                XmppCollaborationSession.this._validVersion = false;
                NormalException.showStackTrace((Throwable)((Object)ex));
            }
            catch (Exception ex) {
                XmppCollaborationSession.this.fireMessage(LogMessageLevel.Warning, ex.getMessage());
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        private RoomStatusCode parseStatus(PacketExtension ext) {
            MUCUser.Status status;
            if (ext instanceof MUCUser && (status = ((MUCUser)ext).getStatus()) != null) {
                if (STATUS_ROOM_CREATED.equals(status.getCode())) {
                    return RoomStatusCode.RoomCreated;
                }
                if (STATUS_ROOM_EXISTS.equals(status.getCode())) {
                    return RoomStatusCode.RoomExists;
                }
                System.out.println("Unknown room status code: " + status.getCode());
            }
            return RoomStatusCode.None;
        }
    }

    private class XmppConnectionListener
    implements ConnectionListener {
        private XmppConnectionListener() {
        }

        public void connectionClosed() {
            XmppCollaborationSession.this.fireConnectionDropped(null);
        }

        public void connectionClosedOnError(Exception excptn) {
            XmppCollaborationSession.this.fireConnectionDropped(excptn);
        }

        public void reconnectingIn(int i) {
            System.out.println("RECONNECTING in " + i);
        }

        public void reconnectionSuccessful() {
            System.out.println("RECONNECED");
        }

        public void reconnectionFailed(Exception excptn) {
            System.out.println("RECONNECTING failed " + excptn);
        }
    }

    private class SessionIDChangeListener
    implements SubjectUpdatedListener {
        private SessionIDChangeListener() {
        }

        public void subjectUpdated(String subject, String from) {
            String name = null;
            Participant p = XmppCollaborationSession.this.getParticipant(from);
            if (p != null) {
                name = p.getName();
            }
            XmppCollaborationSession.this.fireSessionIDChanged(new SessionID(subject, from, name, new Date()));
        }
    }
}

