/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.rest;

import com.paterva.maltego.util.MachineIDProvider;
import com.paterva.maltego.util.MaltegoHelper;
import com.paterva.maltego.util.Version;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class StandardRestEntries {
    private static final Random RAND = new Random();

    public static Map<String, String> get(String apiKey, boolean machineIDsAppendRnd) {
        Version ver = Version.getCurrent();
        String nonce = Integer.toString(Math.abs(RAND.nextInt()));
        String time = Long.toString(System.currentTimeMillis());
        String version = ver.toString(false, true, false);
        String subtitle = ver.getSubtitle();
        String oem = ver.getOem();
        String country = MaltegoHelper.getCountry();
        String platformArch = MaltegoHelper.getOSArch();
        String platformName = MaltegoHelper.getOSName();
        String platformVersion = MaltegoHelper.getOSVersion();
        String javaVersion = MaltegoHelper.getJavaVersion();
        String[] machineIDs = MachineIDProvider.getDefault().getIDCandidates(machineIDsAppendRnd);
        String machineIDsStr = Arrays.stream(machineIDs).collect(Collectors.joining(","));
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        entries.put("Nonce", nonce);
        entries.put("Time", time);
        entries.put("ApiKey", apiKey);
        entries.put("MachineIDs", machineIDsStr);
        entries.put("ProductName", Version.getCurrent().toString(true, false, true));
        entries.put("Version", version);
        entries.put("Subtitle", subtitle);
        entries.put("OEM", oem);
        entries.put("PlatformArch", platformArch);
        entries.put("PlatformName", platformName);
        entries.put("PlatformVersion", platformVersion);
        entries.put("JavaVersion", javaVersion);
        return entries;
    }
}

