/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.manager;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.manager.EditMappingForm;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class ShowEditMappingAction
extends CallableSystemAction {
    TabularGraph _mappingToEdit;

    public boolean asynchronous() {
        return false;
    }

    public void performAction(TabularGraph mapping) {
        this._mappingToEdit = mapping;
        this.performAction();
    }

    public void performAction() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.performImpl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ShowEditMappingAction.this.performImpl();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void performImpl() {
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        EditMappingForm form = new EditMappingForm(okButton);
        form.setMappingName(this._mappingToEdit.getName());
        form.setMappingDescription(this._mappingToEdit.getDescription());
        DialogDescriptor dd = new DialogDescriptor((Object)form, "Edit Mapping", true, (Object[])new JButton[]{okButton, cancelButton}, (Object)cancelButton, 0, HelpCtx.DEFAULT_HELP, null);
        Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (notify.equals(okButton) && form.isNewNameValid()) {
            if (form.nameHasChanged()) {
                this.updateMapping(form.getMappingName(), form.getMappingDescription());
            } else if (form.descriptionHasChanged()) {
                this.updateMapping(form.getMappingDescription());
            }
        }
    }

    public String getName() {
        return "Edit mapping...";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void updateMapping(String newDescription) {
        this._mappingToEdit.setDescription(newDescription);
        MappingRegistry.getDefault().put(this._mappingToEdit);
    }

    private void updateMapping(String newName, String newDescription) {
        MappingRegistry registry = MappingRegistry.getDefault();
        registry.remove(this._mappingToEdit.getName());
        this._mappingToEdit.setName(newName);
        this._mappingToEdit.setDescription(newDescription);
        registry.put(this._mappingToEdit);
    }
}

