/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.FormattedConverter;
import java.awt.Component;
import java.text.Format;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class FormattingListCellRenderer
extends JLabel
implements ListCellRenderer {
    private Format _format;

    public FormattingListCellRenderer(Format format) {
        this._format = format;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            this.setText("");
        } else {
            String text = FormattedConverter.convertTo((Object)value, value.getClass(), (Format)this._format);
            this.setText(text);
        }
        return this;
    }
}

