/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphMods {
    private GraphDataMods _dataMods;
    private GraphStructureMods _structureMods;
    private GraphLayoutMods _layoutMods;

    public GraphDataMods getDataMods() {
        return this._dataMods;
    }

    public void setDataMods(GraphDataMods dataMods) {
        if (this._dataMods != null) {
            throw new IllegalStateException("Data mods already set");
        }
        this._dataMods = dataMods;
    }

    public GraphStructureMods getStructureMods() {
        return this._structureMods;
    }

    public void setStructureMods(GraphStructureMods structureMods) {
        if (this._structureMods != null) {
            throw new IllegalStateException("Structure mods already set");
        }
        this._structureMods = structureMods;
    }

    public GraphLayoutMods getLayoutMods() {
        return this._layoutMods;
    }

    public void setLayoutMods(GraphLayoutMods layoutMods) {
        if (this._layoutMods != null) {
            throw new IllegalStateException("Layout mods already set");
        }
        this._layoutMods = layoutMods;
    }

    public boolean isEmpty() {
        return !(this._dataMods != null && !this._dataMods.isEmpty() || this._structureMods != null && !this._structureMods.isEmpty() || this._layoutMods != null && !this._layoutMods.isEmpty());
    }

    public void mergeMods() {
        if (this._structureMods != null) {
            Set<EntityID> entitiesRemoved = this._structureMods.getEntitiesRemoved();
            Map<LinkID, LinkEntityIDs> linksRemoved = this._structureMods.getLinksRemoved();
            if (!entitiesRemoved.isEmpty() || !linksRemoved.isEmpty()) {
                if (this._dataMods != null && !this._dataMods.isEmpty()) {
                    this._dataMods = this.removeRemovedParts(this._dataMods, entitiesRemoved, linksRemoved);
                }
                if (this._layoutMods != null && !this._layoutMods.isEmpty()) {
                    this._layoutMods = this.removeRemovedParts(this._layoutMods, entitiesRemoved, linksRemoved);
                }
            }
        }
    }

    private GraphDataMods removeRemovedParts(GraphDataMods dataMods, Set<EntityID> entitiesRemoved, Map<LinkID, LinkEntityIDs> linksRemoved) {
        GraphDataMods newDataMods = new GraphDataMods();
        Map<EntityID, MaltegoEntity> entitiesUpdated = newDataMods.getEntitiesUpdated();
        for (Map.Entry<EntityID, MaltegoEntity> entry : dataMods.getEntitiesUpdated().entrySet()) {
            EntityID entityID = entry.getKey();
            MaltegoEntity entity = entry.getValue();
            if (entitiesRemoved.contains(entityID)) continue;
            entitiesUpdated.put(entityID, entity);
        }
        Map<LinkID, MaltegoLink> linksUpdated = newDataMods.getLinksUpdated();
        for (Map.Entry<LinkID, MaltegoLink> entry : dataMods.getLinksUpdated().entrySet()) {
            LinkID linkID = entry.getKey();
            MaltegoLink link = entry.getValue();
            if (linksRemoved.containsKey(linkID)) continue;
            linksUpdated.put(linkID, link);
        }
        newDataMods.makeReadOnly();
        return newDataMods;
    }

    private GraphLayoutMods removeRemovedParts(GraphLayoutMods layoutMods, Set<EntityID> entitiesRemoved, Map<LinkID, LinkEntityIDs> linksRemoved) {
        GraphLayoutMods newLayoutMods = new GraphLayoutMods();
        Map<EntityID, Point> centers = newLayoutMods.getCenters();
        for (Map.Entry<EntityID, Point> entry : layoutMods.getCenters().entrySet()) {
            EntityID entityID = entry.getKey();
            Point center = entry.getValue();
            if (entitiesRemoved.contains(entityID)) continue;
            centers.put(entityID, center);
        }
        Map<LinkID, List<Point>> paths = newLayoutMods.getPaths();
        for (Map.Entry<LinkID, List<Point>> entry : layoutMods.getPaths().entrySet()) {
            LinkID linkID = entry.getKey();
            List<Point> path = entry.getValue();
            if (linksRemoved.containsKey(linkID)) continue;
            paths.put(linkID, path);
        }
        newLayoutMods.makeReadOnly();
        return newLayoutMods;
    }

    public String toString() {
        return "GraphMods{\n   data=" + this._dataMods + ",\n   structure=" + this._structureMods + ",\n   layout=" + this._layoutMods + "\n}";
    }
}

