/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui.prompt;

import com.maltego.recovery.ui.BackupMetadata;
import com.maltego.recovery.ui.BackupSerializer;
import com.maltego.recovery.ui.prompt.RecoveryProgressPanel;
import com.maltego.recovery.ui.prompt.RecoveryPromptPanel;
import com.paterva.maltego.archive.mtz.GraphFileFilter;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStoreCache;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class RecoveryPrompt {
    private static final String CLOSE_OPTION = "Close";
    private static final String SAVE_OPTION = "Save";
    private static final String CANCEL_OPTION = "Cancel";
    private static final String TITLE = "Graph Recovery";
    private static final DateFormat RECOVERY_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
    private Dialog recoveryDialog = null;
    private Dialog progressDialog = null;
    private CompletableFuture<Void> asyncRecoveryTask = null;

    public void show(List<BackupMetadata> backups) {
        backups.forEach(metadata -> metadata.setSelectedForRecovery(true));
        RecoveryPromptPanel control = new RecoveryPromptPanel(backups);
        DialogDescriptor dd = new DialogDescriptor((Object)control, TITLE, true, new Object[]{CLOSE_OPTION, SAVE_OPTION}, (Object)SAVE_OPTION, 0, null, e -> {
            if (CLOSE_OPTION.equals(e.getSource())) {
                if (this.showAbandonRecoveryConfirmation()) {
                    this.disposeAndClearBackups();
                }
                return;
            }
            List<String> discardedGraphs = this.extractDiscardedGraphs(backups);
            if (discardedGraphs.size() == backups.size()) {
                this.showNoBackupSelectedMessage();
                return;
            }
            if (discardedGraphs.isEmpty() || this.showDiscardedGraphsConfirmation(discardedGraphs)) {
                backups.stream().filter(metadata -> {
                    boolean selectedForRecoveryAndNotAlreadyRecovered = metadata.isSelectedForRecovery() && !metadata.isRecoveredSuccessfully();
                    return selectedForRecoveryAndNotAlreadyRecovered;
                }).forEach(this::recoverGraph);
                if (this.checkAllSelectedGraphsRecovered(backups)) {
                    this.disposeAndClearBackups();
                }
            }
        });
        dd.setNoDefaultClose(true);
        this.recoveryDialog = DialogDisplayer.getDefault().createDialog(dd);
        this.recoveryDialog.setMinimumSize(control.getSize());
        this.recoveryDialog.setVisible(true);
    }

    private void disposeAndClearBackups() {
        if (this.recoveryDialog != null) {
            this.recoveryDialog.dispose();
            this.recoveryDialog = null;
        }
        GraphStoreCache.clear();
    }

    private List<String> extractDiscardedGraphs(List<BackupMetadata> backups) {
        return backups.stream().filter(metadata -> !metadata.isSelectedForRecovery()).map(metadata -> metadata.getName()).collect(Collectors.toList());
    }

    private void recoverGraph(BackupMetadata metadata) {
        File selectedFile = this.showRecoveryPathSelection(metadata);
        if (selectedFile == null) {
            return;
        }
        RecoveryProgressPanel panel = new RecoveryProgressPanel(metadata.getName());
        DialogDescriptor dd = new DialogDescriptor((Object)panel, TITLE, true, new Object[]{CANCEL_OPTION}, null, 0, null, evt -> {
            if (this.asyncRecoveryTask != null) {
                this.asyncRecoveryTask.cancel(true);
            }
            this.progressDialog.dispose();
        });
        dd.setTitle(TITLE);
        dd.setNoDefaultClose(true);
        this.progressDialog = DialogDisplayer.getDefault().createDialog(dd);
        this.asyncRecoveryTask = CompletableFuture.runAsync(() -> {
            try {
                GraphID graphID = GraphID.parse((String)metadata.getGraphID());
                BackupSerializer backupSerializer = new BackupSerializer(graphID, metadata.getFileType());
                backupSerializer.recoverGraph(selectedFile);
                metadata.setRecoveredSuccessfully(true);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.showRecoveryError(metadata.getName());
            }
            finally {
                SwingUtilities.invokeLater(() -> this.progressDialog.dispose());
            }
        });
        this.progressDialog.setVisible(true);
    }

    private File showRecoveryPathSelection(BackupMetadata metadata) {
        String title = "Recover \"" + metadata.getName() + "\"";
        FileChooserBuilder chooser = new FileChooserBuilder(RecoveryPrompt.class).setTitle(title);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addFileFilter((FileFilter)new GraphFileFilter(GraphFileType.PANDORA));
        JFileChooser fileChooser = chooser.createFileChooser();
        fileChooser.setFileSelectionMode(0);
        String filepath = metadata.getFilepath();
        String recoveryPostfix = " (recovered at " + RECOVERY_DATE_FORMAT.format(metadata.getLastBackupTime()) + ")";
        if (filepath == null) {
            String userHomeDir = System.getProperty("user.home");
            fileChooser.setSelectedFile(new File(userHomeDir, metadata.getName() + recoveryPostfix));
        } else {
            String extension = "." + metadata.getFileType().getExtension();
            filepath = filepath.endsWith(extension) ? filepath.replace(extension, recoveryPostfix + extension) : filepath + recoveryPostfix;
            fileChooser.setSelectedFile(new File(filepath));
        }
        Window parentComponent = this.recoveryDialog;
        if (parentComponent == null) {
            parentComponent = WindowManager.getDefault().getMainWindow();
        }
        File selectedFile = null;
        while (selectedFile == null) {
            int showSaveDialogResult = fileChooser.showSaveDialog(parentComponent);
            if (showSaveDialogResult == 0) {
                File file;
                GraphFileFilter selectedFilter = (GraphFileFilter)fileChooser.getFileFilter();
                GraphFileType selectedType = selectedFilter.getType();
                String extension = selectedType.getExtension();
                File f = fileChooser.getSelectedFile();
                File parentFile = f.getParentFile();
                String filename = f.getName();
                if (!filename.toLowerCase().endsWith("." + extension.toLowerCase())) {
                    filename = filename + "." + extension;
                }
                if ((file = new File(parentFile, filename)).exists()) {
                    String overwriteMessage = String.format("The file %s already exists.\nDo you want to overwrite it?", filename);
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)overwriteMessage, TITLE, 0);
                    Object userChose = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (!NotifyDescriptor.YES_OPTION.equals(userChose)) continue;
                    selectedFile = file;
                    continue;
                }
                selectedFile = file;
                continue;
            }
            boolean recoveryCancelled = this.showFileChooserCancelledConfirmation(metadata.getName());
            if (!recoveryCancelled) continue;
            break;
        }
        return selectedFile;
    }

    private boolean showAbandonRecoveryConfirmation() {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)"All unsaved graphs will be discarded. Are you sure to abandon Graph Recovery?", TITLE, 0);
        Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return NotifyDescriptor.YES_OPTION.equals(notify);
    }

    private void showNoBackupSelectedMessage() {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"No graph is selected for recovery", 2);
        message.setTitle(TITLE);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private boolean showDiscardedGraphsConfirmation(List<String> discardedGraphs) {
        StringBuilder messageBuilder = new StringBuilder("The following graphs are not selected for recovery \u2013 these temporary files will be discarded if not saved. Are you sure to continue with the current selection?\n");
        for (String graphName : discardedGraphs) {
            messageBuilder.append("\n").append(graphName);
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)messageBuilder.toString(), TITLE, 0);
        Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return NotifyDescriptor.YES_OPTION.equals(notify);
    }

    private boolean showFileChooserCancelledConfirmation(String graphName) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)String.format("Do you want to abort recovery for graph \"%s\"? The graph will be discarded.", graphName), TITLE, 0);
        Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return NotifyDescriptor.YES_OPTION.equals(notify);
    }

    private void showRecoveryError(String graphName) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)String.format("Error while saving the graph \"%s\"", graphName), 0);
        message.setTitle(TITLE);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private boolean checkAllSelectedGraphsRecovered(List<BackupMetadata> backups) {
        for (BackupMetadata metadata : backups) {
            if (!metadata.isSelectedForRecovery() || metadata.isRecoveredSuccessfully()) continue;
            return false;
        }
        return true;
    }
}

