---
myst:
  html_meta:
    keywords: LaTeX, domaine spécialisés, quotidien, taches de café, crasse,
              salir un document, maculer un document LaTeX, amusement, jeux, 
              fun
---

# LaTeX peut-il faire le café ?

LaTeX est sans doute capable de faire le café et même de le boire, 
puisqu'il sait faire des taches de café sur vos documents !


## Avec l'extension <ctanpkg:coffeestains>

L'extension <ctanpkg:coffeestains> est une version réimplémentée en 
[TikZ](ctanpkg:PGF) par [Evan Sultanik](https://www.sultanik.com/) 
de l'extension 
[coffee](http://legacy.hanno-rein.de/hanno-rein.de/archives/349), 
évoquée ci-après. Cette version est complétée par des contributions 
de Luis Randez et d'Adrian Robson.

Un *fork* est présent sur GitHub, sous le nom de
[latex-coffee-stains](https://github.com/barak/latex-coffee-stains), 
avec des contributions de Barak A. Pearlmutter, Anthony Mirand et 
Sebastian Schmittner. *A contrario* de l'extension CTAN, il ne dispose pas
de documentation.

La syntaxe de base est :

```{noedit}
\coffeestainA{⟨alpha⟩}{⟨échelle⟩}{⟨angle⟩}{⟨coordx⟩}{⟨coordy⟩}
```

Les variables suivent les définitions suivantes :

- `⟨alpha⟩` est la transparence, soit un nombre entre 0 et 1 (1 donnant 
  une tache de café complètement opaque ; 0 une tache complètement transparente
  et invisible) ;
- `⟨échelle⟩` est l'échelle (valeur standard : 1) ;
- `⟨angle⟩` est l'angle de rotation de la tache, en degrés d'angle ;
- `⟨coordx⟩` et `⟨coordy⟩` sont les coordonnées horizontale et verticale 
  par rapport au centre de la page, passées comme longueurs.

Quatre commandes sont disponibles, pour dessiner quatre formes de taches :

| Commande        | Apparence                                                  |
|-----------------|------------------------------------------------------------|
| `\coffeestainA` | Grand arc de cercle avec deux petites gouttes              |
| `\coffeestainB` | Petit arc de cercle                                        |
| `\coffeestainC` | Deux grosses éclaboussures de couleur claire               |
| `\coffeestainD` | Grosse tache colorée, avec des éclaboussures en périphérie |


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux-texte
  \usepackage[width=9cm,height=9cm]{geometry}
  \usepackage{coffeestains}

\begin{document}
\lipsum[1]

\coffeestainA{0.6}{0.8}{0}{0cm}{5cm}
%\coffeestainC{0.4}{0.6}{0}{-1cm}{-3cm}
\end{document}
```


### Cas particulier de taches sur chaque page

Il est possible d’ajouter des taches aléatoires sur toutes les pages 
du document, le code ci-dessous fixe la graine du générateur aléatoire 
pour reproductibilité (si cette graine était choisie aléatoirement, 
comme indiqué en commentaire de code, LaTeX redemanderait à chaque fois
une compilation supplémentaire) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux-texte
  \usepackage{coffeestains}

  \pgfmathsetseed{271828}
  \AddToHook{shipout/background}{
    %\pgfmathsetseed{\pdfuniformdeviate 10000000}% si on fait cela 
                                                 % le .aux ne stabilise pas
    \pgfmathdeclarerandomlist{scales}{{0.5}{0.7}{1.0}{1.4}}
    \pgfmathdeclarerandomlist{stains}{%
      {\coffeestainA}{\coffeestainB}{\coffeestainC}{\coffeestainD}}
    \pgfmathrandominteger{\angle}{15}{350}%
    \pgfmathparse{rand/2.4}\xdef\xoffset{\pgfmathresult}%
    \pgfmathparse{rand/2.4}\xdef\yoffset{\pgfmathresult}%
    \pgfmathparse{(0.1 + rnd/3)}\xdef\trans{\pgfmathresult}%
    \pgfmathrandomitem{\scale}{scales}%
    \pgfmathrandomitem{\stain}{stains}%
    \stain{\trans}\scale\angle{\xoffset\textwidth}{\yoffset\textheight}%
  }

\begin{document}
\lipsum[1-10]
\end{document}
```


## Avec l'extension [coffee](http://legacy.hanno-rein.de/hanno-rein.de/archives/349)

L'extension [coffee](http://legacy.hanno-rein.de/hanno-rein.de/archives/349), 
de [Hanno Rein](https://hanno-rein.de/), utilise de véritables taches de café
(marques de tasses et éclaboussures), qui ont été photographiées puis 
retouchées sous Gimp et redessinées avec <ctanpkg:PSTricks>, pour orner 
vos pages.

:::{todo} Ajouter un exemple
:::


:::{sources}
- [Are there other "fun" packages like the "coffee stains" package?](https://tex.stackexchange.com/a/67671), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Coffee (and wine (and nicotine)) stains on an entire document](https://tex.stackexchange.com/q/237557), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [LaTeX Coffee Stains](http://legacy.hanno-rein.de/hanno-rein.de/archives/349)
- [latex-coffee-stains](https://github.com/barak/latex-coffee-stains), 
  sur [GitHub](https://github.com/)
:::