---
myst:
  html_meta:
    keywords: LaTeX, généralités, bases, TeX, prononciation,
              prononciation en français
---

# Comment prononcer TeX ou LaTeX ?

## Cas de TeX

Le "X" est en fait la lettre grecque chi (χ) ; elle est donc prononcée
par les anglophones soit comme le "ch" du mot écossais *loch* (un peu 
comme une *jota* espagnole, son noté [x] en alphabet phonétique 
international) soit comme un "K". Les francophones préfèrent généralement
cette seconde option.

Ça ne doit de toute façon **jamais** être prononcé "ks" comme dans "textile".

L'explication de cette curieuse prononciation curieuse est données
par Donald Knuth dans son [TeXbook](ctanpkg:texbook) : le nom de son logiciel
vient du mot grec *τέχνη* qui veut dire "art" (au sens du savoir-faire 
de l'artisan) ou "technique" (dont il est l'origine étymologique).

Le logo TeX que Knuth a dessiné est simplement constitué 
des versions majuscules des trois premières lettres grecques du mot, tau, 
epsilon et chi (τ, ε, χ), un peu décalées verticalement (voir aussi 
[logos-latex](/3_composition/texte/symboles/logos/logos-latex)).


## Cas de LaTeX

Leslie Lamport n'a jamais donné de recommandation particulière 
pour la prononciation de *LaTeX* :

- en anglais, la plupart des gens prononcent "Lay-TeX" ou "Lah-TeX" 
  (voir ci-dessus pour la pronciation de TeX) ;
- en français, c'est "La-TeX". Dans tous les cas, ça ne se prononce **pas**
  comme le latex qui sert à faire les gants ou les pneus.


## Cas de LaTeXe

LaTeXe se termine par la lettre grecque epsilon (ε), mais la plupart des gens
choisissent de prononcer "LaTeX deux euh" en français (et en anglais : 
"LaTeX-two-ee").


## Cas de XeTeX

D'après son auteur original, Jonathan Kew, XeTeX se prononce \[ziːtɛk\].

Néanmoins, certains locuteurs francophones le pronconcent \[keːtɛk\] 
ou \[gzeːtɛk\].


:::{sources}
- [How should I pronounce "TeX"?](faquk:FAQ-TeXpronounce)
- [How should I pronounce "LaTeX2e"?](faquk:FAQ-latexpronounce)
- [What is the correct pronunciation of TeX and LaTeX?](https://tex.stackexchange.com/q/17502), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/) 
- [Proper pronunciation of XeTeX, XeLaTeX](https://tex.stackexchange.com/q/274617),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::