/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the MessagesIcsTextParameters type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MessagesIcsTextParameters{}

// MessagesIcsTextParameters struct for MessagesIcsTextParameters
type MessagesIcsTextParameters struct {
	// Cost to check that one number is constant – 0.04 in your account currency.
	Cost NullableFloat32 `json:"cost"`
	// Message parts (multiples of 160 characters) count.
	Parts NullableInt32 `json:"parts"`
	// Characters count.
	Chars NullableInt32 `json:"chars"`
	// Message charset. Could be: * **ISO-8859-1** – for plaintext SMS; * **UTF-16BE** – for Unicode SMS. 
	Encoding NullableString `json:"encoding"`
	Countries []string `json:"countries"`
	// Human-readable message charset label. Could be: *   **ISO-8859-1** for plaintext SMS; *   **UTF-16BE** for Unicode SMS; *   **Voice** for voice services (Text-to-Speech or Voice Broadcast) messages. 
	CharsetLabel NullableString `json:"charsetLabel"`
}

type _MessagesIcsTextParameters MessagesIcsTextParameters

// NewMessagesIcsTextParameters instantiates a new MessagesIcsTextParameters object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessagesIcsTextParameters(cost NullableFloat32, parts NullableInt32, chars NullableInt32, encoding NullableString, countries []string, charsetLabel NullableString) *MessagesIcsTextParameters {
	this := MessagesIcsTextParameters{}
	this.Cost = cost
	this.Parts = parts
	this.Chars = chars
	this.Encoding = encoding
	this.Countries = countries
	this.CharsetLabel = charsetLabel
	return &this
}

// NewMessagesIcsTextParametersWithDefaults instantiates a new MessagesIcsTextParameters object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessagesIcsTextParametersWithDefaults() *MessagesIcsTextParameters {
	this := MessagesIcsTextParameters{}
	return &this
}

// GetCost returns the Cost field value
// If the value is explicit nil, the zero value for float32 will be returned
func (o *MessagesIcsTextParameters) GetCost() float32 {
	if o == nil || o.Cost.Get() == nil {
		var ret float32
		return ret
	}

	return *o.Cost.Get()
}

// GetCostOk returns a tuple with the Cost field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcsTextParameters) GetCostOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Cost.Get(), o.Cost.IsSet()
}

// SetCost sets field value
func (o *MessagesIcsTextParameters) SetCost(v float32) {
	o.Cost.Set(&v)
}

// GetParts returns the Parts field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessagesIcsTextParameters) GetParts() int32 {
	if o == nil || o.Parts.Get() == nil {
		var ret int32
		return ret
	}

	return *o.Parts.Get()
}

// GetPartsOk returns a tuple with the Parts field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcsTextParameters) GetPartsOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Parts.Get(), o.Parts.IsSet()
}

// SetParts sets field value
func (o *MessagesIcsTextParameters) SetParts(v int32) {
	o.Parts.Set(&v)
}

// GetChars returns the Chars field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessagesIcsTextParameters) GetChars() int32 {
	if o == nil || o.Chars.Get() == nil {
		var ret int32
		return ret
	}

	return *o.Chars.Get()
}

// GetCharsOk returns a tuple with the Chars field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcsTextParameters) GetCharsOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Chars.Get(), o.Chars.IsSet()
}

// SetChars sets field value
func (o *MessagesIcsTextParameters) SetChars(v int32) {
	o.Chars.Set(&v)
}

// GetEncoding returns the Encoding field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessagesIcsTextParameters) GetEncoding() string {
	if o == nil || o.Encoding.Get() == nil {
		var ret string
		return ret
	}

	return *o.Encoding.Get()
}

// GetEncodingOk returns a tuple with the Encoding field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcsTextParameters) GetEncodingOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Encoding.Get(), o.Encoding.IsSet()
}

// SetEncoding sets field value
func (o *MessagesIcsTextParameters) SetEncoding(v string) {
	o.Encoding.Set(&v)
}

// GetCountries returns the Countries field value
// If the value is explicit nil, the zero value for []string will be returned
func (o *MessagesIcsTextParameters) GetCountries() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Countries
}

// GetCountriesOk returns a tuple with the Countries field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcsTextParameters) GetCountriesOk() ([]string, bool) {
	if o == nil || IsNil(o.Countries) {
		return nil, false
	}
	return o.Countries, true
}

// SetCountries sets field value
func (o *MessagesIcsTextParameters) SetCountries(v []string) {
	o.Countries = v
}

// GetCharsetLabel returns the CharsetLabel field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessagesIcsTextParameters) GetCharsetLabel() string {
	if o == nil || o.CharsetLabel.Get() == nil {
		var ret string
		return ret
	}

	return *o.CharsetLabel.Get()
}

// GetCharsetLabelOk returns a tuple with the CharsetLabel field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcsTextParameters) GetCharsetLabelOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CharsetLabel.Get(), o.CharsetLabel.IsSet()
}

// SetCharsetLabel sets field value
func (o *MessagesIcsTextParameters) SetCharsetLabel(v string) {
	o.CharsetLabel.Set(&v)
}

func (o MessagesIcsTextParameters) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MessagesIcsTextParameters) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["cost"] = o.Cost.Get()
	toSerialize["parts"] = o.Parts.Get()
	toSerialize["chars"] = o.Chars.Get()
	toSerialize["encoding"] = o.Encoding.Get()
	if o.Countries != nil {
		toSerialize["countries"] = o.Countries
	}
	toSerialize["charsetLabel"] = o.CharsetLabel.Get()
	return toSerialize, nil
}

func (o *MessagesIcsTextParameters) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"cost",
		"parts",
		"chars",
		"encoding",
		"countries",
		"charsetLabel",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varMessagesIcsTextParameters := _MessagesIcsTextParameters{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varMessagesIcsTextParameters)

	if err != nil {
		return err
	}

	*o = MessagesIcsTextParameters(varMessagesIcsTextParameters)

	return err
}

type NullableMessagesIcsTextParameters struct {
	value *MessagesIcsTextParameters
	isSet bool
}

func (v NullableMessagesIcsTextParameters) Get() *MessagesIcsTextParameters {
	return v.value
}

func (v *NullableMessagesIcsTextParameters) Set(val *MessagesIcsTextParameters) {
	v.value = val
	v.isSet = true
}

func (v NullableMessagesIcsTextParameters) IsSet() bool {
	return v.isSet
}

func (v *NullableMessagesIcsTextParameters) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessagesIcsTextParameters(val *MessagesIcsTextParameters) *NullableMessagesIcsTextParameters {
	return &NullableMessagesIcsTextParameters{value: val, isSet: true}
}

func (v NullableMessagesIcsTextParameters) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessagesIcsTextParameters) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


