/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the MessageOut type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MessageOut{}

// MessageOut struct for MessageOut
type MessageOut struct {
	// Message ID.
	Id int32 `json:"id"`
	// Message sender (phone number or alphanumeric Sender ID).
	Sender NullableString `json:"sender,omitempty"`
	// Recipient`s phone number.
	Receiver *string `json:"receiver,omitempty"`
	Text string `json:"text"`
	// Delivery status of the message. See [message delivery statuses](https://docs.textmagic.com/#section/Delivery-status-codes) for details. 
	Status string `json:"status"`
	// Rejection reason.
	RejectReason *string `json:"rejectReason,omitempty"`
	// Recipient contact ID.
	ContactId NullableInt32 `json:"contactId"`
	// Message Session ID of a message.
	SessionId NullableInt32 `json:"sessionId"`
	// Sending time.
	MessageTime time.Time `json:"messageTime"`
	Avatar NullableString `json:"avatar"`
	// Indicates that the message has been deleted.
	Deleted *bool `json:"deleted,omitempty"`
	// Message charset. Could be: *   **ISO-8859-1** for plaintext SMS; *   **UTF-16BE** for Unicode SMS. 
	Charset NullableString `json:"charset"`
	// Human-readable message charset label. Could be: *   **ISO-8859-1** for plaintext SMS; *   **UTF-16BE** for Unicode SMS; *   **Voice** for voice services (Text-to-Speech or Voice Broadcast) messages. 
	CharsetLabel NullableString `json:"charsetLabel"`
	// Contact first name. Could be substituted from your [Contacts](https://docs.textmagic.com/#tag/Contacts) (even if you submitted the phone number instead of the contact ID). 
	FirstName NullableString `json:"firstName"`
	// Contact last name.
	LastName NullableString `json:"lastName"`
	// The 2-letter ISO country code of the recipient's phone number. 
	Country NullableString `json:"country"`
	// Receipent`s phone number.
	Phone NullableString `json:"phone,omitempty"`
	// Message price.
	Price NullableFloat32 `json:"price,omitempty"`
	// Message parts (multiples of 160 characters) count.
	PartsCount NullableInt32 `json:"partsCount"`
	// The user email which this message came from. For Email2SMS and Distribution Lists the messages, it is an original email address - in other cases, it is an account email address.
	FromEmail NullableString `json:"fromEmail,omitempty"`
	// The Phone number used to send the SMS.
	FromNumber NullableString `json:"fromNumber,omitempty"`
	SenderSource *MessageOutSenderSource `json:"senderSource,omitempty"`
	Session *MessageOutSession `json:"session,omitempty"`
}

type _MessageOut MessageOut

// NewMessageOut instantiates a new MessageOut object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessageOut(id int32, text string, status string, contactId NullableInt32, sessionId NullableInt32, messageTime time.Time, avatar NullableString, charset NullableString, charsetLabel NullableString, firstName NullableString, lastName NullableString, country NullableString, partsCount NullableInt32) *MessageOut {
	this := MessageOut{}
	this.Id = id
	this.Text = text
	this.Status = status
	this.ContactId = contactId
	this.SessionId = sessionId
	this.MessageTime = messageTime
	this.Avatar = avatar
	this.Charset = charset
	this.CharsetLabel = charsetLabel
	this.FirstName = firstName
	this.LastName = lastName
	this.Country = country
	this.PartsCount = partsCount
	return &this
}

// NewMessageOutWithDefaults instantiates a new MessageOut object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessageOutWithDefaults() *MessageOut {
	this := MessageOut{}
	return &this
}

// GetId returns the Id field value
func (o *MessageOut) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *MessageOut) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *MessageOut) SetId(v int32) {
	o.Id = v
}

// GetSender returns the Sender field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageOut) GetSender() string {
	if o == nil || IsNil(o.Sender.Get()) {
		var ret string
		return ret
	}
	return *o.Sender.Get()
}

// GetSenderOk returns a tuple with the Sender field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetSenderOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sender.Get(), o.Sender.IsSet()
}

// HasSender returns a boolean if a field has been set.
func (o *MessageOut) HasSender() bool {
	if o != nil && o.Sender.IsSet() {
		return true
	}

	return false
}

// SetSender gets a reference to the given NullableString and assigns it to the Sender field.
func (o *MessageOut) SetSender(v string) {
	o.Sender.Set(&v)
}
// SetSenderNil sets the value for Sender to be an explicit nil
func (o *MessageOut) SetSenderNil() {
	o.Sender.Set(nil)
}

// UnsetSender ensures that no value is present for Sender, not even an explicit nil
func (o *MessageOut) UnsetSender() {
	o.Sender.Unset()
}

// GetReceiver returns the Receiver field value if set, zero value otherwise.
func (o *MessageOut) GetReceiver() string {
	if o == nil || IsNil(o.Receiver) {
		var ret string
		return ret
	}
	return *o.Receiver
}

// GetReceiverOk returns a tuple with the Receiver field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageOut) GetReceiverOk() (*string, bool) {
	if o == nil || IsNil(o.Receiver) {
		return nil, false
	}
	return o.Receiver, true
}

// HasReceiver returns a boolean if a field has been set.
func (o *MessageOut) HasReceiver() bool {
	if o != nil && !IsNil(o.Receiver) {
		return true
	}

	return false
}

// SetReceiver gets a reference to the given string and assigns it to the Receiver field.
func (o *MessageOut) SetReceiver(v string) {
	o.Receiver = &v
}

// GetText returns the Text field value
func (o *MessageOut) GetText() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Text
}

// GetTextOk returns a tuple with the Text field value
// and a boolean to check if the value has been set.
func (o *MessageOut) GetTextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Text, true
}

// SetText sets field value
func (o *MessageOut) SetText(v string) {
	o.Text = v
}

// GetStatus returns the Status field value
func (o *MessageOut) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *MessageOut) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *MessageOut) SetStatus(v string) {
	o.Status = v
}

// GetRejectReason returns the RejectReason field value if set, zero value otherwise.
func (o *MessageOut) GetRejectReason() string {
	if o == nil || IsNil(o.RejectReason) {
		var ret string
		return ret
	}
	return *o.RejectReason
}

// GetRejectReasonOk returns a tuple with the RejectReason field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageOut) GetRejectReasonOk() (*string, bool) {
	if o == nil || IsNil(o.RejectReason) {
		return nil, false
	}
	return o.RejectReason, true
}

// HasRejectReason returns a boolean if a field has been set.
func (o *MessageOut) HasRejectReason() bool {
	if o != nil && !IsNil(o.RejectReason) {
		return true
	}

	return false
}

// SetRejectReason gets a reference to the given string and assigns it to the RejectReason field.
func (o *MessageOut) SetRejectReason(v string) {
	o.RejectReason = &v
}

// GetContactId returns the ContactId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessageOut) GetContactId() int32 {
	if o == nil || o.ContactId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.ContactId.Get()
}

// GetContactIdOk returns a tuple with the ContactId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetContactIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ContactId.Get(), o.ContactId.IsSet()
}

// SetContactId sets field value
func (o *MessageOut) SetContactId(v int32) {
	o.ContactId.Set(&v)
}

// GetSessionId returns the SessionId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessageOut) GetSessionId() int32 {
	if o == nil || o.SessionId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.SessionId.Get()
}

// GetSessionIdOk returns a tuple with the SessionId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetSessionIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.SessionId.Get(), o.SessionId.IsSet()
}

// SetSessionId sets field value
func (o *MessageOut) SetSessionId(v int32) {
	o.SessionId.Set(&v)
}

// GetMessageTime returns the MessageTime field value
func (o *MessageOut) GetMessageTime() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.MessageTime
}

// GetMessageTimeOk returns a tuple with the MessageTime field value
// and a boolean to check if the value has been set.
func (o *MessageOut) GetMessageTimeOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.MessageTime, true
}

// SetMessageTime sets field value
func (o *MessageOut) SetMessageTime(v time.Time) {
	o.MessageTime = v
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageOut) GetAvatar() string {
	if o == nil || o.Avatar.Get() == nil {
		var ret string
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetAvatarOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *MessageOut) SetAvatar(v string) {
	o.Avatar.Set(&v)
}

// GetDeleted returns the Deleted field value if set, zero value otherwise.
func (o *MessageOut) GetDeleted() bool {
	if o == nil || IsNil(o.Deleted) {
		var ret bool
		return ret
	}
	return *o.Deleted
}

// GetDeletedOk returns a tuple with the Deleted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageOut) GetDeletedOk() (*bool, bool) {
	if o == nil || IsNil(o.Deleted) {
		return nil, false
	}
	return o.Deleted, true
}

// HasDeleted returns a boolean if a field has been set.
func (o *MessageOut) HasDeleted() bool {
	if o != nil && !IsNil(o.Deleted) {
		return true
	}

	return false
}

// SetDeleted gets a reference to the given bool and assigns it to the Deleted field.
func (o *MessageOut) SetDeleted(v bool) {
	o.Deleted = &v
}

// GetCharset returns the Charset field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageOut) GetCharset() string {
	if o == nil || o.Charset.Get() == nil {
		var ret string
		return ret
	}

	return *o.Charset.Get()
}

// GetCharsetOk returns a tuple with the Charset field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetCharsetOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Charset.Get(), o.Charset.IsSet()
}

// SetCharset sets field value
func (o *MessageOut) SetCharset(v string) {
	o.Charset.Set(&v)
}

// GetCharsetLabel returns the CharsetLabel field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageOut) GetCharsetLabel() string {
	if o == nil || o.CharsetLabel.Get() == nil {
		var ret string
		return ret
	}

	return *o.CharsetLabel.Get()
}

// GetCharsetLabelOk returns a tuple with the CharsetLabel field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetCharsetLabelOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CharsetLabel.Get(), o.CharsetLabel.IsSet()
}

// SetCharsetLabel sets field value
func (o *MessageOut) SetCharsetLabel(v string) {
	o.CharsetLabel.Set(&v)
}

// GetFirstName returns the FirstName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageOut) GetFirstName() string {
	if o == nil || o.FirstName.Get() == nil {
		var ret string
		return ret
	}

	return *o.FirstName.Get()
}

// GetFirstNameOk returns a tuple with the FirstName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetFirstNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FirstName.Get(), o.FirstName.IsSet()
}

// SetFirstName sets field value
func (o *MessageOut) SetFirstName(v string) {
	o.FirstName.Set(&v)
}

// GetLastName returns the LastName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageOut) GetLastName() string {
	if o == nil || o.LastName.Get() == nil {
		var ret string
		return ret
	}

	return *o.LastName.Get()
}

// GetLastNameOk returns a tuple with the LastName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetLastNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastName.Get(), o.LastName.IsSet()
}

// SetLastName sets field value
func (o *MessageOut) SetLastName(v string) {
	o.LastName.Set(&v)
}

// GetCountry returns the Country field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageOut) GetCountry() string {
	if o == nil || o.Country.Get() == nil {
		var ret string
		return ret
	}

	return *o.Country.Get()
}

// GetCountryOk returns a tuple with the Country field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetCountryOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Country.Get(), o.Country.IsSet()
}

// SetCountry sets field value
func (o *MessageOut) SetCountry(v string) {
	o.Country.Set(&v)
}

// GetPhone returns the Phone field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageOut) GetPhone() string {
	if o == nil || IsNil(o.Phone.Get()) {
		var ret string
		return ret
	}
	return *o.Phone.Get()
}

// GetPhoneOk returns a tuple with the Phone field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetPhoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Phone.Get(), o.Phone.IsSet()
}

// HasPhone returns a boolean if a field has been set.
func (o *MessageOut) HasPhone() bool {
	if o != nil && o.Phone.IsSet() {
		return true
	}

	return false
}

// SetPhone gets a reference to the given NullableString and assigns it to the Phone field.
func (o *MessageOut) SetPhone(v string) {
	o.Phone.Set(&v)
}
// SetPhoneNil sets the value for Phone to be an explicit nil
func (o *MessageOut) SetPhoneNil() {
	o.Phone.Set(nil)
}

// UnsetPhone ensures that no value is present for Phone, not even an explicit nil
func (o *MessageOut) UnsetPhone() {
	o.Phone.Unset()
}

// GetPrice returns the Price field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageOut) GetPrice() float32 {
	if o == nil || IsNil(o.Price.Get()) {
		var ret float32
		return ret
	}
	return *o.Price.Get()
}

// GetPriceOk returns a tuple with the Price field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetPriceOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Price.Get(), o.Price.IsSet()
}

// HasPrice returns a boolean if a field has been set.
func (o *MessageOut) HasPrice() bool {
	if o != nil && o.Price.IsSet() {
		return true
	}

	return false
}

// SetPrice gets a reference to the given NullableFloat32 and assigns it to the Price field.
func (o *MessageOut) SetPrice(v float32) {
	o.Price.Set(&v)
}
// SetPriceNil sets the value for Price to be an explicit nil
func (o *MessageOut) SetPriceNil() {
	o.Price.Set(nil)
}

// UnsetPrice ensures that no value is present for Price, not even an explicit nil
func (o *MessageOut) UnsetPrice() {
	o.Price.Unset()
}

// GetPartsCount returns the PartsCount field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessageOut) GetPartsCount() int32 {
	if o == nil || o.PartsCount.Get() == nil {
		var ret int32
		return ret
	}

	return *o.PartsCount.Get()
}

// GetPartsCountOk returns a tuple with the PartsCount field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetPartsCountOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.PartsCount.Get(), o.PartsCount.IsSet()
}

// SetPartsCount sets field value
func (o *MessageOut) SetPartsCount(v int32) {
	o.PartsCount.Set(&v)
}

// GetFromEmail returns the FromEmail field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageOut) GetFromEmail() string {
	if o == nil || IsNil(o.FromEmail.Get()) {
		var ret string
		return ret
	}
	return *o.FromEmail.Get()
}

// GetFromEmailOk returns a tuple with the FromEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetFromEmailOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FromEmail.Get(), o.FromEmail.IsSet()
}

// HasFromEmail returns a boolean if a field has been set.
func (o *MessageOut) HasFromEmail() bool {
	if o != nil && o.FromEmail.IsSet() {
		return true
	}

	return false
}

// SetFromEmail gets a reference to the given NullableString and assigns it to the FromEmail field.
func (o *MessageOut) SetFromEmail(v string) {
	o.FromEmail.Set(&v)
}
// SetFromEmailNil sets the value for FromEmail to be an explicit nil
func (o *MessageOut) SetFromEmailNil() {
	o.FromEmail.Set(nil)
}

// UnsetFromEmail ensures that no value is present for FromEmail, not even an explicit nil
func (o *MessageOut) UnsetFromEmail() {
	o.FromEmail.Unset()
}

// GetFromNumber returns the FromNumber field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageOut) GetFromNumber() string {
	if o == nil || IsNil(o.FromNumber.Get()) {
		var ret string
		return ret
	}
	return *o.FromNumber.Get()
}

// GetFromNumberOk returns a tuple with the FromNumber field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageOut) GetFromNumberOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FromNumber.Get(), o.FromNumber.IsSet()
}

// HasFromNumber returns a boolean if a field has been set.
func (o *MessageOut) HasFromNumber() bool {
	if o != nil && o.FromNumber.IsSet() {
		return true
	}

	return false
}

// SetFromNumber gets a reference to the given NullableString and assigns it to the FromNumber field.
func (o *MessageOut) SetFromNumber(v string) {
	o.FromNumber.Set(&v)
}
// SetFromNumberNil sets the value for FromNumber to be an explicit nil
func (o *MessageOut) SetFromNumberNil() {
	o.FromNumber.Set(nil)
}

// UnsetFromNumber ensures that no value is present for FromNumber, not even an explicit nil
func (o *MessageOut) UnsetFromNumber() {
	o.FromNumber.Unset()
}

// GetSenderSource returns the SenderSource field value if set, zero value otherwise.
func (o *MessageOut) GetSenderSource() MessageOutSenderSource {
	if o == nil || IsNil(o.SenderSource) {
		var ret MessageOutSenderSource
		return ret
	}
	return *o.SenderSource
}

// GetSenderSourceOk returns a tuple with the SenderSource field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageOut) GetSenderSourceOk() (*MessageOutSenderSource, bool) {
	if o == nil || IsNil(o.SenderSource) {
		return nil, false
	}
	return o.SenderSource, true
}

// HasSenderSource returns a boolean if a field has been set.
func (o *MessageOut) HasSenderSource() bool {
	if o != nil && !IsNil(o.SenderSource) {
		return true
	}

	return false
}

// SetSenderSource gets a reference to the given MessageOutSenderSource and assigns it to the SenderSource field.
func (o *MessageOut) SetSenderSource(v MessageOutSenderSource) {
	o.SenderSource = &v
}

// GetSession returns the Session field value if set, zero value otherwise.
func (o *MessageOut) GetSession() MessageOutSession {
	if o == nil || IsNil(o.Session) {
		var ret MessageOutSession
		return ret
	}
	return *o.Session
}

// GetSessionOk returns a tuple with the Session field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageOut) GetSessionOk() (*MessageOutSession, bool) {
	if o == nil || IsNil(o.Session) {
		return nil, false
	}
	return o.Session, true
}

// HasSession returns a boolean if a field has been set.
func (o *MessageOut) HasSession() bool {
	if o != nil && !IsNil(o.Session) {
		return true
	}

	return false
}

// SetSession gets a reference to the given MessageOutSession and assigns it to the Session field.
func (o *MessageOut) SetSession(v MessageOutSession) {
	o.Session = &v
}

func (o MessageOut) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MessageOut) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	if o.Sender.IsSet() {
		toSerialize["sender"] = o.Sender.Get()
	}
	if !IsNil(o.Receiver) {
		toSerialize["receiver"] = o.Receiver
	}
	toSerialize["text"] = o.Text
	toSerialize["status"] = o.Status
	if !IsNil(o.RejectReason) {
		toSerialize["rejectReason"] = o.RejectReason
	}
	toSerialize["contactId"] = o.ContactId.Get()
	toSerialize["sessionId"] = o.SessionId.Get()
	toSerialize["messageTime"] = o.MessageTime
	toSerialize["avatar"] = o.Avatar.Get()
	if !IsNil(o.Deleted) {
		toSerialize["deleted"] = o.Deleted
	}
	toSerialize["charset"] = o.Charset.Get()
	toSerialize["charsetLabel"] = o.CharsetLabel.Get()
	toSerialize["firstName"] = o.FirstName.Get()
	toSerialize["lastName"] = o.LastName.Get()
	toSerialize["country"] = o.Country.Get()
	if o.Phone.IsSet() {
		toSerialize["phone"] = o.Phone.Get()
	}
	if o.Price.IsSet() {
		toSerialize["price"] = o.Price.Get()
	}
	toSerialize["partsCount"] = o.PartsCount.Get()
	if o.FromEmail.IsSet() {
		toSerialize["fromEmail"] = o.FromEmail.Get()
	}
	if o.FromNumber.IsSet() {
		toSerialize["fromNumber"] = o.FromNumber.Get()
	}
	if !IsNil(o.SenderSource) {
		toSerialize["senderSource"] = o.SenderSource
	}
	if !IsNil(o.Session) {
		toSerialize["session"] = o.Session
	}
	return toSerialize, nil
}

func (o *MessageOut) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"text",
		"status",
		"contactId",
		"sessionId",
		"messageTime",
		"avatar",
		"charset",
		"charsetLabel",
		"firstName",
		"lastName",
		"country",
		"partsCount",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varMessageOut := _MessageOut{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varMessageOut)

	if err != nil {
		return err
	}

	*o = MessageOut(varMessageOut)

	return err
}

type NullableMessageOut struct {
	value *MessageOut
	isSet bool
}

func (v NullableMessageOut) Get() *MessageOut {
	return v.value
}

func (v *NullableMessageOut) Set(val *MessageOut) {
	v.value = val
	v.isSet = true
}

func (v NullableMessageOut) IsSet() bool {
	return v.isSet
}

func (v *NullableMessageOut) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessageOut(val *MessageOut) *NullableMessageOut {
	return &NullableMessageOut{value: val, isSet: true}
}

func (v NullableMessageOut) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessageOut) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


