---
layout: page
title: О проекте
permalink: about/
lang: ru
---
<p class="message">
  <b>Polyglot</b> — плагин интернационализации с открытым исходным кодом для блогов <a href="http://jekyllrb.com">Jekyll</a>. Polyglot легко настроить и использовать с любым проектом, и он масштабируется до языков, которые вы хотите поддерживать. С резервной поддержкой отсутствующего контента, автоматической релятивизацией URL-адресов и <a href="{{site.baseurl}}/seo/">мощными рецептами SEO</a>, Polyglot позволяет любому многоязычному блогу сосредоточиться на содержании без грязной работы.
</p>

_`jekyll-polyglot` пока не поддерживается нативно в github-actions_

### Установка

{% highlight bash %}
gem install jekyll-polyglot
{% endhighlight %}

### Управление поддерживаемыми языками

В `_config.yml` следующие свойства управляют тем, какие языки поддерживаются вашим сайтом. Вы можете добавить поддержку нового языка, добавив его в эти значения (см. ниже). Языки идентифицируются по их официальным [кодам локали](https://developer.chrome.com/webstore/i18n).
```yml
languages: ["en", "es", "fr", "de"]
default_lang: "en"
exclude_from_localization: ["images", "fonts", "sitemap"]
url: https://polyglot.untra.io
```
* `languages:` массив кодов локали, идентифицирующих языки, поддерживаемые сайтом.
* `default_lang:` язык по умолчанию для сайта.
* `exclude_from_localization:` папки и каталоги, которые являются частью построенного сайта, но не нуждаются в локализации. Это в основном для сокращения времени сборки, и поскольку файлы ресурсов, такие как изображения и шрифты, являются большими частями сайта, это гарантирует, что они не будут без необходимости "переведены" или дублированы в выводе.
* `url` URL вашего статического сайта в продакшене.

### Добавление нового языка
Предполагая, что у вас уже есть функционирующий одноязычный сайт, добавление нового языка не будет тривиальным. _Чтобы действительно создать многоязычный сайт, вы должны ожидать, что вам придется пересоздать весь ваш контент на новом языке._ Это может показаться большой задачей, но рассмотрите перевод по частям. Контент — король; важнее, чтобы новые страницы и посты получили обновленные переводы. Создание многоязычного сайта сложно только в том случае, если вы требуете, чтобы он был идеально переведен с самого начала.

Во-первых, вы (и ваша команда, и ваши менеджеры тоже, если они у вас есть) должны обсудить и выбрать, какой контент вам нужно перевести для нового сайта. Вы должны выбрать предпочтительный базовый контент для перевода. Учитывайте аналитику, популярные страницы и посты блога, а также поток текущих и будущих пользователей на ваш сайт. В случае сомнений приоритизируйте страницы над старыми постами блога. Если это означает запустить новый язык раньше, старые посты могут потребовать больше усилий, чем они того стоят для перевода.

Во-вторых, вы должны (или настоятельно рекомендуется) обеспечить 100% покрытие богатого контента на вашем сайте. Это небольшие строки, встроенные более сложными способами. Есть несколько способов итерации по богатому контенту. Помните, вы должны поддерживать все маленькие строки на всех языках в вашем богатом контенте.

#### Многоязычный контент
Контент сайта бывает двух видов: **базовый** и **богатый**.

Базовый контент — это плоский текст постов блога, страниц и неинтерактивного контента. Думайте о страницах и постах. Базовый контент — это топливо для кликов на вашем сайте. Polyglot предоставляет резервную поддержку для базового контента.

Богатый контент интерактивен, ярок и состоит из более коротких строк. Думайте о навигационных панелях и выпадающих меню. Богатый контент более технический и удерживает ваших посетителей на сайте. _Нет резервной поддержки для отсутствующего богатого контента._

#### Инструменты Liquid
Следующие инструменты Liquid доступны для использования с jekyll-polyglot:

* **site.languages**

{% highlight html %}
{% raw %}
{% for lang in site.languages %}
  {{lang}}
{% endfor %}
{% endraw %}
{% endhighlight %}

`site.languages` указывает напрямую на массив `languages` в _config.yml. К нему можно получить доступ через Liquid.

* **site.default_lang**
{% highlight html %}
{% raw %}
  {{site.default_lang}}
{% endraw %}
{% endhighlight %}

`site.default_lang` указывает напрямую на строку `default_lang` в _config.yml. К нему можно получить доступ через Liquid.

* **site.active_lang**
{% highlight html %}
{% raw %}
{% if site.active_lang == "es" %}
  <h1>Hola! Como estas?</h1>
{% endif %}
{% endraw %}
{% endhighlight %}
`site.active_lang` — это код локали, для которой строится страница. Это `"de"` для немецкой версии страницы, `"es"` для испанской версии и так далее. К нему можно получить доступ через Liquid.

Используя эти инструменты, вы можете указать, как прикрепить правильный богатый контент.

* **page.rendered_lang**
{% highlight html %}
{% raw %}
{% if page.rendered_lang == site.active_lang %}
  <p>Welcome to our {{ site.active_lang }} webpage!</p>
{% else %}
  <p>webpage available in {{ page.rendered_lang }} only.</p>
{% endif %}
{% endraw %}
{% endhighlight %}

Переменная `page.rendered_lang` указывает фактический язык содержимого страницы, позволяя шаблонам определять, когда страница отображается как резервный контент.

### Поддержка Github Pages
По умолчанию Github не позволяет [блогам Jekyll использовать плагины](https://help.github.com/articles/using-jekyll-with-pages/#configuration-overrides). Это сделано намеренно, чтобы предотвратить выполнение вредоносного кода на серверах Github. Хотя это усложняет использование Polyglot (и других плагинов Jekyll), это все еще возможно.

#### Сборка `_site/` в gh-pages
Вместо того чтобы размещать ваш движок блога Jekyll на Github, вы можете разрабатывать ваш сайт Jekyll на отдельной ветке, а затем пушить построенное содержимое `_site/` в вашу ветку `gh-pages`. Это позволяет вам управлять и контролировать версии вашей разработки сайта с помощью Github *без необходимости полагаться на Github для сборки вашего сайта!*

Вы можете сделать это, поддерживая ваш контент Jekyll на отдельной ветке и коммитя только папку `_site/` в вашу ветку gh-pages. Поскольку это просто статические HTML-страницы в папках, Github будет размещать их как любой другой контент [gh-pages](https://pages.github.com/).

#### Автоматизируйте это!

Этот процесс значительно упрощается с помощью простого скрипта, который соберет ваш сайт и закоммитит папку `_site/` в ваш gh-pages. У многих людей есть такой. [Вот один](http://www.jokecamp.com/blog/Simple-jekyll-deployment-with-a-shell-script-and-github/). [Вот другой](https://gist.github.com/cobyism/4730490). Вот [мой скрипт публикации](https://github.com/untra/polyglot/blob/main/publi.sh):
```bash
#! /bin/sh
# измените имена веток соответственно
rm -rf site/_site/
cd site && bundle exec jekyll build && cd ..
git add site/_site/ && git commit -m "$(date)"
git subtree push --prefix site/_site origin gh-pages
```
