% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal-.R
\name{new_continuous_palette}
\alias{new_continuous_palette}
\alias{new_discrete_palette}
\alias{is_pal}
\alias{is_continuous_pal}
\alias{is_discrete_pal}
\alias{is_colour_pal}
\alias{is_numeric_pal}
\alias{palette_nlevels}
\alias{palette_na_safe}
\alias{palette_type}
\alias{as_discrete_pal}
\alias{as_continuous_pal}
\title{Constructors for palettes}
\usage{
new_continuous_palette(fun, type, na_safe = NA)

new_discrete_palette(fun, type, nlevels = NA)

is_pal(x)

is_continuous_pal(x)

is_discrete_pal(x)

is_colour_pal(x)

is_numeric_pal(x)

palette_nlevels(pal)

palette_na_safe(pal)

palette_type(pal)

as_discrete_pal(x, ...)

as_continuous_pal(x, ...)
}
\arguments{
\item{fun}{A function to serve as a palette. For continuous palettes, these
typically take vectors of numeric values between (0, 1) and return a
vector of equal length. For discrete palettes, these typically take a
scalar integer and return a vector of that length.}

\item{type}{A string giving the type of return values. Some example strings
include \code{"colour"}, \code{"numeric"}, \code{"linetype"} or \code{"shape"}.}

\item{na_safe}{A boolean indicating whether \code{NA} values are translated to
palette values (\code{TRUE}) or are kept as \code{NA} (\code{FALSE}). Applies to
continuous palettes.}

\item{nlevels}{An integer giving the number of distinct palette values
that can be returned by the discrete palette.}

\item{x}{An object to test or coerce.}

\item{pal}{A palette to retrieve properties from.}

\item{...}{Additional arguments. Currently not in use.}
}
\value{
For \code{new_continuous_palette()}, \code{new_discret_palette()}, \code{as_discrete_pal()}
and \code{as_continuous_pal()}: a function of class \code{pal_continuous} or \code{pal_discrete}.
For \code{is_pal()}, \code{is_continuous_pal()}, \code{is_discret_pal()}, \code{is_colour_pal()},
or \code{is_numeric_pal()}: a logical value of length 1.
For \code{palette_nlevels()} a single integer. For \code{palette_na_safe()} a boolean.
For \code{palette_type()} a string.
}
\description{
These constructor functions attach metadata to palette functions. This
metadata can be used in testing or coercion.
}
\examples{
# Creating a new discrete palette
new_discrete_palette(
  fun = grDevices::terrain.colors,
  type = "colour", nlevels = 255
)

# Creating a new continuous palette
new_continuous_palette(
  fun = function(x) rescale(x, to = c(1, 0)),
  type = "numeric", na_safe = FALSE
)

# Testing palette properties
is_continuous_pal(pal_seq_gradient())
is_discrete_pal(pal_viridis())
is_numeric_pal(pal_area())
is_colour_pal(pal_manual(c("red", "green")))
is_pal(transform_log10())

# Extracting properties
palette_nlevels(pal_viridis())
palette_na_safe(colour_ramp(c("red", "green"), na.color = "grey50"))
palette_type(pal_shape())

# Switching discrete to continuous
pal <- as_continuous_pal(pal_viridis())
show_col(pal(c(0, 0.1, 0.2, 0.4, 1)))

# Switching continuous to discrete
pal <- as_discrete_pal(pal_div_gradient())
show_col(pal(9))
}
\seealso{
\link[=palette-recommendations]{palette recommendations}
}
