% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reframe.R
\name{reframe.dtplyr_step}
\alias{reframe.dtplyr_step}
\title{Summarise each group to one row}
\usage{
\method{reframe}{dtplyr_step}(.data, ..., .by = NULL)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}>

Name-value pairs of functions. The name will be the name of the variable in
the result. The value can be a vector of any length.

Unnamed data frame values add multiple columns from a single expression.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}
}
\description{
This is a method for the dplyr \code{\link[dplyr:reframe]{dplyr::reframe()}} generic. It is translated to
the \code{j} argument of \verb{[.data.table}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(mtcars)

dt \%>\%
  reframe(qs = quantile(disp, c(0.25, 0.75)),
          prob = c(0.25, 0.75),
          .by = cyl)

dt \%>\%
  group_by(cyl) \%>\%
  reframe(qs = quantile(disp, c(0.25, 0.75)),
          prob = c(0.25, 0.75))
}
