# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_mongodb.py'
# DO NOT CHANGE! Change the original file instead.
import contextlib
from collections.abc import Generator
from datetime import datetime, timedelta, timezone
from typing import Any

import pytest
from bson import ObjectId
from dirty_equals import IsDatetime, IsFloat, IsInstance
from inline_snapshot import snapshot
from key_value.shared.stores.wait import wait_for_true
from key_value.shared.utils.managed_entry import ManagedEntry
from pymongo import MongoClient
from typing_extensions import override

from key_value.sync.code_gen.stores.base import BaseStore
from key_value.sync.code_gen.stores.mongodb import MongoDBStore
from key_value.sync.code_gen.stores.mongodb.store import MongoDBSerializationAdapter, MongoDBV1CollectionSanitizationStrategy
from tests.code_gen.conftest import docker_container, should_skip_docker_tests
from tests.code_gen.stores.base import BaseStoreTests, ContextManagerStoreTestMixin

# MongoDB test configuration
MONGODB_HOST = "localhost"
MONGODB_HOST_PORT = 27017
MONGODB_TEST_DB = "kv-store-adapter-tests"

WAIT_FOR_MONGODB_TIMEOUT = 30
# Older supported version
# Latest stable version
MONGODB_VERSIONS_TO_TEST = ["5.0", "8.0"]


def ping_mongodb() -> bool:
    try:
        client: MongoClient[Any] = MongoClient[Any](host=MONGODB_HOST, port=MONGODB_HOST_PORT)
        _ = client.list_database_names()
    except Exception:
        return False

    return True


class MongoDBFailedToStartError(Exception):
    pass


def test_managed_entry_document_conversion():
    """Test that documents are stored as BSON dicts."""
    created_at = datetime(year=2025, month=1, day=1, hour=0, minute=0, second=0, tzinfo=timezone.utc)
    expires_at = created_at + timedelta(seconds=10)

    managed_entry = ManagedEntry(value={"test": "test"}, created_at=created_at, expires_at=expires_at)

    adapter = MongoDBSerializationAdapter()
    document = adapter.dump_dict(entry=managed_entry)

    assert document == snapshot(
        {
            "version": 1,
            "value": {"object": {"test": "test"}},
            "created_at": datetime(2025, 1, 1, 0, 0, tzinfo=timezone.utc),
            "expires_at": datetime(2025, 1, 1, 0, 0, 10, tzinfo=timezone.utc),
        }
    )

    round_trip_managed_entry = adapter.load_dict(data=document)

    assert round_trip_managed_entry.value == managed_entry.value
    assert round_trip_managed_entry.created_at == created_at
    assert round_trip_managed_entry.ttl == IsFloat(lt=0)
    assert round_trip_managed_entry.expires_at == expires_at


def clean_mongodb_database(store: MongoDBStore) -> None:
    with contextlib.suppress(Exception):
        _ = store._client.drop_database(name_or_database=store._db.name)  # pyright: ignore[reportPrivateUsage]


@pytest.mark.filterwarnings("ignore:A configured store is unstable and may change in a backwards incompatible way. Use at your own risk.")
class BaseMongoDBStoreTests(ContextManagerStoreTestMixin, BaseStoreTests):
    """Base class for MongoDB store tests."""

    @pytest.fixture(autouse=True, scope="session", params=MONGODB_VERSIONS_TO_TEST)
    def setup_mongodb(self, request: pytest.FixtureRequest) -> Generator[None, None, None]:
        version = request.param

        with docker_container(f"mongodb-test-{version}", f"mongo:{version}", {str(MONGODB_HOST_PORT): MONGODB_HOST_PORT}):
            if not wait_for_true(bool_fn=ping_mongodb, tries=WAIT_FOR_MONGODB_TIMEOUT, wait_time=1):
                msg = f"MongoDB {version} failed to start"
                raise MongoDBFailedToStartError(msg)

            yield

    @pytest.mark.skip(reason="Distributed Caches are unbounded")
    @override
    def test_not_unbounded(self, store: BaseStore): ...

    @override
    def test_long_collection_name(self, store: MongoDBStore, sanitizing_store: MongoDBStore):  # pyright: ignore[reportIncompatibleMethodOverride]
        with pytest.raises(Exception):  # noqa: B017, PT011
            store.put(collection="test_collection" * 100, key="test_key", value={"test": "test"})

        sanitizing_store.put(collection="test_collection" * 100, key="test_key", value={"test": "test"})
        assert sanitizing_store.get(collection="test_collection" * 100, key="test_key") == {"test": "test"}

    @override
    def test_special_characters_in_collection_name(self, store: MongoDBStore, sanitizing_store: MongoDBStore):  # pyright: ignore[reportIncompatibleMethodOverride]
        "Tests that special characters in the collection name will not raise an error."
        with pytest.raises(Exception):  # noqa: B017, PT011
            store.put(collection="test_collection!@#$%^&*()", key="test_key", value={"test": "test"})

        sanitizing_store.put(collection="test_collection!@#$%^&*()", key="test_key", value={"test": "test"})
        assert sanitizing_store.get(collection="test_collection!@#$%^&*()", key="test_key") == {"test": "test"}

    def test_mongodb_collection_name_sanitization(self, sanitizing_store: MongoDBStore):
        """Tests that the V1 sanitization strategy produces the expected collection names."""
        sanitizing_store.put(collection="test_collection!@#$%^&*()", key="test_key", value={"test": "test"})
        assert sanitizing_store.get(collection="test_collection!@#$%^&*()", key="test_key") == {"test": "test"}

        collections = sanitizing_store._collections_by_name.values()
        collection_names = [collection.name for collection in collections]
        assert collection_names == snapshot(["S_test_collection_-daf4a2ec"])


@pytest.mark.skipif(should_skip_docker_tests(), reason="Docker is not available")
class TestMongoDBStore(BaseMongoDBStoreTests):
    """Test MongoDBStore with native BSON storage."""

    @override
    @pytest.fixture
    def store(self, setup_mongodb: None) -> MongoDBStore:
        store = MongoDBStore(url=f"mongodb://{MONGODB_HOST}:{MONGODB_HOST_PORT}", db_name=MONGODB_TEST_DB)

        clean_mongodb_database(store=store)

        return store

    @pytest.fixture
    def sanitizing_store(self, setup_mongodb: None) -> MongoDBStore:
        store = MongoDBStore(
            url=f"mongodb://{MONGODB_HOST}:{MONGODB_HOST_PORT}",
            db_name=f"{MONGODB_TEST_DB}-sanitizing",
            collection_sanitization_strategy=MongoDBV1CollectionSanitizationStrategy(),
        )

        clean_mongodb_database(store=store)

        return store

    def test_value_stored_as_bson_dict(self, store: MongoDBStore):
        """Verify values are stored as BSON dicts, not JSON strings."""
        store.put(collection="test", key="test_key", value={"name": "Alice", "age": 30})

        # Get the raw MongoDB document
        store._setup_collection(collection="test")  # pyright: ignore[reportPrivateUsage]
        sanitized_collection = store._sanitize_collection(collection="test")  # pyright: ignore[reportPrivateUsage]
        collection = store._collections_by_name[sanitized_collection]  # pyright: ignore[reportPrivateUsage]
        doc = collection.find_one({"key": "test_key"})

        assert doc == snapshot(
            {
                "_id": IsInstance(expected_type=ObjectId),
                "key": "test_key",
                "collection": "test",
                "created_at": IsDatetime(),
                "value": {"object": {"name": "Alice", "age": 30}},
                "version": 1,
            }
        )
