# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_passthrough_cache.py'
# DO NOT CHANGE! Change the original file instead.
import tempfile
from collections.abc import Generator

import pytest
from typing_extensions import override

from key_value.sync.code_gen.stores.disk.store import DiskStore
from key_value.sync.code_gen.stores.memory.store import MemoryStore
from key_value.sync.code_gen.wrappers.passthrough_cache import PassthroughCacheWrapper
from tests.code_gen.stores.base import BaseStoreTests

DISK_STORE_SIZE_LIMIT = 100 * 1024  # 100KB


class TestPassthroughCacheWrapper(BaseStoreTests):
    @pytest.fixture(scope="session")
    def primary_store(self) -> Generator[DiskStore, None, None]:
        with tempfile.TemporaryDirectory() as temp_dir, DiskStore(directory=temp_dir, max_size=DISK_STORE_SIZE_LIMIT) as disk_store:
            yield disk_store

    @pytest.fixture
    def cache_store(self, memory_store: MemoryStore) -> MemoryStore:
        return memory_store

    @override
    @pytest.fixture
    def store(self, primary_store: DiskStore, cache_store: MemoryStore) -> PassthroughCacheWrapper:
        primary_store._cache.clear()  # pyright: ignore[reportPrivateUsage]
        return PassthroughCacheWrapper(primary_key_value=primary_store, cache_key_value=cache_store)
